/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.modules.commands.LoadTestGenerator;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.AbstractMessageReceiver;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="loadTestCommand", parent=PubSubComponent.class, active=true)
public class LoadTestCommand
implements AdHocCommand {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject
    private IPubSubConfig config;
    @Inject
    private IPubSubRepository repository;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(request.getSender())) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Load Test", "To start load test fill the form");
                form.addField(Field.fieldTextSingle((String)"nodeId", (String)"", (String)"Node"));
                form.addField(Field.fieldTextSingle((String)"time", (String)"60", (String)"Time of the test [s]"));
                form.addField(Field.fieldTextSingle((String)"frequency", (String)"1", (String)"Publishing frequency [push/s]"));
                form.addField(Field.fieldTextSingle((String)"length", (String)"20", (String)"Published messages size"));
                form.addField(Field.fieldBoolean((String)"nonBlocking", (Boolean)Boolean.FALSE, (String)"Use non-blocking adding"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    BareJID service = request.getIq().getStanzaTo().getBareJID();
                    long time = form.getAsLong("time");
                    long frequency = form.getAsLong("frequency");
                    int length = form.getAsInteger("length");
                    String nodeName = form.getAsString("nodeId");
                    Boolean nonBlocking = form.getAsBoolean("nonBlocking");
                    AbstractNodeConfig cfg = this.repository.getNodeConfig(service, nodeName);
                    if (cfg != null) {
                        IAffiliations subscriptions = this.repository.getNodeAffiliations(service, nodeName);
                        UsersAffiliation owner = null;
                        UsersAffiliation publisher = null;
                        for (UsersAffiliation a : subscriptions.getAffiliations()) {
                            if (publisher == null && a.getAffiliation().isPublishItem()) {
                                publisher = a;
                            }
                            if (owner == null && a.getAffiliation() == Affiliation.owner) {
                                owner = a;
                            }
                            if (owner != null && publisher != null) break;
                        }
                        if (owner == null && publisher == null) {
                            f = new Form(null, "Info", "Can't find publisher!");
                            response.getElements().add(f.getElement());
                        } else {
                            this.startLoadTest(service, nodeName, owner != null ? owner.getJid() : publisher.getJid(), time, frequency, length, nonBlocking == null ? true : nonBlocking == false);
                            f = new Form(null, "Info", "Load Test started");
                            response.getElements().add(f.getElement());
                        }
                    } else {
                        Form f = new Form(null, "Info", "Load Test cancelled. Node " + nodeName + " doesn't exists.");
                        response.getElements().add(f.getElement());
                    }
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "Error processing load test command", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Load Test";
    }

    public String getNode() {
        return "load-test";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }

    private void startLoadTest(BareJID serviceJid, String nodeName, BareJID publisher, Long time, Long frequency, Integer length, boolean useBlockingMethod) throws RepositoryException, UserNotFoundException, TigaseDBException {
        LoadTestGenerator r = new LoadTestGenerator(this.component, serviceJid, nodeName, publisher, time, frequency, length, useBlockingMethod){

            @Override
            protected void onTestFinish() {
                LoadTestCommand.this.log.log(Level.CONFIG, "Test finished. Published " + this.getCounter() + " items in " + (this.getTestEndTime() - this.getTestStartTime()) / 1000L + " seconds.");
            }
        };
        this.log.log(Level.CONFIG, "Staring load test.");
        new Thread(r).start();
    }
}

