/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.licence.InstallationIdRetriever;
import tigase.licence.LicenceChecker;
import tigase.licence.a;
import tigase.licence.utils.DataLoader;
import tigase.licence.utils.VHostsRetriever;
import tigase.stats.collector.provider.HTTPException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class LicenceRetriever {
    private static final Logger a = Logger.getLogger("tigase.licence");
    private final String b = "https://license.tigase.software/retrieve";
    private DataLoader c = new DataLoader();
    private static final int d = 32;
    private static final Pattern e = Pattern.compile("^[0-9A-Z]{33}$");

    public Element loadData(String url, String installationId, String componentId, List<JID> managedVHosts, Map<String, String> additionalMetrics) throws Exception {
        String string;
        String string2 = this.a(installationId, componentId, managedVHosts, additionalMetrics);
        String string3 = string = url == null ? "https://license.tigase.software/retrieve" : url;
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Loading data, encodedData: {0}, url: {1}", new Object[]{string2, string});
        }
        return this.c.loadData(string, string2);
    }

    String a(String string, String string2, List<JID> list) {
        return this.a(string, string2, list, Collections.emptyMap());
    }

    String a(String string, String string2, List<JID> list, Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<data><fields>");
        if (string != null) {
            stringBuffer.append("<item><var>installation-id</var><value>").append(string).append("</value></item>");
        }
        if (string2 != null) {
            stringBuffer.append("<item><var>module</var><value>").append(string2).append("</value></item>");
        }
        DataLoader.addRequestItems(stringBuffer, "vhosts", list);
        DataLoader.addRequestItems(stringBuffer, map);
        stringBuffer.append("</fields></data>");
        return stringBuffer.toString();
    }

    String a(String string) {
        try {
            Optional<Map<String, String>> optional;
            Element element;
            String string2 = InstallationIdRetriever.a().b();
            if (!LicenceRetriever.isValid(string2)) {
                a.log(Level.WARNING, "Invalid InstallationID: " + string2);
                return null;
            }
            List<JID> list = VHostsRetriever.getManagedVHosts();
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Loading data, installationId: {0}, managedVHosts: {1}", new Object[]{string2, list});
            }
            if ((element = this.loadData(null, string2, string, list, (optional = LicenceChecker.getLicenceChecker(string).d().b()).orElse(Collections.emptyMap()))) != null) {
                return this.extractLicenceText(element);
            }
            return null;
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "Cannot retrieve licence: " + exception.getMessage());
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Cannot retrieve licence: " + exception.getMessage() + (String)(exception instanceof HTTPException ? ", code: " + ((HTTPException)exception).getStatusCode() : ""), exception);
            }
            return null;
        }
    }

    protected static boolean isValid(String id) {
        return id != null && !id.startsWith("Error") && id.length() == 33 && e.matcher(id).matches();
    }

    protected String extractLicenceText(Element e) {
        List list = e.getChildrenStaticStr(new String[]{"command", "fields", "item", "value"});
        Object object = "";
        for (Element element : list) {
            object = (String)object + element.getCData() + "\n";
        }
        if (((String)object).contains("signature=")) {
            return object;
        }
        return new String(tigase.licence.a.a((String)object));
    }
}

