/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.cluster.SessionManagerClustered;
import tigase.server.ComponentRegistrator;
import tigase.server.MessageReceiver;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsCollector;
import tigase.stats.collector.StatisticsData;
import tigase.sys.TigaseRuntime;
import tigase.util.dns.DNSResolverFactory;
import tigase.vhosts.VHostManager;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class LicenceCheckerUpdater {
    private static final Logger a = Logger.getLogger("tigase.stats");
    private static final BareJID b = BareJID.bareJIDInstanceNS((String)"invalid-hostname");
    private static SessionManager c;
    private static VHostManagerIfc d;
    private static StatisticsCollector e;
    private static final JID f;

    public static int getClusterNodesCount() {
        int n = c instanceof SessionManagerClustered ? ((SessionManagerClustered)c).getStrategy().getNodesConnected().size() + 1 : 0;
        return n;
    }

    protected static Element getComponentInfo() {
        Element element = new Element("components");
        try {
            element.addChildren(Stream.concat(XMPPServer.getComponents(MessageReceiver.class), XMPPServer.getComponents(ComponentRegistrator.class)).distinct().map(serverComponent -> serverComponent.getComponentInfo().toElement()).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Problem obtaining components info", exception);
        }
        return element;
    }

    protected static long getHeapMax() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemMax();
    }

    protected static long getHeapUsed() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsed();
    }

    protected static BareJID getHostname() {
        BareJID bareJID = null;
        try {
            String string = DNSResolverFactory.getInstance().getDefaultHost();
            bareJID = string != null && !string.trim().isEmpty() ? BareJID.bareJIDInstance((String)string) : (c != null && c.getDefVHostItem() != null ? c.getDefVHostItem() : b);
        }
        catch (Exception exception) {
            bareJID = b;
            a.log(Level.SEVERE, "Error during obtaining hostname", exception);
        }
        return bareJID;
    }

    protected static long getMaxSessionsToday() {
        return LicenceCheckerUpdater.a("sess-man/Maximum user sessions today");
    }

    protected static long getMaxSessionsYesterday() {
        return LicenceCheckerUpdater.a("sess-man/Maximum user sessions yesterday");
    }

    public static Optional<StatisticsCollector> getStats() {
        if (e == null) {
            LicenceCheckerUpdater.init();
        }
        return Optional.ofNullable(e);
    }

    protected static long getUptime() {
        return TigaseRuntime.getTigaseRuntime().getUptime();
    }

    private static long a(String string) {
        if (LicenceCheckerUpdater.getStats().isPresent()) {
            String string2 = (String)LicenceCheckerUpdater.getStats().get().getAllStats().getValue(string);
            return string2 != null ? Long.parseLong(string2) : -1L;
        }
        return -1L;
    }

    protected static long getUserActive() {
        return LicenceCheckerUpdater.a("sess-man/Active user connections");
    }

    protected static long getUserOnline() {
        return LicenceCheckerUpdater.a("sess-man/Open user connections");
    }

    protected static List<BareJID> getVHosts() {
        return d.getAllVHosts().stream().filter(jID -> !jID.equals((Object)f)).map(JID::getBareJID).collect(Collectors.toList());
    }

    protected static void init() {
        c = (SessionManager)XMPPServer.getComponent(SessionManager.class);
        e = (StatisticsCollector)XMPPServer.getComponent(StatisticsCollector.class);
        d = (VHostManagerIfc)XMPPServer.getComponent(VHostManager.class);
    }

    public static StatisticsData updateData() {
        a.finest("updating statistics data");
        StatisticsData statisticsData = null;
        try {
            LicenceCheckerUpdater.init();
            statisticsData = new StatisticsData(LicenceCheckerUpdater.getHostname());
            statisticsData.addVHosts(LicenceCheckerUpdater.getVHosts());
            statisticsData.setUptime(LicenceCheckerUpdater.getUptime());
            statisticsData.setHeapUsed(LicenceCheckerUpdater.getHeapUsed());
            statisticsData.setHeapMax(LicenceCheckerUpdater.getHeapMax());
            statisticsData.setUsersOnline(LicenceCheckerUpdater.getUserOnline());
            statisticsData.setUsersActive(LicenceCheckerUpdater.getUserActive());
            statisticsData.setClusterNodesCount(LicenceCheckerUpdater.getClusterNodesCount());
            statisticsData.setMaxSessionsToday(LicenceCheckerUpdater.getMaxSessionsToday());
            statisticsData.setMaxSessionsYesterday(LicenceCheckerUpdater.getMaxSessionsYesterday());
            statisticsData.setAdditionalData(LicenceCheckerUpdater.getComponentInfo().toString());
        }
        catch (Throwable throwable) {
            a.log(Level.INFO, "Problem creating StatisticsData", throwable);
        }
        return statisticsData;
    }

    public String getMissingLicenseWarning() {
        return "This installation contains Tigase ACS package, not an open source software.\nThe Tigase ACS is only available under a commercial license.\nThe full text of the commercial license agreement is available upon request.\n\nThe Tigase ACS component is provided free of charge for testing and\ndevelopment purposes only. Any use of the component on production systems,\neither commercial or not-for-profit, requires the purchase of a license.\n\nIf the Tigase ACS component is activated without a valid license, it will\ncontinue to work, including its full set of features, but it will send\ncertain statistical information to Tigase's servers on a regular basis.\nIf the Tigase ACS component cannot access our servers to send information,\nit will stop working. Once a valid license is installed, the Tigase ACS\ncomponent will stop sending statistical information to Tigase's servers.\n\nBy activating the Tigase ACS component without a valid license you agree\nand accept that the component will send certain statistical information\n(such as DNS domain names, vhost names, number of online users, number of\ncluster nodes, etc.) which may be considered confidential and proprietary\nby the user. You accept and confirm that such information, which may be\nconsidered confidential or proprietary, will be transferred to Tigase's\nservers and that you will not pursue any remedy at law as a result of the\ninformation transfer.\nIf the Tigase ACS component is installed but not activated, no statistical\ninformation will be sent to Tigase's servers.";
    }

    static {
        d = null;
        f = JID.jidInstanceNS((String)"default");
    }
}

