/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.licence.InstallationIdRetriever;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckDailyTask;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceLoader;
import tigase.licence.LicenceLoaderFactory;
import tigase.licence.LicenceRetriever;
import tigase.licence.LicenceValidator;
import tigase.licence.b;
import tigase.licence.utils.TimeUtils;
import tigase.licence.utils.VHostsRetriever;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

public class LicenceChecker {
    private static final Logger f = Logger.getLogger("tigase.licence");
    private static Handler g = null;
    public static final String INSTALLATION_ID_KEY = "installation-id";
    public static final String MODULE_KEY = "module";
    public static final String STATISTICS_LOG_LEVEL = "statistics-log-level";
    public static final String TEST_MODE = "licence-library-test-mode";
    static final ScheduledExecutorService a = Executors.newSingleThreadScheduledExecutor();
    static long b = TimeUnit.DAYS.toSeconds(1L);
    static long c = (long)(ThreadLocalRandom.current().nextDouble(1.0, 16.0) * 60.0);
    static String d = null;
    static boolean e = false;
    private static boolean h = false;
    private boolean i = false;
    private final String j;
    private final File k;
    private Licence l;
    private Date m;
    private static final Map<String, LicenceChecker> n = new ConcurrentHashMap<String, LicenceChecker>(5);
    private ConcurrentHashMap<String, LicenceCheckerUpdateCallback> o;
    private final a p;

    public static String getCodeForLicenceRetrieval(String component) throws Exception {
        if (d == null) {
            throw new Exception("Installation-id is missing - can't retrieve the code");
        }
        List<JID> list = VHostsRetriever.getManagedVHosts();
        LicenceRetriever licenceRetriever = new LicenceRetriever();
        Optional<Map<String, String>> optional = LicenceChecker.getLicenceChecker(component).d().b();
        String string = licenceRetriever.a(d, component, list, optional.orElse(Collections.emptyMap()));
        return Base64.encode((byte[])string.getBytes("UTF-8"));
    }

    static String a(boolean bl) {
        if (bl && d == null) {
            d = InstallationIdRetriever.a().b();
        }
        return d;
    }

    public static String getInstallationId() {
        return LicenceChecker.a(false);
    }

    public static LicenceChecker getLicenceChecker(String cmpName) {
        return LicenceChecker.getLicenceChecker(cmpName, null);
    }

    public static LicenceChecker getLicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = Arrays.stream(stackTraceElementArray).skip(1L).limit(5L).map(stackTraceElement -> stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName()).collect(Collectors.joining(" > "));
        LicenceChecker licenceChecker = n.get(cmpName);
        f.log(Level.FINEST, "Getting checker for: {0}, callback: {1}, exists: {2} (from: {1})", new Object[]{cmpName, call, licenceChecker, string});
        if (licenceChecker == null) {
            if (call == null) {
                call = new LicenceCheckerUpdateCallbackImpl(cmpName);
            }
            licenceChecker = new LicenceChecker(cmpName, call);
            n.put(cmpName, licenceChecker);
        } else if (call != null) {
            licenceChecker.a(call);
        }
        return licenceChecker;
    }

    public static Set<String> getLicencedComponents() {
        return Collections.unmodifiableSet(n.keySet());
    }

    public static Element getLicencingDetails(String component) {
        Element element = new Element("licence-details");
        element.addChild((XMLNodeIfc)new Element(INSTALLATION_ID_KEY, LicenceChecker.a(true)));
        element.addChild((XMLNodeIfc)new Element(MODULE_KEY, component));
        List<JID> list = VHostsRetriever.getManagedVHosts();
        if (list != null && !list.isEmpty()) {
            element.addChild((XMLNodeIfc)new Element("vhosts", list.stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        return element;
    }

    static void a() {
        if (Boolean.getBoolean(TEST_MODE)) {
            h = true;
            c = 10L;
            b = TimeUnit.MINUTES.toSeconds(5L);
            f.log(Level.WARNING, "Licence library running in demo/test mode (faster checks! initial delay: {0}, daily delay: {1})", new Object[]{TimeUtils.formatDuration(c), TimeUtils.formatDuration(b)});
        }
    }

    public static boolean isTestMode() {
        return h;
    }

    private LicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        LicenceChecker.a();
        String string = h ? Level.ALL.getName() : Level.FINE.getName();
        String string2 = System.getProperty(STATISTICS_LOG_LEVEL, string);
        this.a(Level.parse(string2));
        this.o = new ConcurrentHashMap<String, LicenceCheckerUpdateCallback>(Map.of(call.getID(), call));
        this.j = cmpName;
        this.p = new a();
        LicenceChecker.e();
        f.log(Level.CONFIG, "Created licence checker for {0}", cmpName);
        this.k = new File("etc/" + this.j + ".licence");
    }

    private static synchronized void e() {
        if (!e) {
            f.log(Level.CONFIG, "Initial check delay: {0}, daily delay: {1}", new Object[]{TimeUtils.formatDuration(c), TimeUtils.formatDuration(b)});
            a.scheduleAtFixedRate(new LicenceCheckDailyTask(n), c, b, TimeUnit.SECONDS);
            e = true;
        }
    }

    public boolean isLicenceShown() {
        return this.i;
    }

    public Licence reloadLicenceFromServer() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        return this.c(true);
    }

    public String getComponentName() {
        return this.j;
    }

    public String getLicenceDigest() {
        if (this.l != null) {
            return this.l.getLicenceDigest();
        }
        return null;
    }

    public Date getValidUntil() {
        return this.m;
    }

    public void setLicenceShown() {
        this.i = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LicenceChecker{");
        stringBuilder.append("LICENCE_FILE=").append(this.k);
        stringBuilder.append(", componentName='").append(this.j).append('\'');
        stringBuilder.append(", initialCheckDelay=").append(c);
        stringBuilder.append(", subsequentCheckDelay=").append(b);
        stringBuilder.append(", updateCalls=").append(this.o);
        stringBuilder.append(", lic=").append(this.l);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    boolean b() {
        return this.b(false);
    }

    boolean b(boolean bl) {
        LicenceValidator.ValidationResult validationResult;
        try {
            this.l = this.c(bl);
        }
        catch (Exception exception) {
            f.log(Level.WARNING, "Can not load licence file. Error: {0}", new Object[]{exception.getMessage()});
            return false;
        }
        if (this.l == null) {
            f.log(Level.WARNING, "Missing licence file ({0})!", new Object[]{this.k});
            if (!bl && !this.isLicenceShown()) {
                f.log(Level.WARNING, this.d().c());
                this.setLicenceShown();
            }
            return false;
        }
        String string = this.l.getPropertyAsString("app-id");
        if (string == null || !string.equals(this.j)) {
            f.log(Level.WARNING, "This is not licence for {0} Component!", this.j);
            return false;
        }
        try {
            this.m = this.l.getPropertyAsDate("valid-until");
            validationResult = this.l.check();
        }
        catch (Exception exception) {
            f.log(Level.WARNING, "[" + this.j + "] Licence invalid", exception);
            return false;
        }
        switch (validationResult) {
            case invalidDates: {
                f.log(Level.WARNING, "[" + this.j + "] Licence expired.");
                return false;
            }
            case invalidVHosts: {
                f.log(Level.WARNING, "[" + this.j + "] VHost list does not match.");
                return false;
            }
            case invalidSignature: {
                f.log(Level.WARNING, "[" + this.j + "] Licence file has been tempered with!");
                return false;
            }
            case valid: {
                f.log(Level.CONFIG, "[" + this.j + "] Licence file is OK");
            }
        }
        return true;
    }

    Licence c() {
        return this.l;
    }

    a d() {
        return this.p;
    }

    private void a(LicenceCheckerUpdateCallback licenceCheckerUpdateCallback) {
        this.o.put(licenceCheckerUpdateCallback.getID(), licenceCheckerUpdateCallback);
    }

    private Licence a(LicenceLoader licenceLoader) {
        Licence licence;
        LicenceRetriever licenceRetriever = new LicenceRetriever();
        String string = licenceRetriever.a(this.j);
        if (f.isLoggable(Level.FINEST)) {
            f.log(Level.FINEST, "Loading licence for component: {0} from server, licenceData: ''{1}''", new Object[]{this.j, string});
        }
        if (string == null || string.isEmpty()) {
            f.log(Level.CONFIG, "Cannot load licence from Server.");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            licence = licenceLoader.loadLicence(byteArrayInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                f.log(Level.WARNING, "Cannot parse licence data.", exception);
                return null;
            }
        }
        byteArrayInputStream.close();
        return licence;
    }

    private Licence b(LicenceLoader licenceLoader) {
        Licence licence = this.a(licenceLoader);
        if (licence != null && licence instanceof b) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this.k));){
                ((b)licence).a(outputStreamWriter);
            }
            catch (Exception exception) {
                f.log(Level.WARNING, "Cannot store licence in file " + this.k, exception);
            }
        }
        return licence;
    }

    private Licence c(boolean bl) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        Licence licence;
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        if (f.isLoggable(Level.FINEST)) {
            f.log(Level.FINEST, "Trying to load licence file from file: {0} (exists: {1}, empty: {2}), forcing load from server: {3}", new Object[]{this.k, this.k.exists(), this.k.length() == 0L, bl});
        }
        if (bl && (licence = this.b(licenceLoader)) != null) {
            this.l = licence;
            return licence;
        }
        if (!this.k.exists() || this.k.length() == 0L) {
            f.log(Level.CONFIG, "Missing licence file ({0}), retrieving from the server!", new Object[]{this.k});
            if (!bl) {
                return this.b(licenceLoader);
            }
            return null;
        }
        licence = licenceLoader.loadLicence(this.k);
        try {
            Licence licence2;
            Date date = licence.getPropertyAsDate("valid-until");
            if (date != null && System.currentTimeMillis() > date.getTime() - TimeUnit.DAYS.toMillis(2L) && (licence2 = this.b(licenceLoader)) != null) {
                licence = licence2;
            }
            if (licence.getPropertyAsString(INSTALLATION_ID_KEY) == null) {
                f.log(Level.FINER, "Legacy Licence! Force reload from server!");
                licence2 = this.b(licenceLoader);
                if (licence2 != null) {
                    f.log(Level.FINER, "Loaded new licence from server: " + licence2);
                    licence = licence2;
                }
            }
        }
        catch (Exception exception) {
            f.log(Level.WARNING, "Ouch! We can't load new licence from server! ", this.k);
        }
        return licence;
    }

    private void a(Level level) throws SecurityException {
        Logger logger = Logger.getLogger("tigase.stats.collector");
        f.setLevel(level);
        f.setUseParentHandlers(false);
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        try {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.INFO);
            Handler handler = LicenceChecker.b(level);
            if (!Arrays.asList(f.getHandlers()).contains(handler)) {
                f.addHandler(handler);
                f.addHandler(consoleHandler);
            }
            if (!Arrays.asList(logger.getHandlers()).contains(handler)) {
                logger.addHandler(handler);
                logger.addHandler(consoleHandler);
            }
        }
        catch (IOException iOException) {
            f.log(Level.CONFIG, this.j);
        }
    }

    private static Handler b(Level level) throws IOException {
        if (g == null) {
            g = new FileHandler("logs/statistics.log", 10000000, 5, true);
            g.setLevel(level);
        }
        return g;
    }

    class a {
        a() {
        }

        public List<Element> a() {
            return LicenceChecker.this.o.values().stream().map(LicenceCheckerUpdateCallback::getComponentAdditionalData).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public Optional<Map<String, String>> b() {
            HashMap<String, String> hashMap = null;
            for (LicenceCheckerUpdateCallback licenceCheckerUpdateCallback : LicenceChecker.this.o.values()) {
                Optional<Map<String, String>> optional = licenceCheckerUpdateCallback.getServerVerifiableMetrics();
                if (!optional.isPresent()) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.putAll(optional.get());
            }
            return Optional.ofNullable(hashMap);
        }

        public String c() {
            return LicenceChecker.this.o.values().stream().map(LicenceCheckerUpdateCallback::getMissingLicenseWarning).distinct().collect(Collectors.joining("\n\n"));
        }

        public boolean a(Licence licence) {
            for (LicenceCheckerUpdateCallback licenceCheckerUpdateCallback : LicenceChecker.this.o.values()) {
                try {
                    if (licenceCheckerUpdateCallback.additionalValidation(licence)) continue;
                    return false;
                }
                catch (Exception exception) {
                    f.log(Level.SEVERE, "Validation of callback '" + licenceCheckerUpdateCallback + "' failed!", exception);
                    return false;
                }
            }
            return true;
        }
    }
}

