/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.cluster;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClusterRepoConstants;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.db.comp.ComponentRepositoryDataSourceAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="server-cluster", name="Tigase XMPP Server (Cluster)", external=false)
public class ClConMongoRepository
extends ClConConfigRepository
implements ClusterRepoConstants,
ComponentRepositoryDataSourceAware<tigase.cluster.repo.ClusterRepoItem, MongoDataSource> {
    private static final Logger log = Logger.getLogger(ClConMongoRepository.class.getCanonicalName());
    private static final int DEF_BATCH_SIZE = 100;
    private static final String CLUSTER_NODES = "tig_cluster_nodes";
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoCollection<Document> clusterNodes;
    private MongoDatabase db;

    public void destroy() {
        super.destroy();
    }

    public ClusterRepoItem getItemInstance() {
        return new ClusterRepoItem();
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        super.initRepository(resource_uri, params);
        try {
            if (this.db == null) {
                MongoDataSource ds = new MongoDataSource();
                ds.initRepository(resource_uri, params);
                this.setDataSource(ds);
            }
        }
        catch (Exception ex) {
            throw new DBInitException("Could not initialize MongoDB repository", (Throwable)ex);
        }
    }

    public void reload() {
        if (System.currentTimeMillis() - this.lastReloadTime <= this.autoReloadInterval * this.lastReloadTimeFactor) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Last reload performed in {0}, skipping: ", System.currentTimeMillis() - this.lastReloadTime);
            }
            return;
        }
        this.lastReloadTime = System.currentTimeMillis();
        super.reload();
        try {
            FindIterable cursor = this.db.getCollection(CLUSTER_NODES).find().batchSize(this.batchSize);
            for (Document dto : cursor) {
                ClusterRepoItem item = this.getItemInstance();
                item.setHostname((String)dto.get((Object)"_id"));
                item.setSecondaryHostname((String)dto.get((Object)"secondary"));
                item.setPassword((String)dto.get((Object)"password"));
                item.setLastUpdate(((Date)dto.get((Object)"updated")).getTime());
                item.setPort((Integer)dto.get((Object)"port"));
                item.setCpuUsage((Double)dto.get((Object)"cpu_usage"));
                item.setMemUsage((Double)dto.get((Object)"mem_usage"));
                this.itemLoaded(item);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", ex);
        }
        if (this.auto_remove_obsolete_items) {
            this.removeObsoloteItems(5000L);
        }
    }

    public void removeItem(String key) {
        super.removeItem(key);
        try {
            Document crit = new Document("_id", (Object)key);
            this.db.getCollection(CLUSTER_NODES).deleteMany((Bson)crit);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem removing element from DB: ", ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, CLUSTER_NODES)) {
            this.db.createCollection(CLUSTER_NODES);
        }
        this.clusterNodes = this.db.getCollection(CLUSTER_NODES);
    }

    public void store() {
    }

    public void storeItem(tigase.cluster.repo.ClusterRepoItem item) {
        try {
            Document crit = new Document("_id", (Object)item.getHostname());
            Document dto = new Document("password", (Object)item.getPassword()).append("secondary", (Object)item.getSecondaryHostname()).append("updated", (Object)new Date()).append("port", (Object)item.getPortNo()).append("cpu_usage", (Object)Float.valueOf(item.getCpuUsage())).append("mem_usage", (Object)Float.valueOf(item.getMemUsage()));
            this.db.getCollection(CLUSTER_NODES).updateOne((Bson)crit, (Bson)new Document("$set", (Object)dto), new UpdateOptions().upsert(true));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem setting element to DB: ", ex);
        }
    }

    private class ClusterRepoItem
    extends tigase.cluster.repo.ClusterRepoItem {
        private ClusterRepoItem() {
        }

        protected void setCpuUsage(Double cpuUsage) {
            super.setCpuUsage(cpuUsage == null ? 0.0f : cpuUsage.floatValue());
        }

        protected void setCpuUsage(float cpuUsage) {
            super.setCpuUsage(cpuUsage);
        }

        protected void setHostname(String hostname) {
            super.setHostname(hostname);
        }

        protected void setLastUpdate(long update) {
            super.setLastUpdate(update);
        }

        protected void setMemUsage(Double memUsage) {
            super.setMemUsage(memUsage == null ? 0.0f : memUsage.floatValue());
        }

        protected void setMemUsage(float memUsage) {
            super.setMemUsage(memUsage);
        }

        protected void setPassword(String password) {
            super.setPassword(password);
        }

        protected void setPort(int port) {
            super.setPort(port);
        }

        protected void setSecondaryHostname(String secondaryHostname) {
            super.setSecondaryHostname(secondaryHostname);
        }
    }
}

