/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPasswordLcd;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;

class SnmpUsmSecureUserImpl
implements SnmpUsmSecureUser {
    private String dbgTag = "SnmpUsmSecureUserImpl";
    String name = null;
    String securityName = null;
    String password = null;
    SnmpUsmAuthPair auth = null;
    SnmpUsmPrivPair priv = null;
    SnmpEngineId engineId = null;
    String CONF_SEPARATOR = ",";
    int storageType = 1;
    SnmpUsmLcd lcd = null;
    String privKey = null;
    String authKey = null;
    String strEngineId = null;
    String privProtocol = null;
    String authProtocol = null;
    boolean template = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmSecureUserImpl");

    SnmpUsmSecureUserImpl(SnmpUsmLcd lcd, SnmpEngineId engineId, String name) {
        this.init(lcd, engineId, name);
        this.securityName = name;
        this.strEngineId = engineId.toString();
    }

    SnmpUsmSecureUserImpl(SnmpUsmLcd lcd, SnmpEngineId engineId, String strEngineId, String name, String securityName, SnmpUsmAuthAlgorithm auth, String authProtocol, byte[] localAuthKey, String authKey, SnmpUsmPrivAlgorithm priv, String privProtocol, byte[] localPrivKey, String privKey, int storage, boolean template) {
        this.init(lcd, engineId, name);
        this.strEngineId = strEngineId;
        this.securityName = securityName;
        this.auth.algo = auth;
        this.authProtocol = authProtocol;
        this.auth.key = localAuthKey;
        this.priv.algo = priv;
        this.privProtocol = privProtocol;
        this.priv.key = localPrivKey;
        this.authKey = authKey;
        this.privKey = privKey;
        this.storageType = storage;
        this.template = template;
    }

    public void updateConfiguration() {
        ((SnmpUsmPasswordLcd)this.lcd).flushFile();
    }

    public int getSecurityLevel() {
        int val = 0;
        if (this.auth.algo != null && this.auth.key != null) {
            val |= 1;
        }
        if (this.priv.algo != null && this.priv.key != null) {
            val |= 2;
        }
        return val;
    }

    public byte[] getAuthDelta(byte[] newKey, byte[] random) {
        if (this.auth.algo == null) {
            return null;
        }
        return this.auth.algo.calculateAuthDelta(this.auth.key, newKey, random);
    }

    public byte[] getPrivDelta(byte[] newKey, byte[] random) {
        if (this.auth.algo == null || this.priv.algo == null) {
            return null;
        }
        return this.auth.algo.calculatePrivDelta(this.priv.key, newKey, random, this.priv.algo.getDeltaSize());
    }

    public void setAuthKeyChange(byte[] randomdelta) {
        if (this.auth.algo == null) {
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setAuthKeyChange", " auth algo : " + this.auth.algo);
        }
        this.auth.key = this.auth.algo.calculateNewAuthKey(this.auth.key, randomdelta);
        this.authKey = SnmpTools.binary2ascii(this.auth.key);
    }

    public void setPrivKeyChange(byte[] randomdelta) {
        if (this.priv.algo == null) {
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setPrivKeyChange", " priv algo : " + this.priv.algo);
        }
        this.priv.key = this.auth.algo.calculateNewPrivKey(this.priv.key, randomdelta, this.priv.algo.getDeltaSize());
        this.privKey = SnmpTools.binary2ascii(this.priv.key);
    }

    public void setAuthAlgorithm(String name) {
        if (name.equals("usmNoAuthProtocol") || name.equals("1.3.6.1.6.3.10.1.1.1")) {
            this.authProtocol = "usmNoAuthProtocol";
            this.auth.algo = null;
            this.auth.key = null;
            this.authKey = null;
            return;
        }
        this.auth.algo = (SnmpUsmAuthAlgorithm)this.lcd.getAlgorithmManager().getAlgorithm(name);
    }

    public void setPrivAlgorithm(String name) {
        if (name.equals("usmNoPrivProtocol") || name.equals("1.3.6.1.6.3.10.1.2.1")) {
            this.privProtocol = "usmNoPrivProtocol";
            this.priv.algo = null;
            this.priv.key = null;
            this.privKey = null;
            return;
        }
        this.priv.algo = (SnmpUsmPrivAlgorithm)this.lcd.getAlgorithmManager().getAlgorithm(name);
    }

    public String getName() {
        return this.name;
    }

    public void setSecurityName(String s) {
        this.securityName = s;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public SnmpEngineId getEngineId() {
        return this.engineId;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int s) {
        this.storageType = s;
    }

    public SnmpUsmAuthPair getAuthPair() {
        return this.auth;
    }

    public SnmpUsmPrivPair getPrivPair() {
        return this.priv;
    }

    public void cloneAuthPair(SnmpUsmAuthPair pair) {
        this.auth.algo = pair.algo;
        if (this.auth.algo != null) {
            this.authProtocol = this.auth.algo.getAlgorithm();
        }
        if (pair.key != null) {
            byte[] key = new byte[pair.key.length];
            for (int i = 0; i < key.length; ++i) {
                key[i] = pair.key[i];
            }
            this.auth.key = key;
            this.authKey = SnmpTools.binary2ascii(this.auth.key);
        }
    }

    public void clonePrivPair(SnmpUsmPrivPair pair) {
        this.priv.algo = pair.algo;
        if (this.priv.algo != null) {
            this.privProtocol = this.priv.algo.getAlgorithm();
        }
        if (pair.key != null) {
            byte[] key = new byte[pair.key.length];
            for (int i = 0; i < key.length; ++i) {
                key[i] = pair.key[i];
            }
            this.priv.key = key;
            this.privKey = SnmpTools.binary2ascii(this.priv.key);
        }
    }

    byte[] getAuthKey() {
        return this.auth.key;
    }

    byte[] getPrivKey() {
        return this.priv.key;
    }

    void setPrivKey(byte[] privKey) {
        this.priv.key = privKey;
    }

    void setAuthKey(byte[] authKey) {
        this.auth.key = authKey;
    }

    String getConf() {
        String authKeyConf = this.authKey == null ? this.CONF_SEPARATOR : this.authKey + this.CONF_SEPARATOR;
        String privKeyConf = this.privKey == null ? this.CONF_SEPARATOR : this.privKey + this.CONF_SEPARATOR;
        String securityNameConf = this.securityName == null ? this.CONF_SEPARATOR : this.securityName + this.CONF_SEPARATOR;
        String storageTypeConf = this.storageType + this.CONF_SEPARATOR;
        String authProtocolConf = this.authProtocol == null ? this.CONF_SEPARATOR : this.authProtocol + this.CONF_SEPARATOR;
        String privProtocolConf = this.privProtocol == null ? this.CONF_SEPARATOR : this.privProtocol + this.CONF_SEPARATOR;
        String conf = null;
        String mandatory = this.strEngineId + this.CONF_SEPARATOR + this.name + this.CONF_SEPARATOR + securityNameConf + authProtocolConf + authKeyConf + privProtocolConf + privKeyConf + storageTypeConf;
        conf = this.template ? mandatory + "true" : mandatory;
        return conf;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplateStatus(boolean status) {
        this.template = status;
    }

    private void init(SnmpUsmLcd lcd, SnmpEngineId engineId, String name) {
        this.engineId = engineId;
        this.name = name;
        this.lcd = lcd;
        this.auth = new SnmpUsmAuthPair();
        this.priv = new SnmpUsmPrivPair();
    }
}

