/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.DeploymentInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.ui.WarServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;

@Bean(name="webModule", active=true)
public class WebModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(WebModule.class.getCanonicalName());
    @ConfigField(desc="Path to WAR file", alias="war-path")
    protected String warPath;
    private DeploymentInfo deployment = null;
    @ConfigField(desc="Description of a module")
    protected String description = "Simple static WAR deployment module";

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void start() {
        if (this.deployment != null) {
            this.stop();
        }
        super.start();
        if (this.warPath != null) {
            this.deployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("User interface").setDeploymentDescription(this.getDescription()).addServlets(this.httpServer.servlet("WarServlet", WarServlet.class).addMapping("/*").addInitParam("war-path", this.warPath));
            if (this.vhosts != null) {
                this.deployment.setVHosts(this.vhosts);
            }
            this.httpServer.deploy(this.deployment);
        } else {
            log.log(Level.CONFIG, "not found file with Web UI - Web UI will not be available");
        }
    }

    @Override
    public void stop() {
        if (this.deployment != null) {
            this.httpServer.undeploy(this.deployment);
            this.deployment = null;
        }
        super.stop();
    }
}

