/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.admin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.admin.Servlet;
import tigase.http.util.AssetsServlet;
import tigase.http.util.StaticFileServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;

@Bean(name="admin", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class AdminModule
extends AbstractModule {
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/admin";
    private static final String SCRIPTS_DIR_KEY = "admin-scripts-dir";
    private static final String DESCRIPTION = "Admin console - support for management of server using simple HTTP console";
    private DeploymentInfo httpDeployment = null;
    @ConfigField(desc="Scripts directory", alias="admin-scripts-dir")
    private String scriptsDir = "scripts/admin";
    @Inject
    private AuthProvider authProvider;

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setAuthProvider(this.authProvider).setDeploymentName("Admin console").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        File scriptsDirFile = new File(this.scriptsDir);
        scriptsDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"static".equals(file.getName());
            }
        });
        ServletInfo servletInfo = this.httpServer.servlet("Servlet", Servlet.class);
        try {
            servletInfo.addInitParam("module-id-key", this.uuid).addInitParam("scripts-dir", scriptsDirFile.getCanonicalPath()).addMapping("/*");
        }
        catch (IOException ex) {
            Logger.getLogger(AdminModule.class.getName()).log(Level.WARNING, null, ex);
        }
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("AssetsServlet", AssetsServlet.class);
        servletInfo.addMapping("/assets/*");
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File(scriptsDirFile, "static").getAbsolutePath()).addMapping("/static/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }
}

