/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.modules;

import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.archive.unified.UnifiedArchiveComponent;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.db.DataSource;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.rsm.RSM;

@Bean(name="tigase-recent-query", parent=UnifiedArchiveComponent.class, active=true)
public class TigaseRecentQueryModule
implements Module {
    private static final Logger a = Logger.getLogger(TigaseRecentQueryModule.class.getCanonicalName());
    private static final String b = "urn:xmpp:tigase:recent";
    private static final String[] c = new String[]{"urn:xmpp:tigase:recent"};
    private final TimestampHelper d = new TimestampHelper();
    @Inject
    protected UnifiedArchiveRepository<DataSource> msg_repo;
    @Inject
    protected PacketWriter packetWriter;

    public String[] getFeatures() {
        return c;
    }

    public Criteria getModuleCriteria() {
        return ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)b));
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element element2 = packet.getElement().getChild("query", b);
        try {
            List list;
            Date date;
            Date date2;
            BareJID bareJID = packet.getStanzaFrom().getBareJID();
            try {
                date2 = this.d.parseTimestamp(element2.getAttributeStaticStr("start"));
            }
            catch (ParseException parseException) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value of attribute start", (Throwable)parseException);
            }
            try {
                date = this.d.parseTimestamp(element2.getAttributeStaticStr("end"));
            }
            catch (ParseException parseException) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value of attribute end", (Throwable)parseException);
            }
            Set<UnifiedArchiveRepository.Type> set = null;
            Set<UnifiedArchiveRepository.CallCondition> set2 = null;
            Element element3 = element2.getChild("event-types");
            if (element3 != null && (list = element3.getChildren()) != null) {
                set = list.stream().map(element -> {
                    try {
                        return UnifiedArchiveRepository.Type.valueOf(element.getName());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }).filter(type -> type != null).collect(Collectors.toSet());
                set2 = list.stream().filter(element -> element.getName() == "call").flatMap(element -> {
                    List list = element.getChildren();
                    return list == null ? Stream.empty() : list.stream();
                }).map(element -> {
                    try {
                        return UnifiedArchiveRepository.CallCondition.valueOf(element.getName());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }).collect(Collectors.toSet());
            }
            if (set == null) {
                set = EnumSet.allOf(UnifiedArchiveRepository.Type.class);
            }
            if (set2 == null || set2.isEmpty()) {
                set2 = EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class);
            }
            list = new RSM();
            list.fromElement(element2);
            List list2 = this.msg_repo.queryRecents(bareJID, date2, date, set, set2, (RSM)list).map(this::convertQueryItemResultToElement).collect(Collectors.toList());
            Element element4 = new Element("events", new String[]{"xmlns"}, new String[]{b});
            element4.addChildren(list2);
            element4.addChild((XMLNodeIfc)list.toElement());
            this.packetWriter.write(packet.okResult(element4, 0));
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.FINEST, "Failed to retrieve recent query items", tigaseDBException);
            throw new RuntimeException("Failed to retrieve recent query items", tigaseDBException);
        }
    }

    protected Element convertQueryItemResultToElement(UnifiedArchiveRepository.Item item) {
        Element element = new Element("event");
        element.setAttribute("with", item.getWith());
        element.setAttribute("direction", item.getDirection().toElementName());
        element.setAttribute("type", item.getItemType().getStringValue());
        element.setAttribute("time", this.d.format(item.getTimestamp()));
        switch (item.getItemType()) {
            case message: 
            case chat: 
            case groupchat: {
                String string;
                String string2 = item.getMessage().getCDataStaticStr(Message.MESSAGE_BODY_PATH);
                if (string2 != null) {
                    string = new Element("body", string2);
                    element.addChild((XMLNodeIfc)string);
                }
                if ((string = item.getMessage().getCDataStaticStr(Message.MESSAGE_SUBJECT_PATH)) == null) break;
                element.setAttribute("subject", XMLUtils.escape((String)XMLUtils.unescape((String)string)));
                break;
            }
            case call: {
                String string = item.getCondition();
                element.setAttribute("condition", string);
                if (!"success".equals(string) || item.getDuration() == null) break;
                element.setAttribute("duration", String.valueOf(item.getDuration()));
                break;
            }
        }
        return element;
    }
}

