/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.SignatureException;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class DefaultElementSigner
implements ElementSigner {
    private static final Logger a = Logger.getLogger(DefaultElementSigner.class.toString());
    private final Key b;

    public DefaultElementSigner(byte[] key) {
        this(new SecretKeySpec(key, "HmacSHA1"));
    }

    public DefaultElementSigner(Key key) {
        this.b = key;
    }

    @Override
    public Element sign(Element source) {
        try {
            String string = "" + System.currentTimeMillis();
            return this.a(source, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Element verify(Element msg) throws SignatureException {
        if (!msg.getName().equals("signature")) {
            throw new SignatureException("Unsupported element" + msg.toString());
        }
        String string = msg.getAttributeStaticStr("ver");
        try {
            if (string != null && "1".equals(string)) {
                return this.a(msg);
            }
            throw new SignatureException("Unsupported signature version (" + string + ")");
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Can't verify signature", exception);
        }
    }

    String a(final Mac mac, Element element, String string) {
        mac.update("timestamp=".getBytes());
        mac.update(string.getBytes());
        mac.update((byte)59);
        this.elementToBuffer(new a(){

            @Override
            public void a(CharSequence charSequence) {
                mac.update(charSequence.toString().getBytes());
            }
        }, element);
        String string2 = Base64.encode((byte[])mac.doFinal());
        return string2;
    }

    Element a(Element element, String string) {
        try {
            Mac mac = this.getMacInstance();
            mac.init(this.b);
            String string2 = this.a(mac, element, string);
            Element element2 = new Element("signature");
            element2.setAttribute("ver", "1");
            Element element3 = new Element("object");
            element3.addChild((XMLNodeIfc)element);
            Element element4 = new Element("signaturevalue", string2);
            Element element5 = new Element("timestamp", string);
            element2.addChild((XMLNodeIfc)element5);
            element2.addChild((XMLNodeIfc)element3);
            element2.addChild((XMLNodeIfc)element4);
            return element2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected Mac getMacInstance() throws NoSuchAlgorithmException {
        return Mac.getInstance("HmacSHA256");
    }

    protected synchronized void elementToBuffer(a result, Element element) {
        ArrayList arrayList;
        result.a("<");
        result.a(element.getName());
        if (element.getAttributes() != null) {
            arrayList = new ArrayList();
            arrayList.addAll(element.getAttributes().keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                result.a(" ");
                result.a(string);
                result.a("=\"");
                result.a((CharSequence)element.getAttributes().get(string));
                result.a("\"");
            }
        }
        if ((arrayList = element.getChildren()) != null && arrayList.size() != 0 || element.getCData() != null) {
            result.a(">");
            if (arrayList != null) {
                for (String string : element.getChildren()) {
                    this.elementToBuffer(result, (Element)string);
                }
            }
            if (element.getCData() != null) {
                result.a(element.getCData());
            }
            result.a("</");
            result.a(element.getName());
            result.a(">");
        } else {
            result.a("/>");
        }
    }

    private Element a(Element element) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Element element2 = (Element)element.getChild("object", null).getChildren().get(0);
        String string = element.getChild("timestamp", null).getCData();
        String string2 = element.getChild("signaturevalue", null).getCData();
        Mac mac = this.getMacInstance();
        mac.init(this.b);
        String string3 = this.a(mac, element2, string);
        if (!string3.equals(string2)) {
            throw new SignatureException("Invalid MAC!");
        }
        a.log(Level.FINEST, "DefaultElementSigner, object: " + element2 + ", timestamp: " + string + ", signaturevalue: " + string2);
        return element2;
    }

    static interface a {
        public void a(CharSequence var1);
    }
}

