/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.Affiliations;
import tigase.mix.Mix;
import tigase.mix.MixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.JIDVisibility;
import tigase.mix.model.MixLogic;
import tigase.mix.model.Participant;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.utils.Cache;
import tigase.pubsub.utils.LRUCacheWithFuture;
import tigase.server.DataForm;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="mixRepository", parent=MixComponent.class, active=true)
public class MixRepository<T>
implements IMixRepository,
IPubSubRepository.IListener,
CachedPubSubRepository.NodeAffiliationProvider<T> {
    private static final Logger log = Logger.getLogger(MixRepository.class.getCanonicalName());
    @Inject(nullAllowed=true)
    private MixLogic mixLogic;
    @Inject(nullAllowed=true)
    private PublishItemModule publishItemModule;
    @Inject
    private RetractItemModule retractItemModule;
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private PacketWriter packetWriter;
    private final Cache<BareJID, ChannelConfiguration> channelConfigs = new LRUCacheWithFuture(1000);
    private final Cache<ParticipantKey, Participant> participants = new LRUCacheWithFuture(4000);

    @Override
    public Optional<List<BareJID>> getAllowed(BareJID channelJID) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:allowed");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getItemsIds(CollectionItemsOrdering.byUpdateDate)).map(strings -> Arrays.stream(strings).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<BareJID>> getBanned(BareJID channelJID) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:banned");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getItemsIds(CollectionItemsOrdering.byUpdateDate)).map(strings -> Arrays.stream(strings).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList()));
    }

    @Override
    public List<String> getParticipantIds(BareJID channelJID) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:participants");
        if (items == null) {
            return Collections.emptyList();
        }
        String[] participantIds = items.getItemsIds(CollectionItemsOrdering.byUpdateDate);
        if (participantIds == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(participantIds);
    }

    @Override
    public IParticipant getParticipant(BareJID channelJID, BareJID participantRealJID) throws RepositoryException {
        String participantId = this.mixLogic.generateParticipantId(channelJID, participantRealJID);
        return this.getParticipant(channelJID, participantId);
    }

    @Override
    public IParticipant getParticipant(BareJID channelJID, String participantId) throws RepositoryException {
        return this.getParticipant(new ParticipantKey(channelJID, participantId));
    }

    protected IParticipant getParticipant(ParticipantKey key) throws RepositoryException {
        try {
            return (IParticipant)this.participants.computeIfAbsent((Object)key, () -> {
                try {
                    IItems items = this.pubSubRepository.getNodeItems(key.channelJID, "urn:xmpp:mix:nodes:participants");
                    if (items == null) {
                        return null;
                    }
                    IItems.IItem item = items.getItem(key.participantId);
                    if (item == null) {
                        return null;
                    }
                    return new Participant(key.participantId, item.getItem().getChild("participant", "urn:xmpp:mix:core:1"));
                }
                catch (RepositoryException ex) {
                    throw new Cache.CacheException((Throwable)ex);
                }
            });
        }
        catch (Cache.CacheException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void removeParticipant(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        String id = this.mixLogic.generateParticipantId(channelJID, participantJID);
        this.removeParticipant(channelJID, id);
    }

    @Override
    public void removeParticipant(BareJID channelJID, String participantId) throws RepositoryException {
        this.retractItemModule.retractItems(channelJID, "urn:xmpp:mix:nodes:participants", Collections.singletonList(participantId));
        this.participants.remove((Object)new ParticipantKey(channelJID, participantId));
    }

    @Override
    public IParticipant updateParticipant(BareJID channelJID, BareJID participantJID, String nick) throws RepositoryException, PubSubException {
        return this.updateParticipant(channelJID, this.mixLogic.generateParticipantId(channelJID, participantJID), participantJID, nick);
    }

    @Override
    public IParticipant updateTempParticipant(BareJID channelJID, JID participantJID, String nick) throws RepositoryException, PubSubException {
        Participant participant = this.updateParticipant(channelJID, this.mixLogic.generateTempParticipantId(channelJID, participantJID), participantJID.getBareJID(), nick);
        Element itemEl = new Element("item");
        itemEl.setAttribute("id", participant.getParticipantId());
        itemEl.withElement("muc-participant", "tigase:mix:muc:0", mucParticipant -> mucParticipant.addAttribute("jid", participantJID.toString()));
        this.publishItemModule.publishItems(channelJID, "tigase:mix:muc", participantJID, Collections.singletonList(itemEl), null);
        return participant;
    }

    protected Participant updateParticipant(BareJID channelJID, String participantId, BareJID participantJID, String nick) throws PubSubException, RepositoryException {
        ChannelConfiguration config = this.getChannelConfiguration(channelJID);
        boolean hideJid = config != null && config.getJidVisibility() == JIDVisibility.hidden;
        Participant participant = new Participant(participantId, hideJid ? null : participantJID, nick);
        Element itemEl = new Element("item");
        itemEl.setAttribute("id", participant.getParticipantId());
        itemEl.addChild((XMLNodeIfc)participant.toElement());
        if (hideJid) {
            this.updateJidMap(channelJID, participantId, participantJID);
        }
        this.publishItemModule.publishItems(channelJID, "urn:xmpp:mix:nodes:participants", JID.jidInstance((BareJID)participantJID), Collections.singletonList(itemEl), null);
        this.participants.put((Object)new ParticipantKey(channelJID, participant.getParticipantId()), (Object)participant);
        return participant;
    }

    @Override
    public void removeTempParticipant(BareJID channelJID, JID participantJID) throws RepositoryException {
        String id = this.mixLogic.generateTempParticipantId(channelJID, participantJID);
        this.removeParticipant(channelJID, id);
        this.retractItemModule.retractItems(channelJID, "tigase:mix:muc", Collections.singletonList(id));
    }

    @Override
    public JID getTempParticipantJID(BareJID serviceJID, String participantId) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(serviceJID, "tigase:mix:muc");
        if (items == null) {
            return null;
        }
        IItems.IItem item = items.getItem(participantId);
        if (item == null) {
            return null;
        }
        Element mucParticipant = item.getItem().getChild("muc-participant", "tigase:mix:muc:0");
        if (mucParticipant == null) {
            return null;
        }
        Element jidEl = mucParticipant.getChild("jid");
        if (jidEl == null) {
            return null;
        }
        String jidStr = jidEl.getCData();
        return jidStr == null ? null : JID.jidInstanceNS((String)jidStr);
    }

    @Override
    public String getChannelName(BareJID channelJID) throws RepositoryException {
        IItems.IItem item;
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:info");
        if (items != null && (item = items.getLastItem(CollectionItemsOrdering.byUpdateDate)) != null) {
            return DataForm.getFieldValue((Element)item.getItem(), (String)"Name");
        }
        return null;
    }

    @Override
    public ChannelConfiguration getChannelConfiguration(BareJID channelJID) throws RepositoryException {
        try {
            ChannelConfiguration configuration = (ChannelConfiguration)this.channelConfigs.computeIfAbsent((Object)channelJID, () -> {
                try {
                    return this.loadChannelConfiguration(channelJID);
                }
                catch (RepositoryException ex) {
                    throw new Cache.CacheException((Throwable)ex);
                }
            });
            return configuration;
        }
        catch (Cache.CacheException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected ChannelConfiguration loadChannelConfiguration(BareJID channelJID) throws RepositoryException {
        String lastID;
        IItems.IItem item;
        String[] ids;
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:config");
        if (items != null && (ids = items.getItemsIds(CollectionItemsOrdering.byUpdateDate)) != null && ids.length > 0 && (item = items.getItem(lastID = ids[ids.length - 1])) != null) {
            try {
                return new ChannelConfiguration(item.getItem());
            }
            catch (PubSubException ex) {
                throw new RepositoryException("Could not load channel " + channelJID + " configuration", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.pubSubRepository.getNodeSubscriptions(serviceJid, nodeName);
    }

    public void serviceRemoved(BareJID userJid) {
        this.channelConfigs.remove((Object)userJid);
    }

    public void itemDeleted(BareJID serviceJID, String node, String id) {
        switch (node) {
            case "urn:xmpp:mix:nodes:allowed": {
                try {
                    if (id == null) break;
                    this.bannedParticipantFromChannel(serviceJID, BareJID.bareJIDInstanceNS((String)id));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
        }
    }

    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
        switch (node) {
            case "urn:xmpp:mix:nodes:config": {
                ChannelConfiguration oldConfig = null;
                ChannelConfiguration newConfig = null;
                try {
                    oldConfig = this.getChannelConfiguration(serviceJID);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                this.updateChannelConfiguration(serviceJID, item);
                try {
                    newConfig = this.getChannelConfiguration(serviceJID);
                    if (newConfig == null || oldConfig == null) break;
                    this.mixLogic.generateAffiliationChangesNotifications(serviceJID, oldConfig, newConfig, arg_0 -> ((PacketWriter)this.packetWriter).write(arg_0));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
            case "urn:xmpp:mix:nodes:banned": {
                try {
                    if (id == null) break;
                    this.bannedParticipantFromChannel(serviceJID, BareJID.bareJIDInstanceNS((String)id));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
        }
    }

    public boolean validateItem(BareJID serviceJID, String node, String id, String publisher, Element item) throws PubSubException {
        if ("urn:xmpp:mix:nodes:config".equals(node)) {
            try {
                ChannelConfiguration config = this.getChannelConfiguration(serviceJID);
                if (config == null) {
                    config = new ChannelConfiguration();
                }
                config = config.apply(item.getChild("x", "jabber:x:data"));
                config.setLastChangeMadeBy(BareJID.bareJIDInstanceNS((String)publisher));
                Element validatedConfigForm = config.toFormElement();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "validated channel " + serviceJID + " configuration as valid: " + validatedConfigForm);
                }
                item.setChildren(Arrays.asList(validatedConfigForm));
                return config != null && config.isValid();
            }
            catch (RepositoryException ex) {
                throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Could not load previous configuration form", (Exception)((Object)ex));
            }
        }
        if ("urn:xmpp:mix:nodes:info".equals(node)) {
            Element form = item.getChild("x", "jabber:x:data");
            if (form == null) {
                throw new PubSubException(Authorization.NOT_ACCEPTABLE, "This is not a valid information form!");
            }
            form.setAttribute("type", "form");
            try {
                IItems items = this.pubSubRepository.getNodeItems(serviceJID, "urn:xmpp:mix:nodes:info");
                IItems.IItem prev = items.getLastItem(CollectionItemsOrdering.byUpdateDate);
                if (prev != null) {
                    List prevFields;
                    Set currFields = DataForm.getFields((Element)item);
                    Element prevForm = prev.getItem().getChild("x", "jabber:x:data");
                    if (prevForm != null && (prevFields = prevForm.findChildren(el -> el.getName() == "field")) != null) {
                        for (Element field : prevFields) {
                            if (currFields != null && currFields.contains(field.getAttributeStaticStr("var"))) continue;
                            form.addChild((XMLNodeIfc)field);
                        }
                    }
                }
            }
            catch (RepositoryException ex) {
                throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Could not load previous information form", (Exception)((Object)ex));
            }
            if (!"urn:xmpp:mix:core:1".equals(DataForm.getFieldValue((Element)form, (String)"FORM_TYPE"))) {
                throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Invalid FORM_TYPE!");
            }
        }
        return true;
    }

    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        HashMap<String, UsersAffiliation> userAffiliations = new HashMap<String, UsersAffiliation>();
        String[] nodes = this.pubSubRepository.getRootCollection(serviceJid);
        if (nodes != null) {
            for (String node : nodes) {
                UsersAffiliation affiliation;
                IAffiliations affiliations = this.pubSubRepository.getNodeAffiliations(serviceJid, node);
                if (affiliations == null || (affiliation = affiliations.getSubscriberAffiliation(jid)).getAffiliation() == Affiliation.none) continue;
                userAffiliations.put(node, affiliation);
            }
        }
        return userAffiliations;
    }

    public IAffiliationsCached newNodeAffiliations(BareJID serviceJid, String nodeName, T nodeId, IPubSubRepository.RepositorySupplier<Map<BareJID, UsersAffiliation>> affiliationSupplier) throws RepositoryException {
        if (Mix.Nodes.ALL_NODES.contains(nodeName)) {
            return new Affiliations(serviceJid, nodeName, this);
        }
        return null;
    }

    protected void bannedParticipantFromChannel(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        if (this.getParticipant(channelJID, participantJID) != null) {
            this.removeParticipant(channelJID, participantJID);
            Map userSubscriptions = this.pubSubRepository.getUserSubscriptions(channelJID, participantJID);
            for (String node : userSubscriptions.keySet()) {
                ISubscriptions subscriptions = this.pubSubRepository.getNodeSubscriptions(channelJID, node);
                subscriptions.changeSubscription(participantJID, Subscription.none);
                this.pubSubRepository.update(channelJID, node, subscriptions);
            }
        }
    }

    protected void invalidateChannelParticipant(BareJID channelJID, String participantId) throws RepositoryException {
        this.participants.remove((Object)new ParticipantKey(channelJID, participantId));
    }

    protected void updateChannelConfiguration(BareJID serviceJID, Element item) {
        try {
            ChannelConfiguration configuration = new ChannelConfiguration(item);
            ChannelConfiguration oldConfiguration = (ChannelConfiguration)this.channelConfigs.put((Object)serviceJID, (Object)configuration);
            if (oldConfiguration != null && oldConfiguration.getJidVisibility() != configuration.getJidVisibility()) {
                this.jidVisibilityChanged(serviceJID, oldConfiguration.getJidVisibility(), configuration.getJidVisibility());
            }
        }
        catch (RepositoryException | PubSubException ex) {
            log.log(Level.WARNING, "Could not update configuration of channel " + serviceJID, ex);
        }
    }

    protected synchronized void jidVisibilityChanged(BareJID serviceJID, JIDVisibility oldValue, JIDVisibility newValue) throws RepositoryException, PubSubException {
        if (oldValue == JIDVisibility.visible && newValue == JIDVisibility.hidden) {
            List<String> participantIds = this.getParticipantIds(serviceJID);
            for (String participantId : participantIds) {
                IParticipant participant = this.getParticipant(serviceJID, participantId);
                if (participant.getRealJid() == null) continue;
                this.updateParticipant(serviceJID, participantId, participant.getRealJid(), participant.getNick());
            }
        } else if (oldValue == JIDVisibility.hidden && newValue == JIDVisibility.visible) {
            List<String> participantIds = this.getParticipantIds(serviceJID);
            for (String participantId : participantIds) {
                BareJID jid;
                IParticipant participant = this.getParticipant(serviceJID, participantId);
                if (participant.getRealJid() != null || (jid = this.getParticipantJidFromJidMap(serviceJID, participantId)) == null) continue;
                this.updateParticipant(serviceJID, participantId, jid, participant.getNick());
            }
            this.removeJidMap(serviceJID, participantIds);
        }
    }

    @Override
    public BareJID getParticipantJidFromJidMap(BareJID service, String participantId) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(service, "urn:xmpp:mix:nodes:jidmap");
        if (items == null) {
            return null;
        }
        IItems.IItem item = items.getItem(participantId);
        if (item == null) {
            return null;
        }
        Element participantEl = item.getItem().getChild("participant", "urn:xmpp:mix:anon:0");
        if (participantEl == null) {
            return null;
        }
        Element jidEl = participantEl.getChild("jid");
        if (jidEl == null) {
            return null;
        }
        String jid = jidEl.getCData();
        return jid == null ? null : BareJID.bareJIDInstanceNS((String)jid);
    }

    protected void updateJidMap(BareJID serviceJID, String participantId, BareJID realJid) throws PubSubException, RepositoryException {
        if (realJid == null) {
            return;
        }
        Element itemEl = new Element("item");
        itemEl.setAttribute("id", participantId);
        itemEl.withElement("participant", "urn:xmpp:mix:anon:0", participantEl -> participantEl.withElement("jid", null, realJid.toString()));
        this.publishItemModule.publishItems(serviceJID, "urn:xmpp:mix:nodes:jidmap", JID.jidInstance((BareJID)serviceJID), Collections.singletonList(itemEl), null);
    }

    protected void removeJidMap(BareJID serviceJID, List<String> participantIds) throws RepositoryException {
        this.retractItemModule.retractItems(serviceJID, "urn:xmpp:mix:nodes:jidmap", participantIds);
    }

    protected static class ParticipantKey {
        private final BareJID channelJID;
        private final String participantId;

        public ParticipantKey(BareJID channelJID, String participantId) {
            this.channelJID = channelJID;
            this.participantId = participantId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ParticipantKey)) {
                return false;
            }
            ParticipantKey that = (ParticipantKey)o;
            return this.channelJID.equals((Object)that.channelJID) && this.participantId.equals(that.participantId);
        }

        public int hashCode() {
            return Objects.hash(this.channelJID, this.participantId);
        }
    }
}

