/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.adhoc;

import java.util.List;
import java.util.Optional;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.adhoc.AbstractMIXAdhocCommand;
import tigase.mix.model.IMixRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.utils.IntegerOrMax;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="channel-manage-members-cmd", parent=IMixComponent.class, active=true)
public class ChannelManageMembersCommand
extends AbstractMIXAdhocCommand {
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private PublishItemModule publishItemModule;
    @Inject
    private RetractItemModule retractItemModule;

    public ChannelManageMembersCommand() {
        super("channel-manage-members-cmd", "Manage channel members");
    }

    @Override
    protected Element prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        return new DataForm.Builder(Command.DataType.form).addTitle("Manage channel members").addInstructions(new String[]{"Fill out and submit this form to manage channel members"}).withField(DataForm.FieldType.ListSingle, "action", field -> field.setLabel("Select action").setRequired(true).setOptions(new String[]{"add", "remove"})).withField(DataForm.FieldType.TextSingle, "channel-id", field -> field.setLabel("ID of the channel").setRequired(true)).withField(DataForm.FieldType.JidSingle, "jid", field -> field.setLabel("JID of a member").setRequired(true)).build();
    }

    @Override
    protected Element submitForm(AdhHocRequest request, AdHocResponse response, Element data) throws AdHocCommandException {
        try {
            BareJID channelJID = BareJID.bareJIDInstance((String)DataForm.getFieldValue((Element)data, (String)"channel-id"), (String)request.getRecipient().getDomain());
            BareJID jid = BareJID.bareJIDInstance((String)DataForm.getFieldValue((Element)data, (String)"jid"));
            Optional<List<BareJID>> allowed = this.mixRepository.getAllowed(channelJID);
            boolean isAllowed = allowed.filter(list -> list.contains(jid)).isPresent();
            boolean shouldAllow = "add".equals(DataForm.getFieldValue((Element)data, (String)"action"));
            if (isAllowed != shouldAllow) {
                if (shouldAllow) {
                    if (allowed.isEmpty()) {
                        LeafNodeConfig config = new LeafNodeConfig("urn:xmpp:mix:nodes:participants");
                        config.setValue("pubsub#max_items", (Object)IntegerOrMax.MAX);
                        config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
                        config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
                        config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
                        config.setValue("pubsub#notification_type", (Object)StanzaType.normal.name());
                        this.pubSubRepository.createNode(channelJID, "urn:xmpp:mix:nodes:allowed", channelJID, (AbstractNodeConfig)config, NodeType.leaf, null);
                    }
                    LeafNodeConfig nodeConfig = (LeafNodeConfig)this.pubSubRepository.getNodeConfig(channelJID, "urn:xmpp:mix:nodes:allowed");
                    this.publishItemModule.doPublishItems(channelJID, "urn:xmpp:mix:nodes:allowed", nodeConfig, request.getSender().toString(), List.of(new Element("item").withAttribute("id", jid.toString())));
                } else if (allowed.isPresent()) {
                    this.retractItemModule.retractItems(channelJID, "urn:xmpp:mix:nodes:allowed", List.of(jid.toString()));
                }
            }
            return null;
        }
        catch (TigaseStringprepException ex) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST);
        }
        catch (PubSubException e) {
            throw new AdHocCommandException(e.getErrorCondition(), e.getMessage());
        }
        catch (RepositoryException e) {
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

