/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.cluster.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.StrategyIfc;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="meetCreationLockCommand", parent=StrategyIfc.class, active=true)
public class MeetCreationLockCommand
extends CommandListenerAbstract {
    public static final String MEET_CREATION_LOCK = "meet-creation-lock";
    private static final Logger a = Logger.getLogger(MeetCreationLockCommand.class.getCanonicalName());
    @Inject
    private StrategyIfc strategy;

    public static void acquireLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, Long until) {
        MeetCreationLockCommand.a(strategy, Action.acquire, meetJid, toNodes, until, null);
    }

    public static void acquiredLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, boolean result) {
        MeetCreationLockCommand.a(strategy, Action.acquired, meetJid, toNodes, null, result);
    }

    public static void releaseLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, boolean success) {
        MeetCreationLockCommand.a(strategy, Action.release, meetJid, toNodes, null, success);
    }

    private static void a(StrategyIfc strategyIfc, Action action, BareJID bareJID, Collection<JID> collection, Long l, Boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("action", action.name());
        hashMap.put("meet", bareJID.toString());
        if (l != null) {
            hashMap.put("until", String.valueOf(l));
        }
        if (bl != null) {
            hashMap.put("result", String.valueOf(bl));
        }
        strategyIfc.getClusterController().sendToNodes(MEET_CREATION_LOCK, hashMap, strategyIfc.getLocalNodeJid(), (JID[])collection.toArray(JID[]::new));
    }

    public MeetCreationLockCommand() {
        super(MEET_CREATION_LOCK, Priority.HIGH);
    }

    public void executeCommand(JID jid, Set<JID> set, Map<String, String> map, Queue<Element> queue) throws ClusterCommandException {
        try {
            BareJID bareJID = BareJID.bareJIDInstance((String)map.get("meet"));
            Action action = Action.valueOf(map.get("action"));
            switch (action) {
                case acquire: {
                    long l = Long.parseLong(map.get("until"));
                    boolean bl = this.strategy.createMeetCreationLock(bareJID, l, jid);
                    MeetCreationLockCommand.acquiredLock(this.strategy, bareJID, Collections.singletonList(jid), bl);
                    break;
                }
                case acquired: {
                    boolean bl = Boolean.parseBoolean(map.get("result"));
                    this.strategy.acquiredMeetCreationLock(bareJID, jid, bl);
                    break;
                }
                case release: {
                    boolean bl = Boolean.parseBoolean(map.get("result"));
                    this.strategy.releasedMeetCreationLock(bareJID, jid, bl);
                }
            }
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, "Exception while processing cluster command", throwable);
        }
    }

    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action acquire = new Action();
        public static final /* enum */ Action acquired = new Action();
        public static final /* enum */ Action release = new Action();
        private static final /* synthetic */ Action[] a;

        public static Action[] values() {
            return (Action[])a.clone();
        }

        public static Action valueOf(String name) {
            return Enum.valueOf(Action.class, name);
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{acquire, acquired, release};
        }

        static {
            a = Action.a();
        }
    }
}

