/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.cluster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.Meet;
import tigase.meet.MeetRepository;
import tigase.meet.cluster.MeetComponentClustered;
import tigase.meet.cluster.StrategyIfc;
import tigase.xmpp.jid.BareJID;

@Bean(name="meetRepository", parent=MeetComponentClustered.class, active=true)
public class MeetRepositoryClustered
extends MeetRepository {
    @Inject(nullAllowed=true)
    private StrategyIfc strategy;

    public CompletableFuture<Meet> create(BareJID key, int maxNoOfPublishers) {
        return ((CompletableFuture)this.strategy.acquireMeetCreationLock(key).thenCompose(void_ -> super.create(key, maxNoOfPublishers).orTimeout(this.strategy.getCreationLockTimeout() / 4L, TimeUnit.MILLISECONDS))).whenComplete((meet, throwable) -> this.strategy.releaseMeetCreationLock(key, throwable == null));
    }

    public void destroyed(BareJID jid) {
        super.destroyed(jid);
        this.strategy.removeMeetToNodeMapping(jid, this.strategy.getLocalNodeJid());
    }

    public int size() {
        if (this.strategy == null) {
            return 0;
        }
        return this.strategy.getMeetsCount();
    }
}

