/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Iterator;
import java.util.List;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelUpdateSubscriptionkModule", parent=IMixComponent.class, active=true)
public class ChannelUpdateSubscription
extends AbstractPubSubModule {
    private static final Criteria CRIT_UPDATE_SUBSCRIPTION = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"update-subscription", (String)"urn:xmpp:mix:core:1"));
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;

    public Criteria getModuleCriteria() {
        return CRIT_UPDATE_SUBSCRIPTION;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo().getLocalpart() == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = packet.getStanzaTo().getBareJID();
        BareJID senderJID = packet.getStanzaFrom().getBareJID();
        try {
            this.mixLogic.checkPermission(channelJID, senderJID, MixAction.publish);
            Element updateSubscriptionEl = packet.getElemChild("update-subscription", "urn:xmpp:mix:core:1");
            List nodes = updateSubscriptionEl.mapChildren(el -> el.getName() == "subscribe", el -> el.getAttributeStaticStr("node"));
            if (nodes != null) {
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    try {
                        String node2 = (String)it.next();
                        this.mixLogic.checkPermission(channelJID, node2, packet.getStanzaFrom(), PubSubLogic.Action.subscribe);
                        ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(channelJID, node2);
                        if (subscriptions == null) {
                            it.remove();
                            break;
                        }
                        if (subscriptions.getSubscription(senderJID) != null) continue;
                        subscriptions.addSubscriberJid(senderJID, Subscription.subscribed);
                        this.getRepository().update(channelJID, node2, subscriptions);
                    }
                    catch (Throwable ex) {
                        it.remove();
                    }
                }
            }
            Element responseContent = new Element("update-subscription", new String[]{"xmlns", "jid"}, new String[]{"urn:xmpp:mix:core:1", senderJID.toString()});
            if (nodes != null) {
                nodes.stream().map(node -> new Element("subscribe", new String[]{"node "}, new String[]{node})).forEach(arg_0 -> ((Element)responseContent).addChild(arg_0));
            }
            this.packetWriter.write(packet.okResult(responseContent, 0));
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

