/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.UUID;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.model.RoomPresenceRepository;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.utils.executors.Executor;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="channelGroupChatMessageModule", parent=IMixComponent.class, active=true)
public class ChannelGroupChatMessageModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_LEAVE = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final String[] FEATURES = new String[]{"urn:xmpp:mix:core:1"};
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private PublishItemModule publishItemModule;
    @Inject(nullAllowed=true)
    private RoomPresenceRepository roomPresenceRepository;
    @Inject
    private EventBus eventBus;
    @Inject(nullAllowed=true)
    private RoomPresenceModule roomPresenceModule;

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT_LEAVE;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo().getLocalpart() == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = packet.getStanzaTo().getBareJID();
        BareJID senderJID = packet.getStanzaFrom().getBareJID();
        try {
            IParticipant participant;
            if (this.roomPresenceRepository != null && this.roomPresenceRepository.isParticipant(channelJID, packet.getStanzaFrom())) {
                participant = this.mixRepository.getParticipant(channelJID, this.mixLogic.generateTempParticipantId(channelJID, packet.getStanzaFrom()));
            } else {
                this.mixLogic.checkPermission(channelJID, senderJID, MixAction.publish);
                participant = this.mixRepository.getParticipant(channelJID, senderJID);
            }
            if (participant == null) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            Element message = packet.getElement().clone();
            String uuid = UUID.randomUUID().toString();
            message.setAttribute("id", uuid);
            message.removeAttribute("to");
            message.setAttribute("from", JID.jidInstanceNS((BareJID)channelJID, (String)participant.getParticipantId()).toString());
            Element mix = new Element("mix");
            mix.setXMLNS("urn:xmpp:mix:core:1");
            if (participant.getNick() != null) {
                mix.withElement("nick", null, participant.getNick());
            }
            if (participant.getRealJid() != null) {
                mix.withElement("jid", null, participant.getRealJid().toString());
            }
            message.addChild((XMLNodeIfc)mix);
            message.addChild((XMLNodeIfc)new Element("stanza-id", new String[]{"xmlns", "id", "by"}, new String[]{"urn:xmpp:sid:0", uuid, channelJID.toString()}));
            this.getRepository().addMAMItem(channelJID, "urn:xmpp:mix:nodes:messages", uuid, message, null);
            this.eventBus.fire((Object)new PublishItemModule.BroadcastNotificationEvent(this.config.getComponentName(), channelJID, "urn:xmpp:mix:nodes:messages", message));
            this.publishItemModule.broadcastNotification(Executor.Priority.normal, channelJID, "urn:xmpp:mix:nodes:messages", message);
            if (this.roomPresenceModule != null) {
                this.roomPresenceModule.broadcastMessage(channelJID, participant.getNick(), message.clone());
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

