/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.SaslInvalidLoginExcepion;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.XmppSaslException;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.auth.mechanisms.SaslSCRAMPlus;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.AbstractAuthPreprocessor;
import tigase.xmpp.jid.BareJID;

@Bean(name="urn:ietf:params:xml:ns:xmpp-sasl", parent=SessionManager.class, active=true)
public class SaslAuth
extends AbstractAuthPreprocessor
implements XMPPProcessorIfc {
    public static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String _XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    protected static final String ALLOWED_SASL_MECHANISMS_KEY = "allowed-sasl-mechanisms";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    private static final String[][] ELEMENTS = new String[][]{{"auth"}, {"response"}, {"challenge"}, {"failure"}, {"success"}, {"abort"}};
    private static final Logger log = Logger.getLogger(SaslAuth.class.getName());
    private static final String SASL_SERVER_KEY = "SASL_SERVER_KEY";
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};
    private final Map<String, Object> props = new HashMap<String, Object>();
    @Inject
    private BruteForceLockerBean bruteForceLocker;
    @Inject
    private TigaseSaslProvider saslProvider;

    @Override
    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 4;
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block35: {
                if (session.getSessionData("authentication-timeout") != null) {
                    return;
                }
                String clientIp = BruteForceLockerBean.getClientIp(session);
                if (session.isAuthorized()) {
                    Packet res = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                    res.setPriority(Priority.SYSTEM);
                    results.offer(res);
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
                    }
                    try {
                        session.logout();
                    }
                    catch (NotAuthorizedException ex) {
                        log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Session after logout: {0}", session.toString());
                    }
                    return;
                }
                Element request = packet.getElement();
                try {
                    SaslServer ss;
                    if ("auth" == request.getName()) {
                        String mechanismName = request.getAttributeStaticStr("mechanism");
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Start SASL auth. mechanism=" + mechanismName);
                        }
                        Collection<String> allowedMechanisms = (Collection<String>)session.getSessionData(ALLOWED_SASL_MECHANISMS_KEY);
                        session.removeSessionData(ALLOWED_SASL_MECHANISMS_KEY);
                        if (allowedMechanisms == null) {
                            allowedMechanisms = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
                        }
                        if (mechanismName == null || allowedMechanisms == null || !allowedMechanisms.contains(mechanismName)) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        CallbackHandler cbh = this.saslProvider.create(mechanismName, session, repo, settings);
                        ss = Sasl.createSaslServer(mechanismName, "xmpp", session.getDomain().getVhost().getDomain(), this.props, cbh);
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        session.putSessionData(SASL_SERVER_KEY, ss);
                    } else if ("response" == request.getName()) {
                        ss = (SaslServer)session.getSessionData(SASL_SERVER_KEY);
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                        }
                    } else {
                        throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Unrecognized element " + request.getName());
                    }
                    String cdata = request.getCData();
                    byte[] data = cdata != null && cdata.length() == 1 && cdata.equals("=") ? new byte[]{} : (cdata != null && cdata.length() > 0 ? Base64.decode((String)cdata) : new byte[]{});
                    byte[] challenge = ss.evaluateResponse(data);
                    String challengeData = challenge != null ? Base64.encode((byte[])challenge) : null;
                    if (ss.isComplete() && ss.getAuthorizationID() != null) {
                        boolean anonymous;
                        BareJID jid = ss.getAuthorizationID().contains("@") ? BareJID.bareJIDInstance((String)ss.getAuthorizationID()) : BareJID.bareJIDInstance((String)ss.getAuthorizationID(), (String)session.getDomain().getVhost().getDomain());
                        if (this.bruteForceLocker.isEnabled(session) && !this.bruteForceLocker.isLoginAllowed(session, clientIp, jid)) {
                            throw new BruteForceLockerBean.LoginLockedException();
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.finest("Authorized as " + jid);
                        }
                        try {
                            Boolean x = (Boolean)ss.getNegotiatedProperty("IS_ANONYMOUS");
                            anonymous = x != null && x != false;
                        }
                        catch (Exception e) {
                            anonymous = false;
                        }
                        session.removeSessionData(SASL_SERVER_KEY);
                        session.authorizeJID(jid, anonymous);
                        if (session.getAuthRepository() != null) {
                            session.getAuthRepository().loggedIn(jid);
                        }
                        results.offer(packet.swapFromTo(this.createReply(ElementType.success, challengeData), null, null));
                        break block35;
                    }
                    if (!ss.isComplete()) {
                        results.offer(packet.swapFromTo(this.createReply(ElementType.challenge, challengeData), null, null));
                        break block35;
                    }
                    throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                }
                catch (BruteForceLockerBean.LoginLockedException e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Account locked by BruteForceLocker.");
                    }
                    this.sendNotAuthorized(XmppSaslException.SaslError.not_authorized, AbstractSasl.PASSWORD_NOT_VERIFIED_MSG, packet, results);
                }
                catch (XmppSaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    this.sendNotAuthorized(e.getSaslError(), e.getMessage(), packet, results);
                }
                catch (SaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    this.sendNotAuthorized(XmppSaslException.SaslError.not_authorized, null, packet, results);
                }
                catch (Exception e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Problem with SASL", e);
                    }
                    this.sendNotAuthorized(XmppSaslException.SaslError.temporary_auth_failure, null, packet, results);
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        Collection<String> auth_mechs = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
        if (auth_mechs.isEmpty()) {
            return null;
        }
        Element[] mechs = new Element[auth_mechs.size()];
        int idx = 0;
        session.putSessionData(ALLOWED_SASL_MECHANISMS_KEY, auth_mechs);
        for (String mech : auth_mechs) {
            mechs[idx++] = new Element("mechanism", mech);
        }
        if (session.isEncrypted() && session.getSessionData("LOCAL_CERTIFICATE_KEY") != null && SaslSCRAMPlus.containsScramPlus(auth_mechs)) {
            Element bindings = AbstractSaslSCRAM.getSupportedChannelBindings(session);
            return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}), bindings};
        }
        return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    }

    protected void onAuthFail(XMPPResourceConnection session) {
        session.removeSessionData(SASL_SERVER_KEY);
    }

    private Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.toString());
        reply.setXMLNS("urn:ietf:params:xml:ns:xmpp-sasl");
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    private void disableUser(XMPPResourceConnection session, BareJID userJID) {
        try {
            AuthRepository.AccountStatus status = session.getAuthRepository().getAccountStatus(userJID);
            if (status == AuthRepository.AccountStatus.active) {
                log.log(Level.CONFIG, "Disabling user " + userJID);
                session.getAuthRepository().setAccountStatus(userJID, AuthRepository.AccountStatus.disabled);
            }
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Cannot check status or disable user!", e);
        }
    }

    private BareJID extractUserJid(Exception e, XMPPResourceConnection session) {
        BareJID jid = null;
        if (e instanceof SaslInvalidLoginExcepion) {
            String t = ((SaslInvalidLoginExcepion)e).getJid();
            BareJID bareJID = jid = t == null ? null : BareJID.bareJIDInstanceNS((String)t);
        }
        if (jid != null) {
            jid = (BareJID)session.getSessionData("authentication-jid");
        }
        return jid;
    }

    private void saveIntoBruteForceLocker(XMPPResourceConnection session, Exception e) {
        try {
            if (this.bruteForceLocker.isEnabled(session)) {
                String clientIp = BruteForceLockerBean.getClientIp(session);
                BareJID userJid = this.extractUserJid(e, session);
                if (clientIp == null && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "There is no client IP. Cannot add entry to BruteForceLocker.");
                }
                if (userJid == null && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "There is no user JID. Cannot add entry to BruteForceLocker.");
                }
                if (userJid != null && clientIp != null) {
                    this.bruteForceLocker.addInvalidLogin(session, clientIp, userJid);
                }
                if (this.bruteForceLocker.canUserBeDisabled(session, clientIp, userJid)) {
                    this.disableUser(session, userJid);
                }
            }
        }
        catch (Throwable caught) {
            log.log(Level.WARNING, "Cannot update BruteForceLocker", caught);
        }
    }

    private void sendNotAuthorized(XmppSaslException.SaslError error, String message, Packet packet, Queue<Packet> results) {
        Object el = error.getElementName() != null ? "<" + error.getElementName() + "/>" : "<not-authorized/>";
        if (message != null) {
            el = (String)el + "<text xml:lang='en'>" + message + "</text>";
        }
        Packet response = packet.swapFromTo(this.createReply(ElementType.failure, (String)el), null, null);
        response.setPriority(Priority.SYSTEM);
        results.offer(response);
    }

    public static enum ElementType {
        abort,
        auth,
        challenge,
        failure,
        response,
        success;

    }
}

