/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.net.IOServiceListener;
import tigase.net.SocketThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.StreamManagementCommand;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:sm:3", parent=ClientConnectionManager.class, active=true)
public class StreamManagementIOProcessor
implements XMPPIOProcessor {
    public static final String XMLNS = "urn:xmpp:sm:3";
    private static final Logger log = Logger.getLogger(StreamManagementIOProcessor.class.getCanonicalName());
    private static final String ACK_NAME = "a";
    private static final String ENABLE_NAME = "enable";
    private static final String ENABLED_NAME = "enabled";
    private static final String REQ_NAME = "r";
    private static final String RESUME_NAME = "resume";
    private static final String RESUMED_NAME = "resumed";
    private static final String H_ATTR = "h";
    private static final String LOCATION_ATTR = "location";
    private static final String RESUME_ATTR = "resume";
    private static final String MAX_ATTR = "max";
    private static final String PREVID_ATTR = "previd";
    private static final String ACK_REQUEST_COUNT_KEY = "ack-request-count";
    private static final String ACK_REQUEST_MIN_DELAY_KEY = "ack-request-min-delay";
    private static final int DEF_ACK_REQUEST_COUNT_VAL = 10;
    private static final String[] DELAY_PATH = new String[]{"message", "delay"};
    private static final String DELAY_XMLNS = "urn:xmpp:delay";
    private static final String IGNORE_UNDELIVERED_PRESENCE_KEY = "ignore-undelivered-presence";
    private static final String IN_COUNTER_KEY = "urn:xmpp:sm:3_in";
    private static final String MAX_RESUMPTION_TIMEOUT_KEY = "urn:xmpp:sm:3_resumption-timeout";
    private static final String MAX_RESUMPTION_TIMEOUT_PROP_KEY = "max-resumption-timeout";
    private static final String OUT_COUNTER_KEY = "urn:xmpp:sm:3_out";
    private static final String RESUMPTION_TASK_KEY = "urn:xmpp:sm:3_resumption-task";
    private static final String RESUMPTION_TIMEOUT_PROP_KEY = "resumption-timeout";
    private static final String RESUMPTION_TIMEOUT_START_KEY = "resumption-timeout-start";
    private static final String STREAM_ID_KEY = "urn:xmpp:sm:3_stream_id";
    private static final Element[] FEATURES = new Element[]{new Element("sm", new String[]{"xmlns"}, new String[]{"urn:xmpp:sm:3"})};
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final ConcurrentHashMap<String, XMPPIOService> services = new ConcurrentHashMap();
    @ConfigField(desc="Number of sent packets after should ask for confirmation of delivery", alias="ack-request-count")
    private int ack_request_count = 10;
    @Inject(bean="service")
    private ConnectionManager connectionManager;
    @ConfigField(desc="Ignore undelivered presence packets", alias="ignore-undelivered-presence")
    private boolean ignoreUndeliveredPresence = true;
    @ConfigField(desc="Maximal allowed time for session resumption", alias="max-resumption-timeout")
    private int max_resumption_timeout = 900;
    @ConfigField(desc="Default resumption timeout", alias="resumption-timeout")
    private int resumption_timeout = 60;
    @ConfigField(desc="Max allowed queue size of unacked packets", alias="max-resumption-queue-size")
    private int max_queue_size = 2000;
    @ConfigField(desc="Time since last ack received or ack request sent before which ack request should not be sent", alias="ack-request-min-delay")
    private long ack_request_min_delay = 200L;

    public static boolean isEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(IN_COUNTER_KEY);
    }

    private static boolean isResumptionEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(STREAM_ID_KEY);
    }

    @Override
    public String getId() {
        return XMLNS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        if (service == null || service.getUserJid() == null) {
            return null;
        }
        if (StreamManagementIOProcessor.isEnabled(service)) {
            return null;
        }
        return FEATURES;
    }

    private String enable(XMPPIOService service, boolean withResumption, Integer maxTimeout) {
        OutQueue outQueue = this.newOutQueue();
        outQueue.setAckRequestCount(this.ack_request_count);
        service.getSessionData().putIfAbsent(OUT_COUNTER_KEY, outQueue);
        service.getSessionData().putIfAbsent(IN_COUNTER_KEY, this.newCounter());
        String id = null;
        int timeout = this.resumption_timeout;
        if (this.resumption_timeout > 0 && withResumption) {
            outQueue.setResumptionEnabled(true);
            if (maxTimeout != null) {
                timeout = Math.min(this.max_resumption_timeout, maxTimeout);
            }
            id = UUID.randomUUID().toString();
            service.getSessionData().putIfAbsent(STREAM_ID_KEY, id);
            service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, timeout);
            this.services.put(id, service);
        }
        Packet cmd = StreamManagementCommand.ENABLED.create(service.getConnectionId(), service.getDataReceiver());
        cmd.setPacketFrom(service.getConnectionId());
        cmd.setPacketTo(service.getDataReceiver());
        Command.addFieldValue(cmd, "resumption-id", id);
        this.connectionManager.processOutPacket(cmd);
        return id;
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            if (packet.getXMLNS() != XMLNS) {
                return false;
            }
            if (packet.getElemName() == ENABLE_NAME) {
                String maxStr = packet.getElement().getAttributeStaticStr(MAX_ATTR);
                String id = this.enable(service, packet.getElement().getAttributeStaticStr("resume") != null, maxStr != null ? Integer.valueOf(Integer.parseInt(maxStr)) : null);
                String location = id != null ? DNSResolverFactory.getInstance().getSecondaryHost() : null;
                Integer timeout = (Integer)service.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY);
                try {
                    service.writeRawData("<enabled xmlns='urn:xmpp:sm:3'" + (String)(id != null ? " id='" + id + "' resume='true' max='" + timeout + "'" : "") + (String)(location != null ? " location='" + location + "'" : "") + " />");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Started StreamManagement with resumption timeout set to = {1} [{0}]", new Object[]{service.toString(), id != null ? Integer.valueOf(this.resumption_timeout) : null});
                    }
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, service.toString() + ", exception during sending <enabled/>, stopping...", ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            if (packet.getElemName() == "resume") {
                String h = packet.getElement().getAttributeStaticStr(H_ATTR);
                String id = packet.getElement().getAttributeStaticStr(PREVID_ATTR);
                try {
                    this.resumeStream(service, id, Integer.parseInt(h));
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, service.toString() + ", exception while resuming stream for user " + service.getUserJid() + " with id " + id, ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            return false;
        }
        if (packet.getXMLNS() == XMLNS) {
            block22: {
                if (packet.getElemName() == ACK_NAME) {
                    String hStr = packet.getAttributeStaticStr(H_ATTR);
                    int h = Integer.parseInt(hStr);
                    OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
                    if (outQueue != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Acking {2} packets, in outQueue: {3} while processing: {1} [{0}]", new Object[]{service, packet, h, outQueue.waitingForAck()});
                        }
                        outQueue.ack(h);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "outQueue already null while processing: {1} [{0}]", new Object[]{service, packet});
                    }
                } else if (packet.getElemName() == REQ_NAME) {
                    int value = ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).get();
                    try {
                        service.writeRawData("<a xmlns='urn:xmpp:sm:3' h='" + String.valueOf(value) + "'/>");
                    }
                    catch (IOException ex) {
                        if (!log.isLoggable(Level.FINE)) break block22;
                        log.log(Level.FINE, service.toString() + ", exception during sending <a/> as response for <r/>, not stopping serivce as it will be stopped after processing all incoming data...", ex);
                    }
                }
            }
            return true;
        }
        if (!this.isStanza(packet)) {
            return false;
        }
        ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).inc();
        return false;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        OutQueue outQueue;
        if (!StreamManagementIOProcessor.isEnabled(service) || packet.getXMLNS() == XMLNS) {
            return false;
        }
        if (!this.isStanza(packet)) {
            return false;
        }
        if (service.getAuthorisedUserJid().isPresent() && packet.getStanzaTo() == null) {
            packet.initVars(packet.getStanzaFrom(), service.getAuthorisedUserJid().get());
        }
        if ((outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY)) == null) {
            OutQueue.Entry e = new OutQueue.Entry(packet);
            this.connectionManager.processUndeliveredPacket(e.getPacketWithStamp(), e.stamp, null);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Queuing StreamManagement packet: {1}, queue size: {2} [{0}]", new Object[]{service, packet, outQueue.waitingForAck()});
            }
            if (!outQueue.append(packet, this.max_queue_size, this.max_resumption_timeout)) {
                try {
                    service.getSessionData().put(RESUMPTION_TIMEOUT_START_KEY, 0L);
                    service.writeRawData("<stream:error xmlns:stream=\"http://etherx.jabber.org/streams\"><policy-violation xmlns=\"urn:ietf:params:xml:ns:xmpp-streams\"/><text xmlns=\"urn:ietf:params:xml:ns:xmpp-streams\">Too many unacked stanzas</text></stream:error>");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                service.forceStop();
            }
        }
        return service.getSessionData().containsKey(RESUMPTION_TASK_KEY);
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            return;
        }
        OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
        if (outQueue != null && this.shouldRequestAck(service, outQueue)) {
            outQueue.sendingRequest();
            service.writeRawData("<r xmlns='urn:xmpp:sm:3' />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void processCommand(XMPPIOService service, Packet pc) {
        if (pc.getType() == StanzaType.error || pc.getType() == StanzaType.result) {
            return;
        }
        cmd = StreamManagementCommand.fromPacket(pc);
        switch (1.$SwitchMap$tigase$server$xmppclient$StreamManagementCommand[cmd.ordinal()]) {
            case 1: {
                newConn = Command.getFieldValue(pc, "new-conn-jid");
                id = (String)service.getSessionData().get("urn:xmpp:sm:3_stream_id");
                newConnJid = JID.jidInstanceNS((String)newConn);
                newService = this.connectionManager.getXMPPIOService(newConnJid.getResource());
                if (newService == null) ** GOTO lbl57
                if (StreamManagementIOProcessor.log.isLoggable(Level.FINEST)) {
                    StreamManagementIOProcessor.log.log(Level.FINEST, "stream for user {2} moved from {0} to {1}", new Object[]{service.getConnectionId(), newService.getConnectionId(), newService.getUserJid()});
                }
                try {
                    newService.setUserJid(service.getUserJid());
                    if (!"false".equals(Command.getFieldValue(pc, "send-response"))) {
                        inCounter = (Counter)newService.getSessionData().get("urn:xmpp:sm:3_in");
                        newService.writeRawData("<resumed xmlns='urn:xmpp:sm:3' previd='" + id + "' h='" + inCounter.get() + "' />");
                    }
                    service.getSessionData().put("stream-closed", "stream-closed");
                    this.services.put(id, (XMPPIOService)newService);
                    outQueue = (OutQueue)newService.getSessionData().get("urn:xmpp:sm:3_out");
                    packetsToResend = new ArrayList<OutQueue.Entry>(outQueue.getQueue());
                    if (StreamManagementIOProcessor.log.isLoggable(Level.FINE)) {
                        StreamManagementIOProcessor.log.log(Level.FINE, "resuming stream with id = {1} resending unacked packets = {2} [{0}]", new Object[]{service, id, outQueue.waitingForAck()});
                    }
                    for (OutQueue.Entry entry : packetsToResend) {
                        packetToResend = entry.getPacketWithStamp();
                        if (StreamManagementIOProcessor.log.isLoggable(Level.FINEST)) {
                            StreamManagementIOProcessor.log.log(Level.FINEST, "resuming stream with id = {1} resending unacked packet = {2} [{0}]", new Object[]{service, id, packetToResend});
                        }
                        newService.addPacketToSend(packetToResend);
                    }
                    if (packetsToResend.isEmpty() || !newService.writeInProgress.tryLock()) ** GOTO lbl59
                    try {
                        newService.processWaitingPackets();
                        SocketThread.addSocketService(newService);
                        ** GOTO lbl59
                    }
                    catch (Exception e) {
                        StreamManagementIOProcessor.log.log(Level.WARNING, newService + "Exception during writing packets: ", e);
                        try {
                            newService.stop();
                        }
                        catch (Exception e1) {
                            StreamManagementIOProcessor.log.log(Level.WARNING, newService + "Exception stopping XMPPIOService: ", e1);
                        }
                        ** GOTO lbl59
                    }
                    finally {
                        newService.writeInProgress.unlock();
                    }
                }
                catch (IOException ex) {
                    if (StreamManagementIOProcessor.log.isLoggable(Level.FINEST)) {
                        StreamManagementIOProcessor.log.log(Level.FINEST, "could not confirm session resumption for user = " + newService.getUserJid(), ex);
                    }
                    this.services.remove(id, service);
                    this.services.remove(id, newService);
                }
                ** GOTO lbl59
lbl57:
                // 1 sources

                if (StreamManagementIOProcessor.log.isLoggable(Level.FINEST)) {
                    StreamManagementIOProcessor.log.log(Level.FINEST, "no new service available for user {0} to resume from {1}, already closed?", new Object[]{service.getUserJid(), service});
                }
lbl59:
                // 8 sources

                if (StreamManagementIOProcessor.log.isLoggable(Level.FINEST)) {
                    StreamManagementIOProcessor.log.log(Level.FINEST, "closing old service {0} for user {1}", new Object[]{service, service.getUserJid()});
                }
                this.connectionManager.serviceStopped(service);
                break;
            }
            case 2: {
                resumptionId = Command.getFieldValue(pc, "resumption-id");
                h = Integer.parseInt(Command.getFieldValue(pc, "h"));
                try {
                    oldConnId = this.moveStream(service, resumptionId, h);
                    response = pc.okResult(new Element("command", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/commands"}), 0);
                    inCounter = (Counter)service.getSessionData().get("urn:xmpp:sm:3_in");
                    Command.addFieldValue(response, "h", String.valueOf(inCounter.counter));
                    this.connectionManager.processOutPacket(response);
                    response = StreamManagementCommand.STREAM_MOVED.create(service.getConnectionId(), service.getDataReceiver());
                    response.setPacketFrom(service.getConnectionId());
                    response.setPacketTo(service.getDataReceiver());
                    Command.addFieldValue(response, "old-conn-jid", oldConnId);
                    Command.addFieldValue(response, "send-response", "false");
                    this.connectionManager.processOutPacket(response);
                }
                catch (Exception ex) {
                    try {
                        this.connectionManager.processOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(pc, ex.getMessage(), false));
                    }
                    catch (PacketErrorTypeException response) {}
                }
                break;
            }
            case 3: {
                maxStr = Command.getFieldValue(pc, "max");
                max = maxStr != null ? Integer.valueOf(Integer.parseInt(maxStr)) : null;
                withResumption = Command.getCheckBoxFieldValue(pc, "resume");
                resumptionId = this.enable(service, withResumption, max);
                response = pc.okResult(new Element("command", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/commands"}), 0);
                if (resumptionId != null) {
                    Command.addFieldValue(response, "id", resumptionId);
                    Command.addFieldValue(response, "location", DNSResolverFactory.getInstance().getSecondaryHost());
                    timeout = (Integer)service.getSessionData().get("urn:xmpp:sm:3_resumption-timeout");
                    if (timeout != null) {
                        Command.addFieldValue(response, "max", String.valueOf(timeout));
                    }
                }
                this.connectionManager.processOutPacket(response);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        Long resumptionTimeoutStart;
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Service stopped - StreamManagement disabled [{0}]", new Object[]{service});
            }
            return false;
        }
        String id = (String)service.getSessionData().get(STREAM_ID_KEY);
        if (streamClosed) {
            service.getSessionData().remove(STREAM_ID_KEY);
        }
        if ((resumptionTimeoutStart = (Long)service.getSessionData().get(RESUMPTION_TIMEOUT_START_KEY)) != null) {
            boolean isBeyondResumptionTimeout;
            boolean bl = isBeyondResumptionTimeout = System.currentTimeMillis() - resumptionTimeoutStart > (long)(1 * this.resumption_timeout * 1000);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Service stopped - checking resumption timeout, resumptionTimeoutStart: {1}, resumption_timeout: {2}, streamClosed: {3} [{0}]", new Object[]{service, resumptionTimeoutStart, this.resumption_timeout, streamClosed});
            }
            if (isBeyondResumptionTimeout || streamClosed) {
                if (id == null) {
                    return false;
                }
                this.services.remove(id, service);
                service.clearWaitingPackets();
                this.connectionManager.serviceStopped(service);
                TimerTask timerTask = (TimerTask)service.getSessionData().get(RESUMPTION_TASK_KEY);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                this.sendErrorsForQueuedPackets(service);
            }
            return false;
        }
        if (StreamManagementIOProcessor.isResumptionEnabled(service)) {
            if (service.getSessionData().getOrDefault("stream-closing", false) == Boolean.TRUE) {
                this.services.remove(id, service);
                this.connectionManager.serviceStopped(service);
                this.sendErrorsForQueuedPackets(service);
                return false;
            }
            if (!this.services.containsKey(id)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Service stopped - resumption enabled but service not available [{0}]", new Object[]{service});
                }
                return false;
            }
            service.setIOServiceListener((IOServiceListener)null);
            int resumptionTimeout = (Integer)service.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY);
            XMPPIOService xMPPIOService = service;
            synchronized (xMPPIOService) {
                if (!service.getSessionData().containsKey(RESUMPTION_TASK_KEY)) {
                    ResumptionTimeoutTask timerTask = new ResumptionTimeoutTask(service);
                    service.getSessionData().put(RESUMPTION_TASK_KEY, timerTask);
                    this.connectionManager.addTimerTask(timerTask, resumptionTimeout * 1000);
                    service.getSessionData().put(RESUMPTION_TIMEOUT_START_KEY, System.currentTimeMillis());
                    service.clearWaitingPackets();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Service stopped - resumption enabled and timeout started [{0}]", new Object[]{service});
                    }
                }
            }
            return false;
        }
        if (id != null) {
            this.services.remove(id, service);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Service stopped - resumption disabled, sending unacked packets [{0}]", new Object[]{service});
        }
        service.clearWaitingPackets();
        this.connectionManager.serviceStopped(service);
        this.sendErrorsForQueuedPackets(service);
        return false;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.connectionManager.getName() + "/" + this.getId(), "Number of resume services", this.services.size(), Level.FINEST);
        }
    }

    @Override
    public void streamError(XMPPIOService service, StreamError streamErrorName) {
    }

    protected boolean shouldRequestAck(XMPPIOService service, OutQueue outQueue) {
        if (Math.min(outQueue.unackedSinceLastRequest(), outQueue.waitingForAck()) >= this.ack_request_count) {
            return !outQueue.gotAckOrSentRequestSince(System.currentTimeMillis() - this.ack_request_min_delay);
        }
        return false;
    }

    protected Counter newCounter() {
        return new Counter();
    }

    protected OutQueue newOutQueue() {
        return new OutQueue();
    }

    protected boolean isStanza(Packet packet) {
        return switch (packet.getElemName()) {
            case "iq", "message", "presence" -> true;
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String moveStream(XMPPIOService service, String id, int h) throws IOException, ResumptionException {
        XMPPIOService oldService = this.services.get(id);
        if (oldService == null || !this.isSameUser(oldService, service)) {
            throw new ResumptionException(Authorization.ITEM_NOT_FOUND);
        }
        if (service.getUserJid() != null && JID.jidInstanceNS((String)service.getUserJid()).getResource() != null) {
            throw new ResumptionException(Authorization.UNEXPECTED_REQUEST);
        }
        if (this.services.remove(id, oldService)) {
            XMPPIOService xMPPIOService = oldService;
            synchronized (xMPPIOService) {
                TimerTask timerTask = (TimerTask)oldService.getSessionData().get(RESUMPTION_TASK_KEY);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                oldService.clearWaitingPackets();
            }
            OutQueue outQueue = (OutQueue)oldService.getSessionData().get(OUT_COUNTER_KEY);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Resuming stream with id = {1} with {2} packets waiting for ack, local h = {3} and remote h = {4} [{0}]", new Object[]{service, id, outQueue.waitingForAck(), outQueue.get(), h});
            }
            outQueue.ack(h);
            service.getSessionData().put(OUT_COUNTER_KEY, outQueue);
            service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, oldService.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY));
            service.getSessionData().put(IN_COUNTER_KEY, oldService.getSessionData().get(IN_COUNTER_KEY));
            service.getSessionData().put(STREAM_ID_KEY, oldService.getSessionData().get(STREAM_ID_KEY));
            return oldService.getConnectionId().toString();
        }
        throw new ResumptionException(Authorization.ITEM_NOT_FOUND);
    }

    private void resumeStream(XMPPIOService service, String id, int h) throws IOException {
        try {
            String oldConnId = this.moveStream(service, id, h);
            Packet cmd = StreamManagementCommand.STREAM_MOVED.create(service.getConnectionId(), service.getDataReceiver());
            cmd.setPacketFrom(service.getConnectionId());
            cmd.setPacketTo(service.getDataReceiver());
            Command.addFieldValue(cmd, "old-conn-jid", oldConnId);
            Command.addFieldValue(cmd, "send-response", "true");
            this.connectionManager.processOutPacket(cmd);
        }
        catch (ResumptionException ex) {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><" + ex.getName() + " xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
        }
    }

    private boolean isSameUser(XMPPIOService oldService, XMPPIOService newService) {
        if (oldService.getUserJid() == null || newService.getUserJid() == null) {
            return false;
        }
        JID oldUserJid = JID.jidInstanceNS((String)oldService.getUserJid());
        JID newUserJid = JID.jidInstanceNS((String)newService.getUserJid());
        return oldUserJid.getBareJID().equals((Object)newUserJid.getBareJID());
    }

    private void sendErrorsForQueuedPackets(XMPPIOService service) {
        service.clearWaitingPackets();
        OutQueue outQueue = (OutQueue)service.getSessionData().remove(OUT_COUNTER_KEY);
        if (outQueue != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Service stopped - returning errors for {1} packets in queue [{0}]", new Object[]{service, outQueue.waitingForAck()});
            }
            OutQueue.Entry e = null;
            while ((e = outQueue.queue.poll()) != null) {
                this.connectionManager.processUndeliveredPacket(e.getPacketWithStamp(), e.stamp, null);
            }
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class OutQueue
    extends Counter {
        private final ArrayDeque<Entry> queue = new ArrayDeque();
        private long lastConfirmationAt = 0L;
        private long lastRequestSentAt = 0L;
        private int lastRequestSentFor = 0;
        private int ackRequestCount = 10;

        private boolean shouldCheckTimeout() {
            return this.queue.size() > this.ackRequestCount + 3;
        }

        @Deprecated
        @TigaseDeprecated(removeIn="9.0.0", since="8.2.0", note="Use method with maxQueueSize")
        public boolean append(Packet packet, int timeoutInSec) {
            return this.append(packet, Integer.MAX_VALUE, timeoutInSec);
        }

        public boolean append(Packet packet, int maxQueueSize, int timeoutInSec) {
            if (!packet.wasProcessedBy(StreamManagementIOProcessor.XMLNS)) {
                Entry first;
                if (this.queue.size() > maxQueueSize) {
                    return false;
                }
                if (this.shouldCheckTimeout() && (first = this.queue.peekFirst()) != null && System.currentTimeMillis() - first.stamp > (long)timeoutInSec * 1000L) {
                    return false;
                }
                packet.processedBy(StreamManagementIOProcessor.XMLNS);
                this.queue.offer(new Entry(packet));
                this.inc();
                return true;
            }
            return true;
        }

        public void ack(int value) {
            int count = this.get() - value;
            if (count < 0) {
                count = Integer.MAX_VALUE - value + this.get() + 1;
            }
            this.lastConfirmationAt = System.currentTimeMillis();
            while (count < this.queue.size()) {
                this.queue.poll();
            }
        }

        public void sendingRequest() {
            this.lastRequestSentAt = System.currentTimeMillis();
            this.lastRequestSentFor = this.get();
        }

        public void setAckRequestCount(int ackRequestCount) {
            this.ackRequestCount = ackRequestCount;
        }

        @Deprecated
        @TigaseDeprecated(removeIn="9.0.0", since="8.3.0", note="Method will not be called any more")
        public void setResumptionEnabled(boolean enabled) {
        }

        public int waitingForAck() {
            return this.queue.size();
        }

        protected ArrayDeque<Entry> getQueue() {
            return this.queue;
        }

        protected long getLastConfirmationAt() {
            return this.lastConfirmationAt;
        }

        protected long getLastRequestSentAt() {
            return this.lastRequestSentAt;
        }

        protected boolean gotAckOrSentRequestSince(long since) {
            return Math.max(this.lastConfirmationAt, this.lastRequestSentAt) > since;
        }

        protected int unackedSinceLastRequest() {
            int count = this.get();
            if (count >= this.lastRequestSentFor) {
                return count - this.lastRequestSentFor;
            }
            return count + (Integer.MAX_VALUE - this.lastRequestSentFor);
        }

        public static class Entry {
            private final Packet packet;
            private final long stamp = System.currentTimeMillis();

            public Entry(Packet packet) {
                this.packet = packet;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Packet getPacketWithStamp() {
                Packet result = this.packet.copyElementOnly();
                if (result.getElemName() != "iq" && !result.isXMLNSStaticStr(DELAY_PATH, StreamManagementIOProcessor.DELAY_XMLNS)) {
                    String stamp = null;
                    SimpleDateFormat simpleDateFormat = formatter;
                    synchronized (simpleDateFormat) {
                        stamp = formatter.format(this.stamp);
                    }
                    String from = null;
                    if (this.packet.getStanzaTo() != null) {
                        from = this.packet.getStanzaTo().getDomain();
                    } else if (this.packet.getPacketTo() != null) {
                        from = this.packet.getPacketTo().getDomain();
                    } else {
                        from = DNSResolverFactory.getInstance().getDefaultHost();
                        if (log.isLoggable(Level.WARNING)) {
                            log.log(Level.WARNING, "unacked packet without stanzaTo: {0}, and packetTo: {1}; setting from to: {2}; packet: {3} ", new Object[]{this.packet.getStanzaTo(), this.packet.getPacketTo(), from, this.packet.toString()});
                        }
                    }
                    Element x = new Element("delay", new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, StreamManagementIOProcessor.DELAY_XMLNS});
                    Element carbon = result.getElement().findChild(e -> e.getXMLNS() == "urn:xmpp:carbons:2");
                    if (carbon == null) {
                        result.getElement().addChild((XMLNodeIfc)x);
                    } else {
                        Element message;
                        Element forwarded = carbon.getChild("forwarded", "urn:xmpp:forward:0");
                        if (forwarded != null && (message = forwarded.getChild("message")) != null) {
                            message.addChild((XMLNodeIfc)x);
                        }
                    }
                }
                return result;
            }
        }
    }

    public static class Counter {
        private int counter = 0;

        public void inc() {
            ++this.counter;
            if (this.counter < 0) {
                this.counter = 0;
            }
        }

        public int get() {
            return this.counter;
        }

        protected void setCounter(int value) {
            this.counter = value;
        }
    }

    private class ResumptionTimeoutTask
    extends TimerTask {
        private final XMPPIOService service;

        public ResumptionTimeoutTask(XMPPIOService service) {
            this.service = service;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled()) {
                super.cancel(mayInterruptIfRunning);
            }
        }

        @Override
        public void run() {
            String id = (String)this.service.getSessionData().get(StreamManagementIOProcessor.STREAM_ID_KEY);
            if (StreamManagementIOProcessor.this.services.remove(id, this.service)) {
                this.service.clearWaitingPackets();
                StreamManagementIOProcessor.this.connectionManager.serviceStopped(this.service);
                StreamManagementIOProcessor.this.sendErrorsForQueuedPackets(this.service);
            }
        }
    }

    public static class ResumptionException
    extends ComponentException {
        public ResumptionException(Authorization errorCondition) {
            super(errorCondition);
        }
    }
}

