/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.monitor;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.TickMinuteEvent;
import tigase.kernel.beans.Autostart;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.XMPPServer;
import tigase.sys.TigaseRuntime;

@Bean(name="status-report-generator", parent=Kernel.class, active=true)
@Autostart
public class StatusReportGenerator
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(StatusReportGenerator.class.getName());
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Status report generator enabled")
    private boolean reportGeneratorEnabled = true;
    Template template = null;

    private static StringBuilder append(StringBuilder sb, String name, String value) {
        sb.append("'").append(name).append("': ");
        sb.append("'").append(value).append("'");
        return sb;
    }

    private static StringBuilder append(StringBuilder sb, String name, int value) {
        sb.append("'").append(name).append("': ");
        sb.append(value);
        return sb;
    }

    private static StringBuilder append(StringBuilder sb, String name, double value) {
        sb.append("'").append(name).append("': ");
        sb.append(String.format(Locale.ROOT, "%.2f", value));
        return sb;
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
        GStringTemplateEngine templateEngine = new GStringTemplateEngine();
        try (InputStream in = StatusReportGenerator.class.getResourceAsStream("/templates/StatusReportTemplate.html");){
            this.template = templateEngine.createTemplate((Reader)new InputStreamReader(in));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.reportGeneratorEnabled) {
            this.writeServerStatusFile();
        }
    }

    public void writeServerStatusFile() {
        try (FileWriter w = new FileWriter("logs/server-info.html");){
            this.processTemplate(w);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot write server-info.html file", e);
        }
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @HandleEvent
    void handleTickEvent(TickMinuteEvent event) {
        if (this.reportGeneratorEnabled) {
            this.writeServerStatusFile();
        }
    }

    private String prepareJSON() {
        TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        StatusReportGenerator.append(sb, "data-uptime", runtime.getUptimeString()).append(",");
        StatusReportGenerator.append(sb, "data-load-average", runtime.getLoadAverage()).append(",");
        StatusReportGenerator.append(sb, "data-cpus-no", runtime.getCPUsNumber()).append(",");
        StatusReportGenerator.append(sb, "data-threads-count", runtime.getThreadsNumber()).append(",");
        StatusReportGenerator.append(sb, "data-cpu-usage-proc", runtime.getCPUUsage()).append(",");
        StatusReportGenerator.append(sb, "data-heap-usage-proc", runtime.getHeapMemUsage()).append(",");
        StatusReportGenerator.append(sb, "data-nonheap-usage-proc", runtime.getNonHeapMemUsage()).append(",");
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StatusReportGenerator.append(sb, "version", XMPPServer.getImplementationVersion()).append(",");
        StatusReportGenerator.append(sb, "report-creation-timstamp", dtf.format(new Date()));
        sb.append("}");
        return sb.toString();
    }

    private void processTemplate(Writer writer) throws IOException, ClassNotFoundException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("dataJson", this.prepareJSON());
        Writable result = this.template.make(context);
        result.writeTo(writer);
    }
}

