/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.util.logging.Level;
import javax.script.ScriptEngineManager;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.modules.Module;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.component.EventPublisherModule;
import tigase.eventbus.component.EventReceiverModule;
import tigase.eventbus.component.EventbusDiscoveryModule;
import tigase.eventbus.component.SubscribeModule;
import tigase.eventbus.component.UnsubscribeModule;
import tigase.eventbus.component.stores.Affiliation;
import tigase.eventbus.component.stores.AffiliationStore;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.jid.JID;

@Bean(name="eventbus", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class EventBusComponent
extends AbstractKernelBasedComponent
implements ClusteredComponentIfc {
    @Override
    public String getDiscoCategory() {
        return "pubsub";
    }

    @Override
    public String getDiscoCategoryType() {
        return "service";
    }

    @Override
    public String getDiscoDescription() {
        return "Distributed EventBus";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return false;
    }

    @Override
    public boolean isSubdomain() {
        return false;
    }

    @Override
    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        Module module = (Module)this.kernel.getInstance("subscribe");
        if (module != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeDisconnected(jid);
        }
        this.kernel.getInstance(AffiliationStore.class).removeAffiliation(jid);
    }

    @Override
    public void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    @Override
    public int processingInThreads() {
        return TigaseRuntime.getTigaseRuntime().getCPUsNumber();
    }

    @Override
    public int processingOutThreads() {
        return TigaseRuntime.getTigaseRuntime().getCPUsNumber();
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
    }

    @Override
    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Cluster node " + jid + " added to Affiliation Store");
        }
        this.kernel.getInstance(AffiliationStore.class).putAffiliation(jid, Affiliation.owner);
        Module module = (Module)this.kernel.getInstance("subscribe");
        if (module != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeConnected(jid);
        }
    }

    @Override
    protected void registerModules(Kernel kernel) {
        kernel.registerBean("scriptEngineManager").asInstance(new ScriptEngineManager()).exec();
        kernel.registerBean("eventBusRegistrar").asInstance(EventBusFactory.getRegistrar()).exec();
        kernel.registerBean("localEventBus").asInstance(EventBusFactory.getInstance()).exec();
        kernel.registerBean(XmppPingModule.class).exec();
        kernel.registerBean(JabberVersionModule.class).exec();
        kernel.registerBean(AdHocCommandModule.class).exec();
        kernel.registerBean(EventbusDiscoveryModule.class).exec();
        kernel.registerBean(SubscribeModule.class).exec();
        kernel.registerBean(UnsubscribeModule.class).exec();
        kernel.registerBean(EventPublisherModule.class).exec();
        kernel.registerBean(EventReceiverModule.class).exec();
    }
}

