/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.RepositoryFactory;
import tigase.db.RepositoryPool;
import tigase.db.beans.MDPoolBean;
import tigase.db.util.DBInitForkJoinPoolCache;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;

public abstract class MDPoolConfigBean<A, B extends MDPoolConfigBean<A, B>>
implements Initializable,
ConfigurationChangedAware,
RegistrarBean {
    private static final Logger log = Logger.getLogger(MDPoolConfigBean.class.getCanonicalName());
    @ConfigField(alias="repo-class", desc="Class implementing repository", allowAliasFromParent=false)
    protected String cls;
    @Inject
    protected MDPoolBean<A, B> mdPool;
    @ConfigField(desc="Name (ie. domain)")
    protected String name;
    @ConfigField(alias="pool-class", desc="Class implementing repository pool", allowAliasFromParent=false)
    protected String poolCls;
    @ConfigField(alias="pool-size", desc="Pool size", allowAliasFromParent=false)
    protected int poolSize = RepositoryFactory.USER_REPO_POOL_SIZE_PROP_VAL;
    @ConfigField(alias="repo-uri", desc="URI for repository", allowAliasFromParent=false, type=ConfigFieldType.JdbcUrl)
    protected String uri;
    @Inject(nullAllowed=true)
    private Set<A> instances;
    private Kernel kernel;
    @Inject(bean="instance", nullAllowed=true)
    private A repository;
    private boolean skipInitializationErrors = false;

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (this.name == null || this.getUri() == null || this.kernel == null) {
            return;
        }
        try {
            String cls = this.getRepositoryClassName();
            if (cls == null) {
                return;
            }
            Class<?> repoClass = ModulesManagerImpl.getInstance().forName(cls);
            String poolCls = this.getRepositoryPoolClassName();
            Kernel.DelayedDependencyInjectionQueue queue = this.kernel.beginDependencyDelayedInjection();
            if (poolCls == null) {
                if (this.repository == null || changedFields.contains("poolCls")) {
                    this.kernel.registerBean("instance").asClass(repoClass).exec();
                }
            } else if (this.repository == null || changedFields.contains("poolCls") || changedFields.contains("poolSize")) {
                Class<?> poolClass = ModulesManagerImpl.getInstance().forName(poolCls);
                for (int i = 0; i < this.poolSize; ++i) {
                    this.kernel.registerBean("repo-" + i).asClass(repoClass).exec();
                }
                this.kernel.registerBean("instance").asClass(poolClass).exec();
            }
            this.kernel.finishDependecyDelayedInjection(queue);
            this.unloadOldBeans();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | DBInitException ex) {
            throw new RuntimeException("Could not initialize " + this.getRepositoryIfc().getCanonicalName() + " for name '" + this.name + "'", ex);
        }
    }

    public void unloadOldBeans() {
        ArrayList<BeanConfig> beanConfigs = new ArrayList<BeanConfig>(this.kernel.getDependencyManager().getBeanConfigs());
        for (BeanConfig bc : beanConfigs) {
            if (!bc.getBeanName().startsWith("repo-")) continue;
            try {
                Integer pos = Integer.parseInt(bc.getBeanName().replace("repo-", ""));
                if (this.getRepositoryPoolClassName() != null && pos < this.poolSize) continue;
                this.kernel.unregister(bc.getBeanName());
            }
            catch (NumberFormatException | DBInitException exception) {}
        }
    }

    @Override
    public void initialize() {
        this.beanConfigurationChanged(Collections.singletonList("uri"));
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    public void setInstances(Set<A> instances) {
        if (instances != null) {
            Iterator<A> iter = instances.iterator();
            while (iter.hasNext()) {
                A it = iter.next();
                if (!(it instanceof MDPoolBean)) continue;
                iter.remove();
            }
        }
        HashSet<A> toInitialize = new HashSet<A>(instances);
        if (this.instances != null) {
            toInitialize.removeAll(this.instances);
        }
        if (!toInitialize.isEmpty()) {
            ForkJoinTask task;
            ArrayDeque<Future> tasks = new ArrayDeque<Future>();
            ForkJoinPool pool = DBInitForkJoinPoolCache.shared.pool((String)(this.repository == null ? "dbinit" : "dbinit-" + this.repository.hashCode()), Math.min(toInitialize.size(), 128));
            for (Object repo : toInitialize) {
                tasks.offer(pool.submit(() -> {
                    try {
                        this.initRepository(repo);
                    }
                    catch (RepositoryException ex) {
                        if (this.skipInitializationErrors) {
                            Logger.getLogger(this.getClass().getCanonicalName()).log(Level.WARNING, "Could not initialize " + repo.getClass().getCanonicalName() + " for name '" + this.name + "'", ex);
                        }
                        throw new RuntimeException("Could not initialize " + repo.getClass().getCanonicalName() + " for name '" + this.name + "'", ex);
                    }
                    return repo;
                }));
            }
            while ((task = (ForkJoinTask)tasks.poll()) != null) {
                Object repo;
                repo = task.join();
                if (!(this.repository instanceof RepositoryPool) || repo instanceof RepositoryPool) continue;
                ((RepositoryPool)this.repository).addRepo(repo);
            }
        }
        this.instances = instances;
    }

    public void setMdPool(MDPoolBean<A, B> mdPool) {
        if (mdPool != null && this.repository != null) {
            mdPool.addRepo(this.name, this.repository);
            if ("default".equals(this.name)) {
                mdPool.setDefault(this.repository);
            }
        }
        this.mdPool = mdPool;
    }

    protected abstract Class<? extends A> getRepositoryIfc();

    protected abstract String getRepositoryPoolClassName() throws DBInitException;

    protected abstract void initRepository(A var1) throws RepositoryException;

    protected String getRepositoryClassName() throws DBInitException {
        if (this.cls != null) {
            return this.cls;
        }
        return RepositoryFactory.getRepoClassName(this.getRepositoryIfc(), this.uri);
    }

    protected String getUri() {
        return this.uri;
    }

    protected A getRepository() {
        return this.repository;
    }

    public void setRepository(A repo) {
        this.repository = repo;
        if (repo != null && this.instances != null) {
            for (A instance : this.instances) {
                if (!(this.repository instanceof RepositoryPool) || instance instanceof RepositoryPool) continue;
                ((RepositoryPool)this.repository).addRepo(instance);
            }
        }
        if (this.mdPool != null) {
            if (repo != null) {
                this.mdPool.addRepo(this.name, repo);
            } else {
                this.mdPool.removeRepo(this.name);
            }
            if ("default".equals(this.name)) {
                this.mdPool.setDefault(repo);
            }
        }
    }
}

