/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;

public class RSAPrivateKeyDecoder {
    private InputStream is = null;

    public RSAPrivateKeyDecoder(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public RSAPrivateKeyDecoder(InputStream is) {
        this.is = is;
    }

    public RSAPrivateCrtKeySpec getKeySpec() throws IOException {
        int tag = this.is.read();
        int len = this.readLength();
        BigInteger ver = this.nextInt();
        BigInteger mod = this.nextInt();
        BigInteger pubExp = this.nextInt();
        BigInteger privExp = this.nextInt();
        BigInteger prime1 = this.nextInt();
        BigInteger prime2 = this.nextInt();
        BigInteger exp1 = this.nextInt();
        BigInteger exp2 = this.nextInt();
        BigInteger coef = this.nextInt();
        return new RSAPrivateCrtKeySpec(mod, pubExp, privExp, prime1, prime2, exp1, exp2, coef);
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(this.getKeySpec());
    }

    private BigInteger nextInt() throws IOException {
        int tag = this.is.read();
        int len = this.readLength();
        byte[] val = new byte[len];
        int res = this.is.read(val);
        if (res < len) {
            throw new IOException("Invalid DER data: data too short.");
        }
        return new BigInteger(val);
    }

    private int readLength() throws IOException {
        int len = this.is.read();
        if (len == -1) {
            throw new IOException("Invalid field length in DER data.");
        }
        if ((len & 0xFFFFFF80) == 0) {
            return len;
        }
        int size = len & 0x7F;
        if (len >= 255 || size > 4) {
            throw new IOException("Invalid field length in DER data: too big (" + len + ")");
        }
        byte[] bytes = new byte[size];
        int res = this.is.read(bytes);
        if (res < size) {
            throw new IOException("Invalid DER file: data too short.");
        }
        return new BigInteger(1, bytes).intValue();
    }
}

