/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.archive.FasteningCollation;
import tigase.archive.xep0136.Query;
import tigase.archive.xep0313.QueryImpl;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.rsm.RSM;

public class QueryCriteria
extends QueryImpl
implements Query {
    public static final String QUERTY_XMLNS = "http://tigase.org/protocol/archive#query";
    private final Set<String> contains = new HashSet<String>();
    private final Set<String> tags = new HashSet<String>();
    private List<Element> collections;
    private List<Element> items;
    private boolean useMessageIdInRsm = true;

    @Override
    public Set<String> getContains() {
        return Collections.unmodifiableSet(this.contains);
    }

    @Override
    public void addContains(String contain) {
        this.contains.add(contain);
    }

    public FasteningCollation getFasteningCollation() {
        return FasteningCollation.full;
    }

    @Override
    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean getUseMessageIdInRsm() {
        return this.useMessageIdInRsm;
    }

    @Override
    public void setUseMessageIdInRsm(boolean value) {
        this.useMessageIdInRsm = value;
    }

    @Override
    public void prepareResult(Element retList) {
        RSM rsm = this.getRsm();
        if (rsm.getCount() == null || rsm.getCount() != 0) {
            retList.addChild((XMLNodeIfc)rsm.toElement());
        }
    }

    @Override
    public void addCollection(Element collection) {
        if (this.collections == null) {
            this.collections = new ArrayList<Element>();
        }
        this.collections.add(collection);
    }

    @Override
    public List<Element> getCollections() {
        return this.collections;
    }

    @Override
    public void addItem(Element item) {
        if (this.items == null) {
            this.items = new ArrayList<Element>();
        }
        this.items.add(item);
    }

    @Override
    public List<Element> getItems() {
        if (this.items == null) {
            return Collections.emptyList();
        }
        return this.items;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QueryCriteria{");
        sb.append("QueryImpl='").append(super.toString()).append('\'');
        sb.append(", contains=").append(this.contains);
        sb.append(", tags=").append(this.tags);
        sb.append(", collections=").append(this.collections);
        sb.append(", useMessageIdInRsm=").append(this.useMessageIdInRsm);
        sb.append(", fasteningCollation=").append((Object)this.getFasteningCollation());
        sb.append('}');
        return sb.toString();
    }
}

