/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.modules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IMeetLogic;
import tigase.meet.IMeetRepository;
import tigase.meet.MediaType;
import tigase.meet.MeetComponent;
import tigase.meet.modules.AbstractModule;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="createMeetModule", parent=MeetComponent.class, active=true)
public class CreateMeetModule
extends AbstractModule {
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"create", (String)"tigase:meet:0"));
    private static final String[] b = new String[]{"tigase:meet:0"};
    @Inject
    private IMeetLogic logic;
    @Inject
    private IMeetRepository meetRepository;

    public String[] getFeatures() {
        return b;
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    @Override
    public CompletableFuture<Packet> processPacket(Packet packet) throws ComponentException, TigaseStringprepException {
        if (StanzaType.set != packet.getType()) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        this.logic.checkCreatePermission(packet.getStanzaTo().getBareJID(), packet.getStanzaFrom());
        Element element2 = Optional.ofNullable(packet.getElemChild("create", "tigase:meet:0")).orElseThrow(() -> new ComponentException(Authorization.BAD_REQUEST, "Missing `create` element"));
        List list = Optional.ofNullable(element2.mapChildren(element -> "media".equals(element.getName()), element -> MediaType.valueOf(element.getAttributeStaticStr("type")))).orElse(Collections.emptyList());
        if (!list.contains((Object)MediaType.video)) {
            throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED, "Only audio and video media are supported!");
        }
        List list2 = Optional.ofNullable(element2.mapChildren(element -> "participant".equals(element.getName()), element -> BareJID.bareJIDInstanceNS((String)element.getCData()))).orElse(Collections.emptyList());
        BareJID bareJID = BareJID.bareJIDInstance((String)UUID.randomUUID().toString(), (String)packet.getStanzaTo().getDomain());
        this.log.log(Level.FINEST, () -> "user " + packet.getStanzaFrom() + " initiated meet creation with jid " + bareJID + ", media: " + list + ", and allowed: " + list2);
        return ((CompletableFuture)this.meetRepository.create(bareJID, this.logic.getDefMaxNoOfPublishers()).thenApply(meet -> {
            meet.allow(packet.getStanzaFrom().getBareJID());
            for (BareJID bareJID : list2) {
                meet.allow(bareJID);
            }
            Element element = new Element("create");
            element.setXMLNS("tigase:meet:0");
            element.setAttribute("id", meet.getJid().getLocalpart());
            return packet.okResult(element, 0);
        })).whenComplete((packet2, throwable) -> {
            if (throwable != null) {
                this.log.log(Level.FINEST, (Throwable)throwable, () -> "meet " + bareJID + " creation by " + packet.getStanzaFrom() + " failed");
            } else {
                this.log.log(Level.FINEST, () -> "meet " + bareJID + " creation by " + packet.getStanzaFrom() + " succeeded");
            }
        });
    }
}

