/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.modules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IMeetLogic;
import tigase.meet.IMeetRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.modules.AbstractModule;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="allowMeetModule", parent=MeetComponent.class, active=true)
public class AllowMeetModule
extends AbstractModule {
    private static final Criteria a = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"allow", (String)"tigase:meet:0"));
    @Inject
    private IMeetLogic logic;
    @Inject
    private IMeetRepository meetRepository;

    @Override
    public CompletableFuture<Packet> processPacket(Packet packet) throws ComponentException, TigaseStringprepException {
        if (StanzaType.set != packet.getType()) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        Meet meet = this.meetRepository.getMeet(packet.getStanzaTo().getBareJID());
        Element element2 = Optional.ofNullable(packet.getElemChild("allow", "tigase:meet:0")).orElseThrow(() -> new ComponentException(Authorization.BAD_REQUEST, "Missing `allow` element"));
        List list = Optional.ofNullable(element2.mapChildren(element -> "participant".equals(element.getName()), element -> BareJID.bareJIDInstanceNS((String)element.getCData()))).orElse(Collections.emptyList());
        for (BareJID bareJID : list) {
            meet.allow(bareJID);
        }
        return CompletableFuture.completedFuture(packet.okResult((String)null, 0));
    }

    public Criteria getModuleCriteria() {
        return a;
    }
}

