/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.xml.Element;

public class SSRC {
    private final String a;
    private final List<Parameter> b;

    public static SSRC from(Element el) {
        if ("source".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(el.getXMLNS())) {
            String string = el.getAttributeStaticStr("ssrc");
            if (string == null) {
                string = el.getAttributeStaticStr("id");
            }
            if (string == null) {
                return null;
            }
            List<Parameter> list = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(Parameter::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new SSRC(string, list);
        }
        return null;
    }

    public static List<SSRC> from(String[] lines) {
        Stream<String> stream = Arrays.stream(lines).filter(string -> string.startsWith("a=ssrc:")).map(string -> string.substring("a=ssrc:".length())).map(string -> string.split(" ")[0]).distinct();
        Optional<String> optional = Arrays.stream(lines).filter(string -> string.startsWith("a=msid:")).map(string -> string.substring("a=msid:".length())).findFirst();
        return stream.map(string3 -> {
            String string4 = "a=ssrc:" + string3;
            List<Parameter> list = Arrays.stream(lines).filter(string2 -> string2.startsWith(string4)).map(string2 -> string2.substring(string4.length())).map(string -> string.split(":")).filter(stringArray -> !stringArray[0].trim().isEmpty()).map(stringArray -> new Parameter(stringArray[0].trim(), Optional.ofNullable(((String[])stringArray).length == 1 ? null : Arrays.stream(stringArray).skip(1L).collect(Collectors.joining(":"))))).collect(Collectors.toList());
            if (list.stream().filter(parameter -> "msid".equals(parameter.getName())).findAny().isEmpty()) {
                optional.ifPresent(string -> list.add(new Parameter("msid", optional)));
            }
            return new SSRC((String)string3, list);
        }).collect(Collectors.toList());
    }

    public SSRC(String ssrc, List<Parameter> parameters) {
        this.a = ssrc;
        this.b = parameters;
    }

    public String getSsrc() {
        return this.a;
    }

    public List<Parameter> getParameters() {
        return this.b;
    }

    public Element toElement() {
        Element element = new Element("source");
        element.setXMLNS("urn:xmpp:jingle:apps:rtp:ssma:0");
        element.setAttribute("ssrc", this.a);
        element.setAttribute("id", this.a);
        this.b.stream().map(Parameter::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    public List<String> toSDP() {
        return this.b.stream().map(parameter -> "a=ssrc:" + this.a + " " + parameter.toSDP()).collect(Collectors.toList());
    }

    public static class Parameter {
        private final String a;
        private final Optional<String> b;

        public static Parameter from(Element el) {
            if ("parameter".equals(el.getName())) {
                String string = el.getAttributeStaticStr("name");
                Optional<String> optional = Optional.ofNullable(el.getAttributeStaticStr("value"));
                return new Parameter(string, optional);
            }
            return null;
        }

        public Parameter(String name, Optional<String> value) {
            this.a = name;
            this.b = value;
        }

        public String getName() {
            return this.a;
        }

        public Optional<String> getValue() {
            return this.b;
        }

        public Element toElement() {
            Element element = new Element("parameter");
            element.setAttribute("name", this.a);
            this.b.ifPresent(string -> element.setAttribute("value", string));
            return element;
        }

        public String toSDP() {
            if (this.b.isPresent()) {
                return this.a + ":" + this.b.get();
            }
            return this.a;
        }
    }
}

