/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Optional;
import java.util.UUID;
import tigase.xml.Element;

public class Candidate {
    private final String a;
    private final String b;
    private final int c;
    private final String d;
    private final String e;
    private final int f;
    private final int g;
    private final int h;
    private final ProtocolType i;
    private final Optional<String> j;
    private final Optional<Integer> k;
    private final Optional<CandidateType> l;
    private final Optional<String> m;

    public static Candidate from(Element el) {
        if ("candidate".equals(el.getName())) {
            String string = el.getAttributeStaticStr("component");
            String string2 = el.getAttributeStaticStr("foundation");
            String string3 = el.getAttributeStaticStr("generation");
            String string4 = el.getAttributeStaticStr("id");
            if (string4 == null) {
                string4 = UUID.randomUUID().toString();
            }
            String string5 = el.getAttributeStaticStr("ip");
            String string6 = el.getAttributeStaticStr("network");
            String string7 = el.getAttributeStaticStr("port");
            String string8 = el.getAttributeStaticStr("priority");
            String string9 = el.getAttributeStaticStr("protocol");
            if (string == null || string2 == null || string3 == null || string5 == null || string6 == null || string7 == null || string8 == null || string9 == null) {
                return null;
            }
            Optional<String> optional = Optional.ofNullable(el.getAttributeStaticStr("rel-addr"));
            Optional<Integer> optional2 = Optional.ofNullable(el.getAttributeStaticStr("rel-port")).map(Integer::parseInt);
            Optional<CandidateType> optional3 = Optional.ofNullable(el.getAttributeStaticStr("type")).map(CandidateType::valueOf);
            Optional<String> optional4 = Optional.ofNullable(el.getAttributeStaticStr("tcptype"));
            return new Candidate(string, string2, Integer.parseInt(string3), string4, string5, Integer.parseInt(string6), Integer.parseInt(string7), Integer.parseInt(string8), ProtocolType.valueOf(string9), optional, optional2, optional3, optional4);
        }
        return null;
    }

    public static Candidate from(String line) {
        int n = "candidate:".length() + (line.startsWith("a=") ? 2 : 0);
        String[] stringArray = line.substring(n).split(" ");
        if (stringArray.length >= 8) {
            ProtocolType protocolType = ProtocolType.valueOf(stringArray[2].toLowerCase());
            int n2 = Integer.parseInt(stringArray[3]);
            int n3 = Integer.parseInt(stringArray[5]);
            CandidateType candidateType = CandidateType.valueOf(stringArray[7]);
            Optional<Integer> optional = Optional.empty();
            Optional<String> optional2 = Optional.empty();
            Optional<Integer> optional3 = Optional.empty();
            Optional<String> optional4 = Optional.empty();
            int n4 = 8;
            while (stringArray.length >= n4 + 2) {
                switch (stringArray[n4]) {
                    case "tcptype": {
                        optional4 = Optional.ofNullable(stringArray[n4 + 1]);
                        break;
                    }
                    case "generation": {
                        optional = Optional.ofNullable(stringArray[n4 + 1]).map(Integer::parseInt);
                        break;
                    }
                    case "raddr": {
                        optional2 = Optional.ofNullable(stringArray[n4 + 1]);
                        break;
                    }
                    case "rport": {
                        optional3 = Optional.ofNullable(stringArray[n4 + 1]).map(Integer::parseInt);
                        break;
                    }
                    default: {
                        --n4;
                    }
                }
                n4 += 2;
            }
            return new Candidate(stringArray[1], stringArray[0], optional.orElse(0), UUID.randomUUID().toString(), stringArray[4], 0, n3, n2, protocolType, optional2, optional3, Optional.of(candidateType), optional4);
        }
        return null;
    }

    public Candidate(String component, String foundation, int generation, String id, String ip, int network, int port, int priority, ProtocolType protocolType, Optional<String> relAddr, Optional<Integer> relPort, Optional<CandidateType> type, Optional<String> tcpType) {
        this.a = component;
        this.b = foundation;
        this.c = generation;
        this.d = id;
        this.e = ip;
        this.f = network;
        this.g = port;
        this.h = priority;
        this.i = protocolType;
        this.j = relAddr;
        this.k = relPort;
        this.l = type;
        this.m = tcpType;
    }

    public String getComponent() {
        return this.a;
    }

    public String getFoundation() {
        return this.b;
    }

    public int getGeneration() {
        return this.c;
    }

    public String getId() {
        return this.d;
    }

    public String getIp() {
        return this.e;
    }

    public int getNetwork() {
        return this.f;
    }

    public int getPort() {
        return this.g;
    }

    public int getPriority() {
        return this.h;
    }

    public ProtocolType getProtocolType() {
        return this.i;
    }

    public Optional<String> getRelAddr() {
        return this.j;
    }

    public Optional<Integer> getRelPort() {
        return this.k;
    }

    public Optional<CandidateType> getType() {
        return this.l;
    }

    public Optional<String> getTcpType() {
        return this.m;
    }

    public Element toElement() {
        Element element = new Element("candidate");
        element.setAttribute("component", this.a);
        element.setAttribute("foundation", this.b);
        element.setAttribute("generation", String.valueOf(this.c));
        element.setAttribute("id", this.d);
        element.setAttribute("ip", this.e);
        element.setAttribute("network", String.valueOf(this.f));
        element.setAttribute("port", String.valueOf(this.g));
        element.setAttribute("protocol", this.i.name());
        element.setAttribute("priority", String.valueOf(this.h));
        this.j.ifPresent(string -> element.setAttribute("rel-addr", string));
        this.k.map(String::valueOf).ifPresent(string -> element.setAttribute("rel-port", string));
        this.l.map(Enum::name).ifPresent(string -> element.setAttribute("type", string));
        this.m.ifPresent(string -> element.setAttribute("tcptype", string));
        return element;
    }

    public String toSDP() {
        CandidateType candidateType = this.l.orElse(CandidateType.host);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("candidate:").append(this.b).append(" ").append(this.a).append(" ").append(this.i.name().toLowerCase()).append(" ").append(this.h).append(" ").append(this.e).append(" ").append(this.g).append(" typ ").append(candidateType.name());
        if (candidateType != CandidateType.host) {
            this.j.ifPresent(string -> this.k.ifPresent(n -> stringBuilder.append(" raddr ").append((String)string).append(" rport ").append(n)));
        }
        if (this.i == ProtocolType.tcp) {
            this.m.ifPresent(string -> stringBuilder.append(" tcptype ").append((String)string));
        }
        stringBuilder.append(" generation ").append(this.c);
        return stringBuilder.toString();
    }

    public static final class ProtocolType
    extends Enum<ProtocolType> {
        public static final /* enum */ ProtocolType udp = new ProtocolType();
        public static final /* enum */ ProtocolType tcp = new ProtocolType();
        private static final /* synthetic */ ProtocolType[] a;

        public static ProtocolType[] values() {
            return (ProtocolType[])a.clone();
        }

        public static ProtocolType valueOf(String name) {
            return Enum.valueOf(ProtocolType.class, name);
        }

        private static /* synthetic */ ProtocolType[] a() {
            return new ProtocolType[]{udp, tcp};
        }

        static {
            a = ProtocolType.a();
        }
    }

    public static final class CandidateType
    extends Enum<CandidateType> {
        public static final /* enum */ CandidateType host = new CandidateType();
        public static final /* enum */ CandidateType prlfx = new CandidateType();
        public static final /* enum */ CandidateType relay = new CandidateType();
        public static final /* enum */ CandidateType srflx = new CandidateType();
        private static final /* synthetic */ CandidateType[] a;

        public static CandidateType[] values() {
            return (CandidateType[])a.clone();
        }

        public static CandidateType valueOf(String name) {
            return Enum.valueOf(CandidateType.class, name);
        }

        private static /* synthetic */ CandidateType[] a() {
            return new CandidateType[]{host, prlfx, relay, srflx};
        }

        static {
            a = CandidateType.a();
        }
    }
}

