/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.Publisher;

public class LocalPublisher {
    private static final Logger a = Logger.getLogger(LocalPublisher.class.getCanonicalName());
    private final JanusVideoRoomPlugin b;
    private final Object c;
    private final long d;
    private final long e;
    private final ConcurrentHashMap<Long, Publisher> f = new ConcurrentHashMap();
    private Listener g;

    public static LocalPublisher fromData(Map<String, Object> data, JanusVideoRoomPlugin videoRoomPlugin, Object roomId) {
        long l = Optional.ofNullable((Number)data.get("id")).map(Number::longValue).orElseThrow(() -> new NullPointerException("Missing 'id'!"));
        long l2 = Optional.ofNullable((Number)data.get("private_id")).map(Number::longValue).orElseThrow(() -> new NullPointerException("Missing 'private_id'!"));
        return new LocalPublisher(videoRoomPlugin, roomId, l, l2, Publisher.fromEvent((List)data.get("publishers")));
    }

    public LocalPublisher(JanusVideoRoomPlugin videoRoomPlugin, Object roomId, long id, long privateId, List<Publisher> publishers) {
        this.b = videoRoomPlugin;
        this.c = roomId;
        this.d = id;
        this.e = privateId;
        this.f.putAll(publishers.stream().collect(Collectors.toMap(Publisher::getId, Function.identity())));
    }

    public long getId() {
        return this.d;
    }

    public long getPrivateId() {
        return this.e;
    }

    public Object getRoomId() {
        return this.c;
    }

    public JanusSession getSession() {
        return this.b.getSession();
    }

    public void setListener(Listener listener) {
        this.g = listener;
        if (!this.f.isEmpty()) {
            listener.addedPublishers(this.f.values());
        }
    }

    public CompletableFuture<Void> leave() {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " leaving room..");
        return ((CompletableFuture)this.b.execute("leave", string, this.c, jsonGenerator -> {}, null).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("leaving"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " failed to leave room!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " left room.");
            }
        });
    }

    public CompletableFuture<JSEP> publish(JSEP jsep) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " publishes stream..");
        return ((CompletableFuture)this.b.execute("publish", string, this.c, jsonGenerator -> {}, jsep).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("configured"))) {
                return content.jsep;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((jSEP, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " failed to publish stream!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " published stream.");
                if (jSEP != null) {
                    this.g.receivedPublisherSDP((JSEP)jSEP);
                }
            }
        });
    }

    public CompletableFuture<Void> unpublish() {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " stops publishing stream..");
        return ((CompletableFuture)this.b.execute("unpublish", string, this.c, jsonGenerator -> {}, null).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("unpublished"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " failed to stop publishing stream!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", publisher " + this.d + " stopped publishing stream.");
            }
        });
    }

    public void handleEvent(JanusVideoRoomPlugin.Content content) {
        if ("event".equals(content.getVideoRoom()) && this.c.equals(content.getRoom())) {
            List<Publisher> list = Publisher.fromEvent((List)content.data.get("publishers"));
            if (list != null) {
                this.f.putAll(list.stream().collect(Collectors.toMap(Publisher::getId, Function.identity())));
                if (this.g != null) {
                    this.g.addedPublishers(list);
                }
            } else if (content.data.containsKey("unpublished")) {
                Optional.ofNullable(content.data.get("unpublished")).filter(Number.class::isInstance).map(Number.class::cast).ifPresent(number -> {
                    this.f.remove(number.longValue());
                    if (this.g != null) {
                        this.g.removedPublishers(number.longValue());
                    }
                });
            }
        }
    }

    public Collection<Publisher> getPublishers() {
        return this.f.values();
    }

    public CompletableFuture<Void> sendCandidate(JanusPlugin.Candidate candidate) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", sending candidate " + candidate + "..");
        return this.b.sendTrickle(string, candidate).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to send candidate!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", candidate sent.");
            }
        });
    }

    public void receivedCandidate(JanusPlugin.Candidate candidate) {
        this.g.receivedPublisherCandidate(candidate);
    }

    public static interface Listener {
        public void addedPublishers(Collection<Publisher> var1);

        public void removedPublishers(long var1);

        public void receivedPublisherSDP(JSEP var1);

        public void receivedPublisherCandidate(JanusPlugin.Candidate var1);
    }
}

