/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;

public class JanusVideoRoomPlugin
extends JanusPlugin<Content> {
    public static final String ID = "janus.plugin.videoroom";
    private static final Logger a = Logger.getLogger(JanusVideoRoomPlugin.class.getCanonicalName());
    private LocalPublisher b;
    private LocalSubscriber c;

    public JanusVideoRoomPlugin(JanusSession session, Map<String, Object> data) {
        super(session, data);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handleEvent(Content content) {
        a.log(Level.FINER, this.toString() + ", received event with: " + content.data + " and jsep " + content.jsep);
        if (this.b != null) {
            this.b.handleEvent(content);
        }
        if (this.c != null) {
            this.c.handleEvent(content);
        }
    }

    @Override
    protected void receivedCandidate(JanusPlugin.Candidate candidate) {
        if (this.b != null) {
            this.b.receivedCandidate(candidate);
        }
        if (this.c != null) {
            this.c.receivedCandidate(candidate);
        }
    }

    public CompletableFuture<Object> createRoom(Object roomId, int maxNoOfPublishers) {
        String string = this.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + " creating room " + roomId + "...");
        return ((CompletableFuture)this.execute("create", string, roomId, jsonGenerator -> {
            jsonGenerator.writeNumberField("publishers", maxNoOfPublishers);
            jsonGenerator.writeBooleanField("notify_joining", true);
        }, null).thenApply(content -> {
            String string;
            switch (string = content.getVideoRoom()) {
                case "created": {
                    return content.getRoom();
                }
            }
            throw new UnsupportedOperationException("Unsupported response '" + string + "'");
        })).whenComplete((object2, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", room " + roomId + " creation failed!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", room " + roomId + " created.");
            }
        });
    }

    public CompletableFuture<Void> destroyRoom(Object roomId) {
        String string = this.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", destroying room..");
        return ((CompletableFuture)this.execute("destroy", string, roomId, jsonGenerator -> {}, null).thenAccept(content -> {
            String string;
            switch (string = content.getVideoRoom()) {
                case "destroyed": {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported response '" + string + "'");
                }
            }
        })).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to destruct room!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", room destroyed.");
            }
        });
    }

    public CompletableFuture<LocalPublisher> createPublisher(Object roomId, String displayName) {
        String string = this.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", joining as publisher..");
        return ((CompletableFuture)this.execute("join", string, roomId, jsonGenerator -> {
            jsonGenerator.writeStringField("ptype", "publisher");
            if (displayName != null) {
                jsonGenerator.writeStringField("display", displayName);
            }
        }, null).thenApply(content -> {
            if ("joined".equals(content.getVideoRoom())) {
                return LocalPublisher.fromData(content.data, this, roomId);
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((localPublisher, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to join as publisher!");
            } else {
                JanusVideoRoomPlugin janusVideoRoomPlugin = this;
                synchronized (janusVideoRoomPlugin) {
                    this.b = localPublisher;
                }
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", joined as publisher.");
            }
        });
    }

    public synchronized LocalSubscriber createSubscriber(Object roomId) {
        this.c = new LocalSubscriber(this, roomId);
        return this.c;
    }

    public CompletableFuture<Content> execute(String request, String transaction, Object roomId, JanusConnection.RequestGenerator requestGenerator, JSEP jsep) {
        return this.execute(transaction, jsonGenerator -> {
            jsonGenerator.writeStringField("request", request);
            if (roomId != null) {
                if (roomId instanceof Number) {
                    jsonGenerator.writeNumberField("room", ((Number)roomId).longValue());
                } else {
                    jsonGenerator.writeStringField("room", roomId.toString());
                }
            }
            requestGenerator.accept(jsonGenerator);
        }, jsep);
    }

    public CompletableFuture<Void> sendMessage(String request, String transaction, Object roomId, JanusConnection.RequestGenerator requestGenerator, JSEP jsep) {
        return this.sendMessage(transaction, jsonGenerator -> {
            jsonGenerator.writeStringField("request", request);
            if (roomId != null) {
                if (roomId instanceof Number) {
                    jsonGenerator.writeNumberField("room", ((Number)roomId).longValue());
                } else {
                    jsonGenerator.writeStringField("room", roomId.toString());
                }
            }
            requestGenerator.accept(jsonGenerator);
        }, jsep);
    }

    @Override
    protected Content newContent(Map<String, Object> data, JSEP jsep) {
        return new Content((Map)data, jsep);
    }

    public static class Content
    extends JanusPlugin.Content {
        public Content(Map data, JSEP jsep) {
            super(data, jsep);
        }

        public Object getRoom() {
            Object v = this.data.get("room");
            if (v instanceof Number) {
                return ((Number)v).longValue();
            }
            return v;
        }

        public String getVideoRoom() {
            return Optional.ofNullable((String)this.data.get("videoroom")).orElseThrow(() -> new NullPointerException("Missing 'videoroom'!"));
        }
    }

    public static class Stream {
        public final long feedId;
        public final String mid;

        public Stream(long feedId, String mid) {
            this.feedId = feedId;
            this.mid = mid;
        }

        public long getFeed() {
            return this.feedId;
        }

        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("feed", this.feedId);
            if (this.mid != null) {
                generator.writeStringField("mid", this.mid);
            }
            generator.writeEndObject();
        }
    }
}

