/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.licence.Licence;
import tigase.licence.LicenceChecker;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.meet.IMeetRepository;
import tigase.meet.MeetComponent;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPluginsRegister;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="janus", parent=MeetComponent.class, active=true)
public class JanusService
implements Initializable,
UnregisterAware {
    @ConfigField(desc="URI for connect to Janus", alias="uri")
    private String uri;
    @ConfigField(desc="Janus session timeout", alias="session-timeout")
    private Duration sessionTimeout = Duration.of(60L, ChronoUnit.SECONDS);
    private HttpClient a;
    private JanusPluginsRegister b = new JanusPluginsRegister();
    private ScheduledExecutorService c;
    private LicenceChecker d;
    @Inject(nullAllowed=true)
    private IMeetRepository meetRepository;
    private static final Logger e = Logger.getLogger(JanusService.class.getCanonicalName());

    public void initialize() {
        this.d = LicenceChecker.getLicenceChecker((String)"acs", (LicenceCheckerUpdateCallback)new LicenceCheckerUpdateCallbackImpl("acs"){

            public String getID() {
                return "meet";
            }

            public Element getComponentAdditionalData() {
                Element element = super.getComponentAdditionalData();
                element.addChild((XMLNodeIfc)new Element("meets-count", String.valueOf(JanusService.this.meetRepository.size())));
                element.addChild((XMLNodeIfc)new Element("meets-participants-max", String.valueOf(JanusService.this.meetRepository.getMaxParticipantsInMeeting())));
                return element;
            }

            public String getMissingLicenseWarning() {
                return "\nThis installation contains Tigase Meet package, not an open source software.\nThe Tigase Meet is only available under a commercial license.\nThe full text of the commercial license agreement is available upon request.\n\nMore information about Meet component and licensing can be found here:\nhttp://www.tigase.com/\nThe Tigase Meet component is provided free of charge for testing and\ndevelopment purposes only. Any use of the component on production systems,\neither commercial or not-for-profit, requires the purchase of a license.\n\nIf the Tigase Meet component is activated without a valid license, it will\ncontinue to work, including its full set of features, but it will send\ncertain statistical information to Tigase's servers on a regular basis.\nIf the Tigase Meet component cannot access our servers to send information,\nit will stop working. Once a valid license is installed, the Tigase Meet\ncomponent will stop sending statistical information to Tigase's servers.\n\nBy activating the Tigase Meet component without a valid license you agree\nand accept that the component will send certain statistical information\n(such as DNS domain names, vhost names, number of online users, number of\ncluster nodes, etc.) which may be considered confidential and proprietary\nby the user. You accept and confirm that such information, which may be\nconsidered confidential or proprietary, will be transferred to Tigase's\nservers and that you will not pursue any remedy at law as a result of the\ninformation transfer.\nIf the Tigase Meet component is installed but not activated, no statistical\ninformation will be sent to Tigase's servers.";
            }

            public boolean additionalValidation(Licence lic) {
                if (!super.additionalValidation(lic)) {
                    return false;
                }
                if (JanusService.this.meetRepository.size() > lic.getPropertyAsInteger("meets-limit")) {
                    return false;
                }
                return JanusService.this.meetRepository.getMaxParticipantsInMeeting() <= lic.getPropertyAsInteger("meets-participants-max");
            }
        });
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
            this.a = HttpClient.newBuilder().sslContext(sSLContext).build();
            this.c = Executors.newScheduledThreadPool(4);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void beforeUnregister() {
        if (this.c != null) {
            this.c.shutdown();
        }
    }

    public CompletableFuture<JanusConnection> newConnection() {
        JanusConnection janusConnection = new JanusConnection(this.b, this.c, this.sessionTimeout);
        e.log(Level.FINER, () -> janusConnection.logPrefix() + ", creating connection..");
        return ((CompletableFuture)this.a.newWebSocketBuilder().subprotocols("janus-protocol", new String[0]).buildAsync(URI.create(this.uri), janusConnection).thenApply(webSocket -> {
            janusConnection.setWebSocket((WebSocket)webSocket);
            return janusConnection;
        })).whenComplete((janusConnection2, throwable) -> {
            if (throwable != null) {
                e.log(Level.WARNING, (Throwable)throwable, () -> janusConnection.logPrefix() + ", connection creation failed.");
            } else {
                e.log(Level.FINER, () -> janusConnection.logPrefix() + ", connection created.");
            }
        });
    }
}

