/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JanusException;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusPluginsRegister;
import tigase.meet.janus.JanusSession;

public class JanusConnection
implements WebSocket.Listener {
    private static final Logger a = Logger.getLogger(JanusConnection.class.getCanonicalName());
    private static final JsonFactory b = new JsonFactory();
    private final String c = UUID.randomUUID().toString();
    private WebSocket d;
    private StringBuilder e = new StringBuilder();
    private ConcurrentHashMap<String, CompletableFuture<Void>> f = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CompletableFuture<Map<String, Object>>> g = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, JanusSession> h = new ConcurrentHashMap();
    private final ExecutorService i = Executors.newSingleThreadExecutor();
    private final JanusPluginsRegister j;
    private final ScheduledExecutorService k;
    private final Duration l;

    public JanusConnection(JanusPluginsRegister pluginsRegister, ScheduledExecutorService executorService, Duration sessionTimeout) {
        this.j = pluginsRegister;
        this.k = executorService;
        this.l = sessionTimeout;
    }

    public void close() {
        CompletableFuture.allOf((CompletableFuture[])this.h.values().stream().map(janusSession -> janusSession.destroy()).toArray(CompletableFuture[]::new)).handle((void_, throwable) -> this.a((WebSocket webSocket) -> webSocket.sendClose(1000, "ok")));
    }

    public String getId() {
        return this.c;
    }

    public String nextTransactionId() {
        return UUID.randomUUID().toString();
    }

    protected void setWebSocket(WebSocket webSocket) {
        this.d = webSocket;
    }

    public String logPrefix(String transaction) {
        return this.logPrefix() + ", transaction " + transaction;
    }

    public CompletableFuture<JanusSession> createSession() {
        String string = this.nextTransactionId();
        a.log(Level.FINER, () -> this.logPrefix(string) + ", creating session..");
        CompletableFuture<JanusSession> completableFuture = new CompletableFuture<JanusSession>();
        ((CompletableFuture)this.execute("create", string, jsonGenerator -> {}).thenApply(map -> new JanusSession(this, (Map)map.get("data")))).whenComplete((janusSession, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.logPrefix(string) + ", session creation failed.");
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.h.put(janusSession.getSessionId(), (JanusSession)janusSession);
                a.log(Level.FINER, () -> janusSession.logPrefix(string) + " session created.");
                janusSession.scheduleKeepAlive(this.k, this.l);
                completableFuture.complete((JanusSession)janusSession);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Void> destroySession(JanusSession session) {
        String string = this.nextTransactionId();
        a.log(Level.FINER, () -> session.logPrefix(string) + " destroying ..");
        return ((CompletableFuture)this.execute("destroy", string, jsonGenerator -> jsonGenerator.writeNumberField("session_id", session.getSessionId())).whenComplete((map, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> session.logPrefix(string) + " destruction failed!");
            } else {
                a.log(Level.FINER, () -> session.logPrefix(string) + " destroyed");
            }
        })).thenApply(map -> null);
    }

    public String getPluginId(Class<? extends JanusPlugin> plugin) {
        return this.j.getPluginId(plugin);
    }

    public CompletableFuture<Map<String, Object>> getInfo() {
        return this.execute("info", this.nextTransactionId(), jsonGenerator -> {});
    }

    public CompletableFuture<Map<String, Object>> execute(String janus, String transaction, RequestGenerator requestGenerator) {
        CompletionStage completionStage = new CompletableFuture().whenComplete((map, throwable) -> this.g.remove(transaction));
        try {
            this.g.put(transaction, (CompletableFuture<Map<String, Object>>)completionStage);
            this.a(janus, transaction, requestGenerator);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            this.g.remove(transaction);
            ((CompletableFuture)completionStage).completeExceptionally(exception);
        }
        return completionStage;
    }

    public CompletableFuture<Void> send(String janus, String transaction, RequestGenerator requestGenerator) {
        CompletionStage completionStage = new CompletableFuture().whenComplete((void_, throwable) -> this.f.remove(transaction));
        try {
            this.f.put(transaction, (CompletableFuture<Void>)completionStage);
            this.a(janus, transaction, requestGenerator);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            ((CompletableFuture)completionStage).completeExceptionally(exception);
        }
        return completionStage;
    }

    private void a(String string, String string2, RequestGenerator requestGenerator) throws IOException, ExecutionException, InterruptedException {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator jsonGenerator = b.createGenerator((Writer)stringWriter);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("janus", string);
        jsonGenerator.writeStringField("transaction", string2);
        requestGenerator.accept(jsonGenerator);
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        String string3 = stringWriter.toString();
        a.log(Level.FINEST, () -> this.logPrefix() + ", sending request: " + string3);
        this.a((WebSocket webSocket) -> webSocket.sendText(string3, true)).get();
    }

    public String logPrefix() {
        return "connection " + this.getId();
    }

    private <T> CompletableFuture<T> a(Function<WebSocket, CompletableFuture<T>> function) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.i.execute(() -> ((CompletableFuture)function.apply(this.d)).whenComplete((object, throwable) -> {
            if (throwable != null) {
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                completableFuture.complete(object);
            }
        }));
        return completableFuture;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        a.log(Level.FINEST, () -> this.logPrefix() + ", opened connection");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        a.log(Level.FINEST, () -> this.logPrefix() + ", closed connection");
        webSocket.request(1L);
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        a.log(Level.WARNING, error, () -> this.logPrefix() + ", exception on connection");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        a.log(Level.FINEST, () -> this.logPrefix() + ", received binary: " + data);
        webSocket.request(1L);
        return null;
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.e.append(data);
        webSocket.request(1L);
        if (last) {
            a.log(Level.FINEST, () -> this.logPrefix() + ", received message: " + this.e.toString());
            try {
                Map<String, Object> map = this.decode(this.e.toString());
                String string = (String)map.get("janus");
                String string2 = (String)map.get("transaction");
                if (string == null) {
                    throw new NullPointerException("Received JSON with 'janus' not set!");
                }
                switch (string) {
                    case "server_info": 
                    case "success": {
                        if (string2 == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        this.removeExecuteTransaction(string2).ifPresentOrElse(completableFuture -> completableFuture.complete(map), () -> a.log(Level.WARNING, () -> this.logPrefix(string2) + ", received success without matching transaction, payload: " + map));
                        break;
                    }
                    case "error": {
                        if (string2 == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        JanusException janusException = new JanusException((Map)map.get("error"));
                        a.log(Level.WARNING, janusException, () -> this.logPrefix(string2) + ", request failed!");
                        this.removeExecuteTransaction(string2).ifPresentOrElse(completableFuture -> completableFuture.completeExceptionally(janusException), () -> this.removeSendTransaction(string2).ifPresentOrElse(completableFuture -> completableFuture.completeExceptionally(janusException), () -> a.log(Level.WARNING, () -> this.logPrefix(string2) + ", received error without matching transaction, payload: " + map)));
                        break;
                    }
                    case "ack": {
                        if (string2 == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        this.removeSendTransaction(string2).ifPresent(completableFuture -> completableFuture.complete(null));
                        a.log(Level.FINEST, () -> this.logPrefix(string2) + ", request acknowledged.");
                        break;
                    }
                    case "detached": {
                        a.log(Level.FINEST, () -> this.logPrefix() + ", received detached event: " + map);
                        break;
                    }
                    case "event": {
                        Optional optional = string2 != null ? this.removeExecuteTransaction(string2) : Optional.empty();
                        a.log(Level.FINEST, () -> this.logPrefix() + ", received event: " + map + ", with handler: " + optional.isPresent());
                        if (optional.isPresent()) {
                            ((CompletableFuture)optional.get()).complete(map);
                            break;
                        }
                        Optional.ofNullable((Long)map.get("session_id")).map(this::getSession).ifPresentOrElse(janusSession -> janusSession.handleEvent(map), () -> a.log(Level.WARNING, () -> this.logPrefix() + ", event for not existing session: " + map));
                        break;
                    }
                    case "trickle": {
                        a.log(Level.FINEST, () -> this.logPrefix() + ", received trickle: " + map);
                        Optional.ofNullable((Long)map.get("session_id")).map(this::getSession).ifPresentOrElse(janusSession -> janusSession.handleTrickle(map), () -> a.log(Level.WARNING, () -> this.logPrefix() + ", trickle for not existing session: " + map));
                        break;
                    }
                    default: {
                        a.log(Level.FINEST, () -> this.logPrefix() + ", received something: " + map);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                a.log(Level.WARNING, throwable, () -> this.logPrefix() + ", JSON processing failed!\n" + this.e.toString());
            }
            this.e = new StringBuilder();
        }
        return null;
    }

    protected JanusSession getSession(long id) {
        return this.h.get(id);
    }

    protected Optional<CompletableFuture<Map<String, Object>>> removeExecuteTransaction(String transactionId) {
        return Optional.ofNullable(this.g.get(transactionId));
    }

    protected Optional<CompletableFuture<Void>> removeSendTransaction(String transactionId) {
        return Optional.ofNullable(this.f.get(transactionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> decode(String content) throws IOException {
        try (JsonParser jsonParser = b.createParser(content);){
            jsonParser.nextToken();
            Map<String, Object> map = this.decode(jsonParser);
            return map;
        }
    }

    protected Map<String, Object> decode(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Invalid parser state! state = " + parser.getCurrentToken());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            JsonToken jsonToken = parser.getCurrentToken();
            if (jsonToken == JsonToken.FIELD_NAME) {
                string = parser.getCurrentName();
                continue;
            }
            hashMap.put(string, this.decodeValue(parser));
        }
        return hashMap;
    }

    protected Object decodeValue(JsonParser parser) throws IOException {
        JsonToken jsonToken = parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            return parser.getText();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return parser.getNumberValue();
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(parser.getFloatValue());
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return parser.getEmbeddedObject();
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            return this.decode(parser);
        }
        if (jsonToken == JsonToken.START_ARRAY) {
            return this.decodeArray(parser);
        }
        throw new IllegalStateException("Unexpected token");
    }

    protected List decodeArray(JsonParser parser) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            arrayList.add(this.decodeValue(parser));
        }
        return arrayList;
    }

    @FunctionalInterface
    public static interface RequestGenerator {
        public void accept(JsonGenerator var1) throws IOException;
    }
}

