/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IPresenceRepository;
import tigase.meet.MeetComponent;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presenceCollectorRepository", parent=MeetComponent.class, active=true)
public class PresenceCollectorRepository
implements IPresenceRepository {
    private static final Logger a = Logger.getLogger(PresenceCollectorRepository.class.getCanonicalName());
    private ConcurrentHashMap<BareJID, a> b = new ConcurrentHashMap();
    @Inject
    private EventBus eventBus;

    public void addJid(BareJID meetJid, JID jid) throws ComponentException {
        a a2 = this.b.get(meetJid);
        if (a2 == null) {
            a.log(Level.FINEST, () -> "not marking " + jid + " as available for " + meetJid + " - meet doesn't exist!");
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "There is no meeting for this JID");
        }
        a2.a(jid);
    }

    public void removeJid(BareJID meetJid, JID jid) throws ComponentException {
        a a2 = this.b.get(meetJid);
        if (a2 == null) {
            a.log(Level.FINEST, () -> "not marking " + jid + " as unavailable for " + meetJid + " - meet doesn't exist!");
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "There is no meeting for this JID");
        }
        a2.b(jid);
        this.eventBus.fire((Object)new IPresenceRepository.UserDisappearedEvent(meetJid, jid));
    }

    @Override
    public boolean isAvailable(BareJID meetJid, JID jid) {
        a a2 = this.b.get(meetJid);
        if (a2 == null) {
            return false;
        }
        return a2.c(jid);
    }

    public void meetCreated(BareJID meetJid) {
        a.log(Level.FINEST, () -> "creating presence store for " + meetJid);
        this.b.put(meetJid, new a());
    }

    public void meetDestroyed(BareJID meetJid) {
        a.log(Level.FINEST, () -> "destroying presence store for " + meetJid);
        this.b.remove(meetJid);
    }

    private class a {
        private final CopyOnWriteArraySet<JID> b = new CopyOnWriteArraySet();

        private a() {
        }

        public void a(JID jID) {
            this.b.add(jID);
        }

        public void b(JID jID) {
            this.b.remove(jID);
        }

        public boolean c(JID jID) {
            return this.b.contains(jID);
        }
    }
}

