/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.meet.AbstractParticipationWithSession;
import tigase.meet.Meet;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.meet.janus.videoroom.Publisher;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.ContentAction;
import tigase.meet.jingle.SDP;
import tigase.meet.jingle.Transport;
import tigase.meet.utils.DelayedRunQueue;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

public class Participation
extends AbstractParticipationWithSession<Participation, Meet> {
    private static final Logger a = Logger.getLogger(Participation.class.getCanonicalName());
    private final Content.Creator b = Content.Creator.responder;
    private final Content.Creator c = Content.Creator.initiator;
    private SDPHolder d;
    private SDPHolder e;
    private SDPHolder f;
    private SDPHolder g;
    private Map<String, Content.Creator> h = new ConcurrentHashMap<String, Content.Creator>();
    private Map<String, Content.Creator> i = new ConcurrentHashMap<String, Content.Creator>();
    private Listener j;
    private final DelayedRunQueue k = new DelayedRunQueue();
    private final DelayedRunQueue l = new DelayedRunQueue();
    private final CopyOnWriteArrayList<Publisher> m = new CopyOnWriteArrayList();

    public Participation(Meet meet, JID jid, LocalPublisher localPublisher, LocalSubscriber localSubscriber) {
        super(meet, jid, localPublisher, localSubscriber);
    }

    @Override
    public void addedPublishers(Collection<Publisher> publishers) {
        this.m.addAll(publishers);
        this.j.publishersJoined(publishers);
        super.addedPublishers(publishers);
    }

    @Override
    public void removedPublishers(long publisherId) {
        this.m.stream().filter(publisher -> publisher.getId() == publisherId).findFirst().ifPresent(publisher -> {
            this.j.publishersLeft(Collections.singletonList(publisher));
            this.m.remove(publisher);
        });
        super.removedPublishers(publisherId);
    }

    @Override
    public synchronized void terminateSubscriberSession() {
        this.getSubscriberSessionId().ifPresent(string -> this.j.terminatedSubscriberSession((String)string));
        super.terminateSubscriberSession();
    }

    @Override
    public synchronized void terminatePublisherSession() {
        this.getPublisherSessionId().ifPresent(string -> this.j.terminatedPublisherSession((String)string));
        super.terminatePublisherSession();
    }

    public CompletableFuture<SDP> sendPublisherSDP(String sessionId, ContentAction action, SDP sdpOffer) {
        SDP sDP;
        if (this.getPublisherSessionId().filter(sessionId::equals).isEmpty()) {
            return CompletableFuture.failedFuture((Throwable)new ComponentException(Authorization.CONFLICT));
        }
        this.updatePublisherContentCreators(sdpOffer);
        SDP sDP2 = sDP = this.f == null ? null : this.f.sdp();
        if (sDP == null) {
            JSEP jSEP2 = new JSEP(JSEP.Type.offer, sdpOffer.toString("0", Content.Creator.responder, SDP.Direction.incoming));
            this.f = new SDPHolder(sdpOffer, jSEP2);
            return ((CompletableFuture)((CompletableFuture)this.sendPublisherSDP(jSEP2).thenApply(jSEP -> new SDPHolder(SDP.from(jSEP.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder), (JSEP)jSEP))).whenComplete((sDPHolder, throwable) -> {
                Participation participation = this;
                synchronized (participation) {
                    this.updatePublisherContentCreators(sDPHolder.sdp());
                    this.d = sDPHolder;
                    this.k.delayFinished();
                }
            })).thenApply(SDPHolder::sdp);
        }
        JSEP jSEP3 = new JSEP(JSEP.Type.offer, sDP.applyDiff(action, sdpOffer).toString("0", Content.Creator.responder, SDP.Direction.incoming));
        this.f = new SDPHolder(sdpOffer, jSEP3);
        return ((CompletableFuture)((CompletableFuture)this.sendPublisherSDP(jSEP3).thenApply(jSEP -> new SDPHolder(SDP.from(jSEP.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder), (JSEP)jSEP))).whenComplete((sDPHolder, throwable) -> {
            Participation participation = this;
            synchronized (participation) {
                this.updatePublisherContentCreators(sDPHolder.sdp());
                this.d = sDPHolder;
                this.k.delayFinished();
            }
        })).thenApply(SDPHolder::sdp);
    }

    @Override
    protected synchronized void receivedPublisherSDP(String sessionId, JSEP jsep) {
        SDP sDP = this.d == null ? null : this.d.sdp();
        SDP sDP2 = SDP.from(jsep.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder);
        this.updatePublisherContentCreators(sDP2);
        this.d = new SDPHolder(sDP2, jsep);
        if (sDP == null) {
            this.j.receivedPublisherSDP(sessionId, ContentAction.init, sDP2);
            this.k.delayFinished();
        } else {
            Map<ContentAction, SDP> map = sDP2.diffFrom(sDP);
            for (ContentAction contentAction : ContentAction.values()) {
                SDP sDP3 = map.get((Object)contentAction);
                if (sDP3 == null) continue;
                this.j.receivedPublisherSDP(sessionId, contentAction, sDP3);
            }
        }
    }

    @Override
    protected synchronized void receivedPublisherCandidate(String sessionId, JanusPlugin.Candidate candidate) {
        this.k.offer(() -> {
            Content content = this.convertCandidateToContent(Content.Creator.initiator, this.d.sdp(), candidate);
            if (content != null) {
                this.j.receivedPublisherCandidate(sessionId, content);
            } else {
                a.log(Level.WARNING, () -> "ERROR: it was not possible to convert publisher JanusPlugin.Candidate to Candidate, " + candidate);
            }
        });
    }

    public CompletableFuture<Void> sendSubscriberSDP(String sessionId, ContentAction action, SDP sdpAnswer) {
        SDP sDP;
        if (this.getSubscriberSessionId().filter(sessionId::equals).isEmpty()) {
            return CompletableFuture.failedFuture((Throwable)new ComponentException(Authorization.CONFLICT));
        }
        this.updateSubscriberContentCreators(sdpAnswer);
        SDP sDP2 = sDP = this.g == null ? null : this.g.sdp();
        if (sDP == null) {
            JSEP jSEP = new JSEP(JSEP.Type.answer, sdpAnswer.toString("0", Content.Creator.initiator, SDP.Direction.incoming));
            this.g = new SDPHolder(sdpAnswer, jSEP);
            return this.sendSubscriberSDP(jSEP);
        }
        JSEP jSEP = new JSEP(JSEP.Type.answer, sDP.applyDiff(action, sdpAnswer).toString("0", Content.Creator.initiator, SDP.Direction.incoming));
        this.g = new SDPHolder(sdpAnswer, jSEP);
        return this.sendSubscriberSDP(jSEP);
    }

    @Override
    protected void receivedSubscriberSDP(String sessionId, JSEP jsep) {
        SDP sDP = this.e == null ? null : this.e.sdp();
        SDP sDP2 = SDP.from(jsep.getSdp(), this::getSubscriberContentCreatorFor, Content.Creator.initiator);
        this.updateSubscriberContentCreators(sDP2);
        this.e = new SDPHolder(sDP2, jsep);
        if (sDP == null) {
            this.j.receivedSubscriberSDP(sessionId, ContentAction.init, sDP2);
            this.l.delayFinished();
        } else {
            Map<ContentAction, SDP> map = sDP2.diffFrom(sDP);
            for (ContentAction contentAction : ContentAction.values()) {
                SDP sDP3 = map.get((Object)contentAction);
                if (sDP3 == null) continue;
                this.j.receivedSubscriberSDP(sessionId, contentAction, sDP3);
                if (contentAction != ContentAction.modify) continue;
                this.sendSubscriberSDP(this.g.b);
            }
        }
    }

    @Override
    protected void receivedSubscriberCandidate(String sessionId, JanusPlugin.Candidate candidate) {
        this.l.offer(() -> {
            Content content = this.convertCandidateToContent(Content.Creator.initiator, this.e.sdp(), candidate);
            if (content != null) {
                this.j.receivedSubscriberCandidate(sessionId, content);
            } else {
                a.log(Level.WARNING, "ERROR: it was not possible to convert subscriber JanusPlugin.Candidate to Candidate, " + candidate);
            }
        });
    }

    public void sendCandidate(String sessionId, String contentName, Candidate candidate) {
        if (this.getPublisherSessionId().filter(sessionId::equals).isPresent()) {
            this.sendPublisherCandidate(contentName, candidate);
            return;
        }
        if (this.getSubscriberSessionId().filter(sessionId::equals).isPresent()) {
            this.sendSubscriberCandidate(contentName, candidate);
            return;
        }
    }

    public void sendPublisherCandidate(String contentName, Candidate candidate) {
        this.sendPublisherCandidate(new JanusPlugin.Candidate(contentName, this.findSdpMLineIndex(this.f.jsep(), contentName), candidate.toSDP()));
    }

    public void sendSubscriberCandidate(String contentName, Candidate candidate) {
        this.sendSubscriberCandidate(new JanusPlugin.Candidate(contentName, this.findSdpMLineIndex(this.g.jsep(), contentName), candidate.toSDP()));
    }

    public CompletableFuture<Void> updateSDP(String sessionId, ContentAction action, SDP sdp) {
        if (this.getPublisherSessionId().filter(sessionId::equals).isPresent()) {
            return this.sendPublisherSDP(sessionId, action, sdp).thenApply(sDP -> null);
        }
        if (this.getSubscriberSessionId().filter(sessionId::equals).isPresent()) {
            return this.sendSubscriberSDP(sessionId, action, sdp);
        }
        return CompletableFuture.failedFuture((Throwable)new ComponentException(Authorization.ITEM_NOT_FOUND));
    }

    protected int findSdpMLineIndex(JSEP jsep, String contentName) {
        String[] stringArray = jsep.getSdp().split("\r\n");
        List list = Arrays.stream(stringArray).filter(string -> string.startsWith("a=mid:")).collect(Collectors.toList());
        int n = list.indexOf("a=mid:" + contentName);
        if (n == -1) {
            a.log(Level.WARNING, "content '" + contentName + "' was not found in " + ((Meet)this.getMeet()).getJid() + " SDP sent to " + this.getJid());
            n = 0;
        }
        return n;
    }

    public void setListener(Listener listener) {
        this.j = listener;
        this.setListeners();
    }

    protected Content convertCandidateToContent(Content.Creator role, SDP sdp, JanusPlugin.Candidate janusCandidate) {
        if (sdp == null) {
            return null;
        }
        Candidate candidate = Candidate.from(janusCandidate.getCandidate());
        if (candidate == null) {
            return null;
        }
        String string = Optional.ofNullable(janusCandidate.getMid()).or(() -> sdp.getContents().stream().map(Content::getName).findFirst()).get();
        Optional optional = sdp.getContents().stream().filter(content -> string.equals(content.getName())).findFirst().flatMap(content -> content.getTransports().stream().findFirst());
        if (optional.isEmpty()) {
            return null;
        }
        return new Content(role, string, Optional.empty(), Optional.empty(), List.of(new Transport(((Transport)optional.get()).getUfrag(), ((Transport)optional.get()).getPwd(), List.of(candidate), Optional.empty())));
    }

    protected Content.Creator getPublisherContentCreatorFor(String name) {
        return Optional.ofNullable(this.h.get(name)).orElse(Content.Creator.responder);
    }

    protected void updatePublisherContentCreators(SDP sdp) {
        for (Content content : sdp.getContents()) {
            this.h.put(content.getName(), content.getCreator());
        }
    }

    protected Content.Creator getSubscriberContentCreatorFor(String name) {
        return Optional.ofNullable(this.i.get(name)).orElse(Content.Creator.initiator);
    }

    protected void updateSubscriberContentCreators(SDP sdp) {
        for (Content content : sdp.getContents()) {
            this.i.put(content.getName(), content.getCreator());
        }
    }

    public static interface Listener {
        public void publishersJoined(Collection<Publisher> var1);

        public void publishersLeft(Collection<Publisher> var1);

        public void receivedPublisherSDP(String var1, ContentAction var2, SDP var3);

        public void receivedPublisherCandidate(String var1, Content var2);

        public void terminatedPublisherSession(String var1);

        public void receivedSubscriberSDP(String var1, ContentAction var2, SDP var3);

        public void receivedSubscriberCandidate(String var1, Content var2);

        public void terminatedSubscriberSession(String var1);
    }

    public static final class SDPHolder
    extends Record {
        private final SDP a;
        private final JSEP b;

        public SDPHolder(SDP sdp, JSEP jsep) {
            this.a = sdp;
            this.b = jsep;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SDPHolder.class, "sdp;jsep", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SDPHolder.class, "sdp;jsep", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SDPHolder.class, "sdp;jsep", "a", "b"}, this, o);
        }

        public SDP sdp() {
            return this.a;
        }

        public JSEP jsep() {
            return this.b;
        }
    }
}

