/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.meet.IMeetRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.PresenceCollectorRepository;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusService;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.server.AbstractMessageReceiver;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="meetRepository", parent=MeetComponent.class, active=true)
public class MeetRepository
implements IMeetRepository {
    private static final Logger a = Logger.getLogger(MeetRepository.class.getCanonicalName());
    private final ConcurrentHashMap<BareJID, CompletableFuture<Meet>> b = new ConcurrentHashMap();
    @ConfigField(desc="Bean name")
    private String name;
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject
    private JanusService janusService;
    @Inject(nullAllowed=true)
    private PresenceCollectorRepository presenceCollectorRepository;
    private final a c = new a("active meetings", Level.FINEST, () -> this.size());

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CompletableFuture<Meet> create(BareJID key, int maxNoOfPublishers) {
        CompletableFuture<Meet> completableFuture = new CompletableFuture<Meet>();
        if (this.b.putIfAbsent(key, completableFuture) != null) {
            completableFuture.completeExceptionally(new ComponentException(Authorization.CONFLICT));
            return completableFuture;
        }
        this.a(key, maxNoOfPublishers).whenComplete((meet, throwable) -> {
            if (throwable != null) {
                this.b.remove(key, completableFuture);
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                if (this.presenceCollectorRepository != null) {
                    this.presenceCollectorRepository.meetCreated(meet.getJid());
                }
                completableFuture.complete((Meet)meet);
            }
        });
        return completableFuture;
    }

    @Override
    public Meet getMeet(BareJID jid) throws ComponentException {
        CompletableFuture<Meet> completableFuture = this.b.get(jid);
        if (completableFuture != null && completableFuture.isDone() && !completableFuture.isCompletedExceptionally()) {
            try {
                return completableFuture.get();
            }
            catch (Throwable throwable) {
                throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, throwable.getMessage(), throwable);
            }
        }
        throw new ComponentException(Authorization.ITEM_NOT_FOUND);
    }

    @Override
    public void destroyed(BareJID jid) {
        this.b.remove(jid);
        if (this.presenceCollectorRepository != null) {
            this.presenceCollectorRepository.meetDestroyed(jid);
        }
        a.log(Level.FINEST, () -> "meet " + jid + " was destroyed");
    }

    @Override
    public int size() {
        return this.b.size();
    }

    public void everyHour() {
        this.c.a();
    }

    public void everyMinute() {
        this.c.b();
    }

    public void everySecond() {
        this.c.c();
    }

    @Override
    public int getMaxParticipantsInMeeting() {
        return this.b.values().stream().filter(completableFuture -> completableFuture.isDone() && !completableFuture.isCancelled() && !completableFuture.isCompletedExceptionally()).mapToInt(completableFuture -> {
            try {
                return ((Meet)completableFuture.get()).getParticipantsCount();
            }
            catch (Throwable throwable) {
                return 0;
            }
        }).max().orElse(0);
    }

    public void getStatistics(String s, StatisticsList statisticsList) {
        this.c.a(this.component.getName() + "/" + this.getName(), statisticsList);
    }

    private CompletableFuture<Meet> a(BareJID bareJID, int n) {
        return this.janusService.newConnection().thenCompose(janusConnection -> ((CompletableFuture)((CompletableFuture)janusConnection.createSession().thenCompose(janusSession -> ((CompletableFuture)janusSession.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(janusVideoRoomPlugin -> janusVideoRoomPlugin.createRoom(null, n))).exceptionallyCompose(throwable -> janusSession.destroy().handle((void_, throwable2) -> CompletableFuture.failedFuture(throwable))))).thenApply(object -> {
            a.log(Level.FINEST, () -> "meet " + bareJID + " was created");
            return new Meet(this, (JanusConnection)janusConnection, object, bareJID);
        })).exceptionallyCompose(throwable -> {
            janusConnection.close();
            return CompletableFuture.failedFuture(throwable);
        }));
    }

    protected TimerTask scheduleJoinTimeoutTask(final Meet meet) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                if (!meet.hasParticipants()) {
                    meet.destroy();
                }
            }
        };
        this.component.addTimerTask(timerTask, 300000L);
        return timerTask;
    }

    private class a {
        private final Supplier<Long> d;
        protected final Level a;
        protected String b;
        private long e = 0L;
        private long f = 0L;
        private long g = 0L;
        private long h = 0L;

        public a(String string, Level level, Supplier<Long> supplier) {
            this.b = string;
            this.a = level;
            this.d = supplier;
        }

        public synchronized void a() {
            long l;
            this.e = l = this.d.get().longValue();
        }

        public synchronized void b() {
            long l;
            this.f = l = this.d.get().longValue();
        }

        public synchronized void c() {
            long l;
            this.g = l = this.d.get().longValue();
            this.h = Math.max(l, this.h);
        }

        public void a(String string, StatisticsList statisticsList) {
            if (statisticsList.checkLevel(this.a)) {
                statisticsList.add(string, this.b + " total", this.d.get().longValue(), this.a);
                statisticsList.add(string, this.b + " last hour", this.e, this.a);
                statisticsList.add(string, this.b + " last minute", this.f, this.a);
                statisticsList.add(string, this.b + " last second", this.g, this.a);
                statisticsList.add(string, this.b + " maximum", this.h, this.a);
            }
        }
    }
}

