/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import tigase.component.exceptions.ComponentException;
import tigase.meet.AbstractMeet;
import tigase.meet.MeetRepository;
import tigase.meet.Participation;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.util.common.TimerTask;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Meet
extends AbstractMeet<Participation> {
    public static final BareJID ALLOW_EVERYONE = BareJID.bareJIDInstanceNS((String)"*");
    private Set<BareJID> a = new CopyOnWriteArraySet<BareJID>();
    private final ConcurrentHashMap<JID, Participation> b = new ConcurrentHashMap();
    private final MeetRepository c;
    private final BareJID d;
    private TimerTask e;

    public Meet(MeetRepository repository, JanusConnection janusConnection, Object roomId, BareJID jid) {
        super(janusConnection, roomId);
        this.c = repository;
        this.d = jid;
        this.e = this.c.scheduleJoinTimeoutTask(this);
    }

    public BareJID getJid() {
        return this.d;
    }

    public void allow(BareJID jid) {
        this.a.add(jid);
    }

    public void deny(BareJID jid) {
        this.a.remove(jid);
        this.b.entrySet().stream().filter(entry -> jid.equals((Object)((JID)entry.getKey()).getBareJID())).map(entry -> (Participation)entry.getValue()).forEach(participation -> participation.leave(null));
    }

    public boolean isPublic() {
        return this.isAllowed(ALLOW_EVERYONE);
    }

    public boolean isAllowed(BareJID jid) {
        return this.a.contains(ALLOW_EVERYONE) || this.a.contains(jid);
    }

    public CompletableFuture<Participation> join(JID jid) {
        if (this.b.contains(jid)) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.CONFLICT));
        }
        return this.join(jid.getBareJID().toString(), (localPublisher, localSubscriber) -> new Participation(this, jid, (LocalPublisher)localPublisher, (LocalSubscriber)localSubscriber)).whenComplete((participation, throwable) -> {
            if (throwable == null) {
                this.b.put(participation.getJid(), (Participation)participation);
                this.a();
            }
        });
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return ((CompletableFuture)super.destroy().thenAccept(void_ -> this.c.destroyed(this.d))).thenAccept(void_ -> this.a());
    }

    public Participation getParticipation(JID jid) {
        return this.b.get(jid);
    }

    @Override
    public void left(Participation participation) {
        this.b.remove(participation.getJid());
        if (this.b.isEmpty()) {
            this.destroy();
        }
    }

    public boolean hasParticipants() {
        return !this.b.isEmpty();
    }

    public int getParticipantsCount() {
        return this.b.size();
    }

    private synchronized void a() {
        TimerTask timerTask = this.e;
        this.e = null;
        if (timerTask != null) {
            timerTask.cancel();
        }
    }
}

