/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.Processor;
import tigase.jaxmpp.core.client.ResponseManager;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.connector.ConnectorWrapper;
import tigase.jaxmpp.core.client.connector.StreamError;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.EventListener;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.AuthModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.SaslMechanism;
import tigase.jaxmpp.core.client.xmpp.modules.auth.SaslModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.scram.ScramMechanism;
import tigase.jaxmpp.core.client.xmpp.modules.auth.scram.ScramPlusMechanism;
import tigase.jaxmpp.core.client.xmpp.modules.auth.scram.ScramSHA256Mechanism;
import tigase.jaxmpp.core.client.xmpp.modules.auth.scram.ScramSHA256PlusMechanism;
import tigase.jaxmpp.core.client.xmpp.modules.streammng.StreamManagementModule;
import tigase.jaxmpp.core.client.xmpp.utils.DateTimeFormat;
import tigase.jaxmpp.j2se.ConnectionConfiguration;
import tigase.jaxmpp.j2se.DateTimeFormatProviderImpl;
import tigase.jaxmpp.j2se.J2SESessionObject;
import tigase.jaxmpp.j2se.ThreadSafeResponseManager;
import tigase.jaxmpp.j2se.connectors.bosh.BoshConnector;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;
import tigase.jaxmpp.j2se.connectors.websocket.WebSocketConnector;
import tigase.jaxmpp.j2se.eventbus.ThreadSafeEventBus;
import tigase.jaxmpp.j2se.xmpp.modules.auth.saslmechanisms.ExternalMechanism;

public class Jaxmpp
extends JaxmppCore {
    public static final String CONNECTOR_TYPE = "connectorType";
    public static final String EXCEPTION_KEY = "jaxmpp#ThrowedException";
    public static final String LOGIN_TIMEOUT_KEY = "LOGIN_TIMEOUT_KEY";
    private static final Executor DEFAULT_EXECUTOR = Executors.newSingleThreadExecutor();
    private Executor executor;
    private TimerTask loginTimeoutTask;
    private Timer timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDisconnectFinish(final Jaxmpp jaxmpp, long timeout) throws JaxmppException {
        EventListener eventListener = new EventListener(){

            public void onEvent(Event<? extends EventHandler> event) {
                if (event instanceof Connector.DisconnectedHandler.DisconnectedEvent) {
                    this.wakeUp();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void wakeUp() {
                Jaxmpp jaxmpp2 = jaxmpp;
                synchronized (jaxmpp2) {
                    ((Object)((Object)jaxmpp)).notify();
                }
            }
        };
        try {
            SessionObject sessionObject;
            jaxmpp.getEventBus().addListener(eventListener);
            if (jaxmpp.getConnector().getState() != Connector.State.disconnected) {
                Jaxmpp jaxmpp2 = jaxmpp;
                synchronized (jaxmpp2) {
                    ((Object)((Object)jaxmpp)).wait(timeout);
                }
                Thread.sleep(50L);
            }
            if ((sessionObject = jaxmpp.getSessionObject()).getProperty(EXCEPTION_KEY) != null) {
                JaxmppException r = (JaxmppException)((Object)sessionObject.getProperty(EXCEPTION_KEY));
                sessionObject.setProperty(EXCEPTION_KEY, null);
                JaxmppException e = new JaxmppException((Throwable)r);
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new JaxmppException((Throwable)e);
        }
        finally {
            jaxmpp.getEventBus().remove((EventHandler)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForLoginFinish(final Jaxmpp jaxmpp, long timeout) throws JaxmppException {
        EventListener eventListener = new EventListener(){

            public void onEvent(Event<? extends EventHandler> event) {
                if (event instanceof Connector.DisconnectedHandler.DisconnectedEvent) {
                    this.wakeUp();
                } else if (event instanceof ResourceBinderModule.ResourceBindSuccessHandler.ResourceBindSuccessEvent) {
                    this.wakeUp();
                } else if (event instanceof AuthModule.AuthFailedHandler.AuthFailedEvent) {
                    this.wakeUp();
                } else if (event instanceof StreamManagementModule.StreamResumedHandler.StreamResumedEvent) {
                    this.wakeUp();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void wakeUp() {
                Jaxmpp jaxmpp2 = jaxmpp;
                synchronized (jaxmpp2) {
                    ((Object)((Object)jaxmpp)).notify();
                }
            }
        };
        if (!jaxmpp.isConnected()) {
            try {
                jaxmpp.getEventBus().addListener(eventListener);
                SessionObject sessionObject = jaxmpp.getSessionObject();
                Jaxmpp jaxmpp2 = jaxmpp;
                synchronized (jaxmpp2) {
                    if (sessionObject.getProperty(EXCEPTION_KEY) == null && !jaxmpp.isConnected()) {
                        ((Object)((Object)jaxmpp)).wait(timeout);
                    }
                }
                Thread.sleep(50L);
                if (sessionObject.getProperty(EXCEPTION_KEY) != null) {
                    JaxmppException r = (JaxmppException)((Object)sessionObject.getProperty(EXCEPTION_KEY));
                    sessionObject.setProperty(EXCEPTION_KEY, null);
                    JaxmppException e = new JaxmppException((Throwable)r);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw new JaxmppException((Throwable)e);
            }
            finally {
                jaxmpp.getEventBus().remove((EventHandler)eventListener);
            }
        }
    }

    public Jaxmpp() {
        this.connector = new ConnectorWrapper();
        this.eventBus = new ThreadSafeEventBus();
        this.sessionObject = new J2SESessionObject();
        this.init();
    }

    public Jaxmpp(SessionObject sessionObject) {
        this.connector = new ConnectorWrapper();
        this.eventBus = new ThreadSafeEventBus();
        this.sessionObject = sessionObject;
        this.init();
    }

    public void disconnect() throws JaxmppException {
        this.disconnect(false);
    }

    public void disconnect(boolean snc) throws JaxmppException {
        this.disconnect(snc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disconnect(Boolean snc, boolean resetStreamManagement) throws JaxmppException {
        try {
            if (this.connector != null) {
                try {
                    this.connector.stop();
                }
                catch (XMLException e) {
                    throw new JaxmppException((Throwable)e);
                }
                if (snc != null && snc.booleanValue()) {
                    Jaxmpp.waitForDisconnectFinish(this, 0L);
                }
            }
            if (!resetStreamManagement) return;
        }
        catch (Throwable throwable) {
            if (!resetStreamManagement) throw throwable;
            StreamManagementModule.reset((SessionObject)this.sessionObject);
            this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.session});
            throw throwable;
        }
        StreamManagementModule.reset((SessionObject)this.sessionObject);
        this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.session});
    }

    public void execute(Runnable runnable) {
        if (runnable != null) {
            this.executor.execute(runnable);
        }
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return new ConnectionConfiguration(this.sessionObject);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
    }

    public void login(boolean sync) throws JaxmppException {
        this.login();
        if (sync) {
            Jaxmpp.waitForLoginFinish(this, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login() throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer("JaxmppJ2SETimer", true);
            this.timer.schedule((TimerTask)new CheckTimeoutsTask(), 30000L, 30000L);
        }
        this.modulesManager.initIfRequired();
        Connector.State state = this.connector.getState();
        if (state != Connector.State.disconnected) {
            this.log.info("Cannot login, because Connector.State is " + state);
            throw new JaxmppException("Connector is not in disconnected state");
        }
        this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.stream});
        if (this.sessionLogic != null) {
            this.sessionLogic.unbind();
            this.sessionLogic = null;
        }
        this.log.fine("state=" + state + " cr=" + (((ConnectorWrapper)this.connector).getConnector() != null));
        Connector connector = this.connector;
        synchronized (connector) {
            if (((ConnectorWrapper)this.connector).getConnector() != null) {
                this.log.log(Level.FINEST, "Found previous instance of Connector = {0}", ((ConnectorWrapper)this.connector).getConnector());
            }
            ((ConnectorWrapper)this.connector).setConnector(this.createConnector());
        }
        this.sessionLogic = this.connector.createSessionLogic(this.modulesManager, this.writer);
        this.sessionLogic.setSessionListener(new XmppSessionLogic.SessionListener(){

            public void onException(JaxmppException e) throws JaxmppException {
                Jaxmpp.this.onException(e);
            }
        });
        try {
            this.sessionLogic.beforeStart();
            this.connector.start();
            if (this.sessionObject.getProperty(EXCEPTION_KEY) != null) {
                JaxmppException r = (JaxmppException)((Object)this.sessionObject.getProperty(EXCEPTION_KEY));
                this.sessionObject.setProperty(EXCEPTION_KEY, null);
                JaxmppException e = new JaxmppException(r.getMessage(), r.getCause());
                throw e;
            }
        }
        catch (JaxmppException e) {
            throw e;
        }
        catch (Exception e1) {
            JaxmppException e = new JaxmppException((Throwable)e1);
            throw e;
        }
    }

    protected void checkTimeouts() throws JaxmppException {
        ResponseManager.getResponseManager((SessionObject)this.sessionObject).checkTimeouts();
    }

    protected Connector createConnector() throws JaxmppException {
        if (this.sessionObject.getProperty(CONNECTOR_TYPE) == null || "socket".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using SocketConnector");
            return new SocketConnector(this.context);
        }
        if ("bosh".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using BOSHConnector");
            return new BoshConnector(this.context);
        }
        if ("websocket".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using WebSocketConnector");
            return new WebSocketConnector(this.context);
        }
        throw new JaxmppException("Unknown connector type");
    }

    protected void init() {
        if (ResponseManager.getResponseManager((SessionObject)this.sessionObject) == null) {
            ResponseManager.setResponseManager((SessionObject)this.sessionObject, (ResponseManager)new ThreadSafeResponseManager());
        }
        super.init();
        this.setExecutor(DEFAULT_EXECUTOR);
        this.processor = new Processor(this.modulesManager, this.context);
        this.modulesInit();
        SaslModule saslModule = (SaslModule)this.getModule(SaslModule.class);
        if (saslModule != null) {
            saslModule.addMechanism((SaslMechanism)new ScramMechanism(), true);
            saslModule.addMechanism((SaslMechanism)new ScramPlusMechanism(), true);
            saslModule.addMechanism((SaslMechanism)new ScramSHA256Mechanism(), true);
            saslModule.addMechanism((SaslMechanism)new ScramSHA256PlusMechanism(), true);
        }
    }

    protected void modulesInit() {
        super.modulesInit();
        SaslModule saslModule = (SaslModule)this.modulesManager.getModule(SaslModule.class);
        saslModule.addMechanism((SaslMechanism)new ExternalMechanism(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectorStopped() {
        super.onConnectorStopped();
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(JaxmppException e) throws JaxmppException {
        this.log.log(Level.FINE, "Catching exception", e);
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            this.sessionObject.setProperty(EXCEPTION_KEY, (Object)e);
        }
        try {
            this.connector.stop();
        }
        catch (Exception e1) {
            this.log.log(Level.FINE, "Disconnecting error", e1);
        }
        jaxmpp = this;
        synchronized (jaxmpp) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            ((Object)((Object)this)).notify();
        }
    }

    protected void onResourceBindSuccess(JID bindedJID) throws JaxmppException {
        this.log.log(Level.INFO, "Connected. Resource binded.");
        this.eventBus.fire((Event)new JaxmppCore.LoggedInHandler.LoggedInEvent(this.sessionObject));
    }

    protected void onStreamError(StreamError condition, Throwable caught) throws JaxmppException {
    }

    protected void onStreamResumed(Long h, String previd) throws JaxmppException {
        this.log.log(Level.INFO, "Connected. Stream resumed.");
        this.eventBus.fire((Event)new JaxmppCore.LoggedInHandler.LoggedInEvent(this.sessionObject));
    }

    protected void onStreamTerminated() throws JaxmppException {
    }

    static {
        DateTimeFormat.setProvider((DateTimeFormat.DateTimeFormatProvider)new DateTimeFormatProviderImpl());
    }

    private class CheckTimeoutsTask
    extends TimerTask {
        private CheckTimeoutsTask() {
        }

        @Override
        public void run() {
            try {
                Jaxmpp.this.checkTimeouts();
            }
            catch (JaxmppException e) {
                Jaxmpp.this.log.warning("Problem on checking timeouts");
            }
        }
    }
}

