/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Optional;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.mix.IMixComponent;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.repository.IItems;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="roomVCardModule", parent=IMixComponent.class, active=true)
public class RoomVCardModule
extends AbstractPubSubModule {
    private static final String[] FEATURES = new String[]{"vcard-temp"};
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"vCard", (String)"vcard-temp"));

    public boolean canHandle(Packet packet) {
        if (packet.getStanzaTo().getResource() == null && packet.getStanzaTo().getLocalpart() != null) {
            return super.canHandle(packet);
        }
        return false;
    }

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            Optional<String> data;
            Element vcardTemp = new Element("vCard").withAttribute("xmlns", "vcard-temp");
            Optional<String> mimeType = this.getAvatarType(packet.getStanzaTo().getBareJID());
            if (mimeType.isPresent() && (data = this.getAvatarData(packet.getStanzaTo().getBareJID())).isPresent()) {
                vcardTemp.addChild((XMLNodeIfc)new Element("PHOTO").withElement("TYPE", null, mimeType.get()).withElement("BINVAL", null, data.get()));
            }
            this.packetWriter.write(packet.okResult(vcardTemp, 0));
        }
        catch (RepositoryException ex) {
            throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    protected Optional<String> getAvatarData(BareJID channelJID) throws RepositoryException, ComponentException {
        IItems items = this.getRepository().getNodeItems(channelJID, "urn:xmpp:avatar:data");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getLastItem(CollectionItemsOrdering.byUpdateDate)).map(IItems.IItem::getItem).map(item -> item.getChild("data", "urn:xmpp:avatar:data")).map(el -> el.getCData());
    }

    protected Optional<String> getAvatarType(BareJID channelJID) throws RepositoryException, ComponentException {
        IItems items = this.getRepository().getNodeItems(channelJID, "urn:xmpp:avatar:metadata");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getLastItem(CollectionItemsOrdering.byUpdateDate)).map(IItems.IItem::getItem).map(item -> item.getChild("metadata", "urn:xmpp:avatar:metadata")).map(el -> el.getChild("info")).map(el -> el.getAttributeStaticStr("type"));
    }
}

