/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.mix.IMixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.model.RoomGhostbuster;
import tigase.mix.model.RoomPresenceRepository;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.repository.IItems;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;

@Bean(name="roomPresenceModule", parent=IMixComponent.class, active=true)
public class RoomPresenceModule
extends AbstractPubSubModule
implements Initializable,
UnregisterAware {
    private static final Logger logger = Logger.getLogger(RoomPresenceModule.class.getCanonicalName());
    public static final String MUC_XMLNS = "http://jabber.org/protocol/muc";
    public static final String MUC_USER_XMLNS = "http://jabber.org/protocol/muc#user";
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private static final String[] FEATURES = new String[]{"http://jabber.org/protocol/muc"};
    private final TimestampHelper timestampHelper = new TimestampHelper(true);
    @Inject
    private EventBus eventBus;
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private RoomPresenceRepository roomPresenceRepository;
    @Inject(nullAllowed=true)
    private MucMessageBroadcastFilter messageBroadcastFilter;

    public boolean canHandle(Packet packet) {
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getResource() == null) {
            return false;
        }
        return super.canHandle(packet);
    }

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo() == null) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = packet.getStanzaTo().getBareJID();
        String nick = packet.getStanzaTo().getResource();
        StanzaType type = Optional.ofNullable(packet.getType()).orElse(StanzaType.available);
        try {
            switch (type) {
                case available: {
                    Element x = packet.getElemChild("x", MUC_XMLNS);
                    if (x == null) {
                        return;
                    }
                    if (!this.join(channelJID, packet.getStanzaFrom(), nick)) break;
                    Element historyEl = x.getChild("history");
                    PubSubQuery query = (PubSubQuery)this.getRepository().newQuery(channelJID);
                    query.setComponentJID(JID.jidInstanceNS((BareJID)channelJID));
                    query.setQuestionerJID(packet.getStanzaFrom());
                    query.getRsm().setHasBefore(true);
                    query.setPubsubNode("urn:xmpp:mix:nodes:messages");
                    if (historyEl != null) {
                        if (!"0".equals(historyEl.getAttributeStaticStr("maxchars"))) {
                            Optional.ofNullable(historyEl.getAttributeStaticStr("maxstanzas")).map(this::parseIntOrNull).ifPresent(value -> query.getRsm().setMax(value.intValue()));
                            Optional.ofNullable(historyEl.getAttributeStaticStr("since")).map(this::parseTimestampOrNull).ifPresent(arg_0 -> ((PubSubQuery)query).setStart(arg_0));
                            if (query.getStart() == null) {
                                Optional.ofNullable(historyEl.getAttributeStaticStr("seconds")).map(this::parseIntOrNull).map(s -> new Date(System.currentTimeMillis() - (long)(s * 1000))).ifPresent(arg_0 -> ((PubSubQuery)query).setStart(arg_0));
                            }
                        } else {
                            query.getRsm().setMax(0);
                        }
                    }
                    if (query.getRsm().getMax() > 0) {
                        this.getRepository().queryItems((Query)query, (q, item) -> {
                            String senderNick = Optional.ofNullable(item.getMessage().getChild("mix")).map(mix -> mix.getChild("nick")).map(Element::getCData).get();
                            item.getMessage().addChild((XMLNodeIfc)new Element("delay").withAttribute("xmlns", "urn:xmpp:delay").withAttribute("from", channelJID.toString()).withAttribute("stamp", this.timestampHelper.formatWithMs(item.getTimestamp())));
                            this.packetWriter.write(Packet.packetInstance((Element)item.getMessage(), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)senderNick), (JID)packet.getStanzaFrom()));
                        });
                    }
                    break;
                }
                case error: 
                case unavailable: {
                    this.leave(channelJID, packet.getStanzaFrom(), nick);
                    break;
                }
            }
        }
        catch (RepositoryException ex) {
            throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    private Date parseTimestampOrNull(String str) {
        try {
            return this.timestampHelper.parseTimestamp(str);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private Integer parseIntOrNull(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void broadcastMessage(BareJID channelJID, String senderNick, Element message) {
        Element mixEl = message.getChild("mix");
        if (mixEl != null) {
            message.removeChild(mixEl);
        }
        this.eventBus.fire((Object)new MucMessageBroadcastEvent(this.config.getComponentName(), channelJID, senderNick, message));
    }

    @HandleEvent
    public void handleBroadcastMessageEvent(MucMessageBroadcastEvent event) {
        if (!this.config.getComponentName().equals(event.componentName)) {
            return;
        }
        for (JID recipient : this.roomPresenceRepository.getRoomParticipantJids(event.getChannelJID())) {
            if (this.shouldBroadcast(recipient)) {
                logger.log(Level.FINEST, () -> "sending message from " + event.getChannelJID() + " + with id " + event.message.getAttributeStaticStr("id") + " to " + recipient);
                this.packetWriter.write(Packet.packetInstance((Element)event.getMessage().clone(), (JID)JID.jidInstanceNS((BareJID)event.getChannelJID(), (String)event.getSenderNick()), (JID)recipient));
                continue;
            }
            logger.log(Level.FINEST, () -> "not sending message from " + event.getChannelJID() + " + with id " + event.message.getAttributeStaticStr("id") + " to " + recipient);
        }
    }

    @HandleEvent
    public void handleKickoutEvent(RoomGhostbuster.KickoutEvent event) {
        if (!this.config.getComponentName().equals(event.getComponentName())) {
            return;
        }
        try {
            this.leave(event.getChannelJID(), event.getOccupantJID(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    private boolean shouldBroadcast(JID recipient) {
        return this.messageBroadcastFilter == null || this.messageBroadcastFilter.shouldBroadcastMucMessage(recipient);
    }

    public void participantJoined(BareJID channelJID, JID occupant, String nick) {
        Collection<JID> participants = this.roomPresenceRepository.getRoomParticipantJids(channelJID);
        if (!participants.isEmpty()) {
            Element presence = this.preparePresence(true, false);
            for (JID recipient : participants) {
                if (occupant != null && occupant.equals((Object)recipient)) continue;
                this.packetWriter.write(Packet.packetInstance((Element)new Element(presence), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)nick), (JID)recipient));
            }
        }
    }

    public void participantLeft(BareJID channelJID, JID occupant, String nick) {
        Collection<JID> participants = this.roomPresenceRepository.getRoomParticipantJids(channelJID);
        if (!participants.isEmpty()) {
            Element presence = this.preparePresence(false, false);
            for (JID recipient : participants) {
                if (occupant != null && occupant.equals((Object)recipient)) continue;
                this.packetWriter.write(Packet.packetInstance((Element)new Element(presence), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)nick), (JID)recipient));
            }
        }
    }

    private boolean join(BareJID channelJID, JID occupantJID, String nick) throws ComponentException, RepositoryException {
        String[] itemsIds;
        if (nick == null) {
            throw new ComponentException(Authorization.JID_MALFORMED);
        }
        ChannelConfiguration config = this.mixRepository.getChannelConfiguration(channelJID);
        if (config == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        this.mixLogic.checkPermission(channelJID, occupantJID.getBareJID(), MixAction.join);
        if (this.roomPresenceRepository.isNicknameInUse(channelJID, occupantJID, nick)) {
            throw new ComponentException(Authorization.CONFLICT);
        }
        String participantId = this.mixLogic.generateTempParticipantId(channelJID, occupantJID);
        IParticipant participant = this.mixRepository.getParticipant(channelJID, participantId);
        if (participant == null || !nick.equals(participant.getNick())) {
            this.mixRepository.updateTempParticipant(channelJID, occupantJID, nick);
        }
        this.roomPresenceRepository.addTempParticipant(channelJID, occupantJID, nick);
        IItems items = this.getRepository().getNodeItems(channelJID, "urn:xmpp:mix:nodes:participants");
        if (items != null && (itemsIds = items.getItemsIds(CollectionItemsOrdering.byUpdateDate)) != null) {
            for (String itemId : itemsIds) {
                if (itemId.equals(participantId)) continue;
                Optional.ofNullable(this.mixRepository.getParticipant(channelJID, itemId)).map(p -> Packet.packetInstance((Element)this.preparePresence(true, false), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)p.getNick()), (JID)occupantJID)).ifPresent(arg_0 -> ((PacketWriter)this.packetWriter).write(arg_0));
            }
        }
        this.participantJoined(channelJID, occupantJID, nick);
        this.packetWriter.write(Packet.packetInstance((Element)this.preparePresence(true, true), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)nick), (JID)occupantJID));
        return true;
    }

    private void leave(BareJID channelJID, JID occupantJID, String nick) throws ComponentException, RepositoryException {
        String participantId = this.mixLogic.generateTempParticipantId(channelJID, occupantJID);
        IParticipant participant = this.mixRepository.getParticipant(channelJID, participantId);
        if (participant != null) {
            this.mixRepository.removeTempParticipant(channelJID, occupantJID);
            this.roomPresenceRepository.removeTempParticipant(channelJID, occupantJID, nick);
            this.participantLeft(channelJID, occupantJID, participant.getNick());
            this.packetWriter.write(Packet.packetInstance((Element)this.preparePresence(false, true), (JID)JID.jidInstanceNS((BareJID)channelJID, (String)participant.getNick()), (JID)occupantJID));
        }
    }

    private Element preparePresence(boolean enter, boolean self) {
        Element presence = new Element("presence");
        if (!enter) {
            presence.withAttribute("type", "unavailable");
        }
        return presence.withElement("x", MUC_USER_XMLNS, el -> {
            el.withElement("item", item -> item.withAttribute("affiliation", "member").withAttribute("role", enter ? "participant" : "none"));
            if (self) {
                el.withElement("status", status -> status.withAttribute("code", "110"));
            }
        });
    }

    public static class MucMessageBroadcastEvent
    implements Serializable {
        private String componentName;
        private BareJID channelJID;
        private String senderNick;
        private Element message;

        public MucMessageBroadcastEvent() {
        }

        public MucMessageBroadcastEvent(String componentName, BareJID channelJID, String senderNick, Element message) {
            this.componentName = componentName;
            this.channelJID = channelJID;
            this.senderNick = senderNick;
            this.message = message;
        }

        public BareJID getChannelJID() {
            return this.channelJID;
        }

        public void setChannelJID(BareJID channelJID) {
            this.channelJID = channelJID;
        }

        public String getSenderNick() {
            return this.senderNick;
        }

        public void setSenderNick(String senderNick) {
            this.senderNick = senderNick;
        }

        public Element getMessage() {
            return this.message;
        }

        public void setMessage(Element message) {
            this.message = message;
        }
    }

    @FunctionalInterface
    public static interface MucMessageBroadcastFilter {
        public boolean shouldBroadcastMucMessage(JID var1);
    }
}

