/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.utils.PubSubLogic;
import tigase.pubsub.utils.executors.Executor;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="notificationBroadcaster", parent=PubSubComponent.class, active=true)
public class NotificationBroadcaster {
    @Inject
    private PacketWriter packetWriter;
    @Inject
    private PubSubLogic pubSubLogic;
    @Inject(bean="publishExecutor")
    private Executor publishExecutor;

    public void broadcastNotification(Executor.Priority priority, BareJID serviceJID, String nodeName, Element message) throws RepositoryException {
        JID senderJid = this.prepareSender(serviceJID, message.getAttributeStaticStr("from"));
        this.pubSubLogic.subscribersOfNotifications(serviceJID, nodeName).filter(this::shouldBroadcast).forEach(subscriberJid -> this.publishExecutor.submit(Executor.Priority.normal, () -> {
            Element clone = message.clone();
            this.packetWriter.write(Packet.packetInstance((Element)clone, (JID)senderJid, (JID)subscriberJid));
        }));
    }

    protected boolean shouldBroadcast(JID jid) {
        return true;
    }

    protected JID prepareSender(BareJID serviceJID, String fromAttr) {
        if (fromAttr != null) {
            return JID.jidInstanceNS((String)fromAttr);
        }
        return JID.jidInstance((BareJID)serviceJID);
    }
}

