/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.server.PolicyViolationException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class RosterFlat
extends RosterAbstract {
    private static final Logger log = Logger.getLogger(RosterFlat.class.getName());
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public RosterFlat() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static boolean addBuddy(RosterElement relem, Map<BareJID, RosterElement> roster) {
        if (roster.size() < maxRosterSize) {
            roster.put(relem.getJid().getBareJID(), relem);
            return true;
        }
        return false;
    }

    public static boolean parseRosterUtil(String roster_str, Map<BareJID, RosterElement> roster, XMPPResourceConnection session) {
        boolean result = false;
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, roster_str.toCharArray(), 0, roster_str.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                try {
                    RosterElement relem = new RosterElement(elem);
                    result |= relem.isModified();
                    if (RosterFlat.addBuddy(relem, roster)) continue;
                    break;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Can't load roster element: " + elem, e);
                }
            }
        }
        return result;
    }

    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public RosterElement addTempBuddy(JID buddy, XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElementInstance(buddy.copyWithoutResource(), null, null, session);
        relem.setPersistent(false);
        relem.setSubscription(null);
        RosterFlat.addBuddy(relem, this.getUserRoster(session));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added temporary buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem(), relem.toString()});
        }
        return relem;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void addBuddy(XMPPResourceConnection session, JID buddy, String name, String[] groups, RosterAbstract.SubscriptionType subscription, String otherData) throws NotAuthorizedException, TigaseDBException, PolicyViolationException {
        this.addBuddy(session, buddy, name, groups, subscription, null, otherData);
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void addBuddy(XMPPResourceConnection session, JID buddy, String name, String[] groups, RosterAbstract.SubscriptionType subscription, String mixParticipantId, String otherData) throws NotAuthorizedException, TigaseDBException, PolicyViolationException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            Map<BareJID, RosterElement> roster = this.getUserRoster(session);
            relem = this.getRosterElementInstance(buddy, name, groups, session);
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            relem.setOtherData(otherData);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "1. Added buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem()});
            }
            if (subscription != null) {
                relem.setSubscription(subscription);
            }
            relem.setMixParticipantId(mixParticipantId);
            if (!RosterFlat.addBuddy(relem, roster)) {
                throw new PolicyViolationException("Too many elements in the user roster. Limit: " + maxRosterSize);
            }
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "2. Added buddy to roster: {0}, name: {1}, item: {2}", new Object[]{relem.getJid(), relem.getName(), relem.getRosterItem()});
            }
        } else {
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            relem.setGroups(groups);
            relem.setMixParticipantId(mixParticipantId);
            relem.setPersistent(true);
            if (subscription != null) {
                relem.setSubscription(subscription);
            }
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Updated buddy in roster: {0}", buddy);
            }
        }
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public boolean addBuddyGroup(XMPPResourceConnection session, JID buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.addGroups(groups);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public boolean containsBuddy(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isPersistent();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public JID[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        if (roster.size() == 0) {
            return null;
        }
        JID[] result = new JID[roster.size()];
        int idx = 0;
        for (RosterElement rosterElement : roster.values()) {
            result[idx++] = rosterElement.getJid();
        }
        Arrays.sort(result, new RosterElemComparator(roster));
        return result;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public String[] getBuddyGroups(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getGroups();
    }

    private Element getBuddyItem(RosterElement relem) {
        return relem.getRosterItem();
    }

    private Element getBuddyItem(XMPPResourceConnection session, RosterElement relem) {
        String participantId;
        Element item = this.getBuddyItem(relem);
        if (Boolean.TRUE.equals(session.getSessionData("urn:xmpp:mix:roster:0")) && (participantId = relem.getMixParticipantId()) != null) {
            item.addChild((XMLNodeIfc)new Element("channel", new String[]{"xmlns", "participant-id"}, new String[]{"urn:xmpp:mix:roster:0", participantId}));
        }
        return item;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public Element getBuddyItem(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return this.getBuddyItem(session, relem);
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public String getBuddyName(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getName();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null || !relem.isPersistent()) {
            return null;
        }
        return relem.getSubscription();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public String getMixParticipantId(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getMixParticipantId();
    }

    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public RosterElement getRosterElementInstance(JID buddy, String name, String[] groups, XMPPResourceConnection session) {
        return new RosterElement(buddy.copyWithoutResource(), name, groups);
    }

    @Override
    public List<Element> getRosterItems(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> items = new LinkedList<Element>();
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        for (RosterElement relem : roster.values()) {
            if (!relem.isPersistent() || RosterAbstract.SubscriptionType.none_pending_in.equals((Object)relem.getSubscription())) continue;
            items.add(this.getBuddyItem(session, relem));
        }
        return items;
    }

    @Override
    public boolean isRosterLoaded(XMPPResourceConnection session) {
        return session.getCommonSessionData("roster") != null;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public boolean isOnline(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isOnline();
    }

    public boolean parseRoster(String roster_str, Map<BareJID, RosterElement> roster, XMPPResourceConnection session) {
        return RosterFlat.parseRosterUtil(roster_str, roster, session);
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public boolean presenceSent(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        return relem != null && relem.isPresence_sent();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public boolean removeBuddy(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing roster buddy: {0}, before removal: {1}", new Object[]{jid, roster});
        }
        roster.remove(jid.getBareJID());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing roster buddy: {0}, after removal: {1}", new Object[]{jid, roster});
        }
        this.saveUserRoster(session);
        return true;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void setBuddyName(XMPPResourceConnection session, JID buddy, String name) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting name: ''{0}'' for buddy: {1}", new Object[]{name, buddy});
            }
            if (emptyNameAllowed && (name == null || name.isEmpty())) {
                relem.setName(null);
            } else if (name == null || name.isEmpty()) {
                String n = buddy.getLocalpart();
                if (n == null || n.trim().isEmpty()) {
                    n = buddy.getBareJID().toString();
                }
                relem.setName(n);
            } else {
                relem.setName(name);
            }
            this.saveUserRoster(session);
        } else {
            log.log(Level.WARNING, "Setting buddy name for non-existen contact: {0}", buddy);
        }
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.setSubscription(subscription);
            this.saveUserRoster(session);
        } else {
            log.log(Level.WARNING, "Missing roster contact for subscription set: {0}", buddy);
        }
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void setOnline(XMPPResourceConnection session, JID buddy, boolean online) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            relem = this.addTempBuddy(buddy, session);
        }
        relem.setOnline(buddy.getResource(), online);
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public void setPresenceSent(XMPPResourceConnection session, JID buddy, boolean sent) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            relem = this.addTempBuddy(buddy, session);
        }
        relem.setPresence_sent(sent);
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public RosterElement getRosterElement(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        return roster.get(buddy.getBareJID());
    }

    public Map<BareJID, RosterElement> loadUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        boolean modified;
        ConcurrentHashMap<BareJID, RosterElement> roster = new ConcurrentHashMap<BareJID, RosterElement>(100, 0.25f, 1);
        session.putCommonSessionData("roster", roster);
        String roster_str = session.getData(null, "roster", null);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loaded user {1} roster: {0}", new Object[]{roster_str, session.getjid()});
        }
        if (roster_str != null && !roster_str.isEmpty() && (modified = this.parseRoster(roster_str, roster, session))) {
            this.saveUserRoster(session);
        }
        return roster;
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public Function<JID, RosterElement> rosterElementProvider(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        XMPPSession commonSession = session.getParentSession();
        if (commonSession == null || !session.isAuthorized()) {
            throw new NotAuthorizedException("No parent session set!");
        }
        this.getUserRoster(session);
        return jid -> {
            Map roster = (Map)commonSession.getCommonSessionData("roster");
            return roster == null ? null : (RosterElement)roster.get(jid.getBareJID());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="We should only allow BareJIDs")
    public Element getCustomChild(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement rel = this.getRosterElement(session, buddy);
        if (rel != null && rel.getLastSeen() > 1000L) {
            String stamp;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                stamp = this.formatter.format(new Date(rel.getLastSeen()));
            }
            return new Element("delay", new String[]{"stamp", "xmlns"}, new String[]{stamp, "urn:xmpp:delay"});
        }
        return null;
    }

    @Override
    public void logout(XMPPResourceConnection session) {
        try {
            if (session.isAuthorized() && this.isModified(session)) {
                this.saveUserRoster(session);
            }
        }
        catch (TigaseDBException | NotAuthorizedException ex) {
            if (ex.getCause() instanceof UserNotFoundException) {
                log.log(Level.FINEST, "Error logging out user, user already removed? " + session, ex);
            }
            log.log(Level.WARNING, "Error logging out user", ex);
        }
    }

    public boolean isModified(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        boolean result = false;
        if (roster != null) {
            for (RosterElement rel : roster.values()) {
                result |= rel.isModified();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<BareJID, RosterElement> getUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = null;
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            roster = (Map<BareJID, RosterElement>)session.getCommonSessionData("roster");
            if (roster == null) {
                roster = this.loadUserRoster(session);
            }
            if (this.getBuddiesHash(session) == null) {
                this.updateRosterHash(session);
            }
        }
        return roster;
    }

    @Override
    public void modifyStoredRoster(UserRepository repository, BareJID owner, Consumer<Map<BareJID, RosterElement>> modifyRoster) throws TigaseDBException {
        String rosterStr = repository.getData(owner, null, "roster", null);
        LinkedHashMap<BareJID, RosterElement> roster = new LinkedHashMap<BareJID, RosterElement>();
        if (rosterStr != null) {
            RosterFlat.parseRosterUtil(rosterStr, roster, null);
        }
        modifyRoster.accept(roster);
        StringBuilder sb = new StringBuilder();
        for (RosterElement relem : roster.values()) {
            sb.append(relem.getRosterElement().toString());
        }
        repository.setData(owner, null, "roster", sb.toString());
    }

    protected void saveUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        StringBuilder sb = new StringBuilder(5000);
        for (RosterElement relem : roster.values()) {
            if (!relem.isPersistent()) continue;
            sb.append(relem.getRosterElement().toString());
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} | Saving user roster: {1}", new String[]{session.getBareJID().toString(), sb.toString()});
        }
        session.setData(null, "roster", sb.toString());
    }

    @Override
    protected void updateRosterItem(XMPPResourceConnection session, RosterAbstract.RosterModifiedEvent event) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        if (event.getSubscription() == RosterAbstract.SubscriptionType.remove) {
            roster.remove(event.getJid().getBareJID());
            return;
        }
        RosterElement element = roster.get(event.getJid().getBareJID());
        if (element == null) {
            element = new RosterElement(event.getJid(), event.getName(), event.getGroups());
            element.setSubscription(event.getSubscription());
            element.setMixParticipantId(event.getMixParticipantId());
            RosterFlat.addBuddy(element, this.getUserRoster(session));
        } else {
            element.setName(event.getName());
            element.setGroups(event.getGroups());
            element.setSubscription(event.getSubscription());
            element.setMixParticipantId(event.getMixParticipantId());
        }
        super.updateRosterItem(session, event);
    }

    private class RosterElemComparator
    implements Comparator<JID> {
        private Map<BareJID, RosterElement> roster = null;

        private RosterElemComparator(Map<BareJID, RosterElement> roster) {
            this.roster = roster;
        }

        @Override
        public int compare(JID arg0, JID arg1) {
            double w0 = this.roster.get(arg0.getBareJID()).getWeight();
            double w1 = this.roster.get(arg1.getBareJID()).getWeight();
            return Double.compare(w0, w1);
        }
    }
}

