/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.AuthenticationProcessor;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.stats.StatisticsList;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="sasl-external", parent=S2SConnectionManager.class, active=true)
public class SaslExternal
extends AuthenticationProcessor {
    protected static final String[] FEATURES_SASL_PATH = new String[]{"features", "mechanisms"};
    private static final String METHOD_NAME = "SASL-EXTERNAL";
    private static final String SASL_SUCCESS_ELEMENT_NAME = "success";
    private static final String SASL_FAILURE_ELEMENT_NAME = "failure";
    private static final String XMLNS_SASL = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Logger log = Logger.getLogger(SaslExternal.class.getName());
    private static Element successElement = new Element("success", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"});
    @ConfigField(desc="Enable compatibility with legacy servers", alias="legacy-compat")
    private boolean legacyCompat = true;
    @ConfigField(desc="Skip SASL-EXTERNAL for defined domains", alias="skip-for-domains")
    private String[] skipForDomains;

    private static boolean isAnyMechanismsPresent(Packet p) {
        List childrenStaticStr = p.getElement().getChildrenStaticStr(FEATURES_SASL_PATH);
        return p.isXMLNSStaticStr(FEATURES_SASL_PATH, XMLNS_SASL) && childrenStaticStr != null && !childrenStaticStr.isEmpty();
    }

    private static boolean isTlsEstablished(CertCheckResult certCheckResult) {
        return certCheckResult == CertCheckResult.trusted || certCheckResult == CertCheckResult.untrusted || certCheckResult == CertCheckResult.self_signed;
    }

    @Override
    public String getMethodName() {
        return METHOD_NAME;
    }

    public void setSkipForDomains(String[] skipForDomains) {
        this.skipForDomains = skipForDomains != null ? (String[])Arrays.stream(skipForDomains).map(String::toLowerCase).toArray(String[]::new) : null;
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
        Element mechanisms = new Element("mechanisms", new Element[]{new Element("mechanism", "EXTERNAL")}, new String[]{"xmlns"}, new String[]{XMLNS_SASL});
        boolean canAddSaslToFeatures = this.canAddSaslToFeatures(serv);
        if (canAddSaslToFeatures) {
            results.add(mechanisms);
            authenticatorSelectorManager.getAuthenticationProcessors(serv).add(this);
        }
    }

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.SaslExternal.ordinal();
    }

    @Override
    public void restartAuth(Packet p, S2SIOService serv, Queue<Packet> results) {
        try {
            this.sendAuthRequest(serv, results);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> String.format("%s, Error while restarting authentication", serv));
            results.add(this.failurePacket(null));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
        }
    }

    @Override
    public boolean canHandle(Packet p, S2SIOService serv, Queue<Packet> results) {
        boolean skipTLS;
        CID cid = (CID)serv.getSessionData().get("cid");
        boolean bl = skipTLS = cid != null && this.skipTLSForHost(cid.getRemoteHost());
        if (cid != null && (this.isSkippedDomain(cid.getLocalHost()) || this.isSkippedDomain(cid.getRemoteHost()))) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Skipping SASL-EXTERNAL for domain: {1} because it was ignored [{0}]", new Object[]{serv, cid});
            }
            return false;
        }
        if (p.isElement("features", "http://etherx.jabber.org/streams") && p.getElement().getChildren() != null && !p.getElement().getChildren().isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Stream features received packet: {1} [{0}]", new Object[]{serv, p});
            }
            if (!SaslExternal.isAnyMechanismsPresent(p)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No SASL mechanisms found in features. Skipping SASL. [{0}]", new Object[]{serv, p});
                }
                return false;
            }
            CertCheckResult certCheckResult = (CertCheckResult)serv.getSessionData().get("cert-check-result");
            if (p.isXMLNSStaticStr(FEATURES_STARTTLS_PATH, "urn:ietf:params:xml:ns:xmpp-tls") && certCheckResult == null && !skipTLS) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Waiting for starttls, packet: {1} [{0}]", new Object[]{serv, p});
                }
                return false;
            }
            if (certCheckResult == CertCheckResult.invalid || serv.isHandshakingOnly()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Connection is handshaking only: {1}, certCheckResult: {2}, packet: {3} [{0}]", new Object[]{serv, serv.isHandshakingOnly(), certCheckResult, p});
                }
                return false;
            }
            if (!this.canAddSaslToFeatures(serv)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Skipping SASL-EXTERNAL: local certificate for {1} is not trusted (self-signed or expired)  [{0}]", new Object[]{serv, cid.getLocalHost()});
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        super.getStatistics(compName, list);
        authenticatorSelectorManager.getStatistics(compName, list);
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        try {
            if (authenticatorSelectorManager.isAllowed(p, serv, this, results)) {
                this.sendAuthRequest(serv, results);
                return true;
            }
            if (p.isElement("auth", XMLNS_SASL)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received auth request: {1} [{0}]", new Object[]{serv, p});
                }
                this.processAuth(p, serv, results);
                return true;
            }
            if (p.isElement(SASL_SUCCESS_ELEMENT_NAME, XMLNS_SASL)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received success response: {1} [{0}]", new Object[]{serv, p});
                }
                this.processSuccess(p, serv, results);
                return true;
            }
            if (p.isElement(SASL_FAILURE_ELEMENT_NAME, XMLNS_SASL)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received failure response: {1} [{0}]", new Object[]{serv, p});
                }
                authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
                return true;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> String.format("%s, Error while processing packet: %s", serv, p));
            results.add(this.failurePacket(null));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
            return true;
        }
        return false;
    }

    private boolean isSkippedDomain(String domain) {
        return domain != null && this.skipForDomains != null && Arrays.binarySearch(this.skipForDomains, domain.toLowerCase()) >= 0;
    }

    private boolean canAddSaslToFeatures(S2SIOService serv) {
        boolean canAddSaslToFeatures;
        ConcurrentMap<String, Object> sessionData = serv.getSessionData();
        CID cid = (CID)sessionData.get("cid");
        boolean skipDomain = cid != null && (this.isSkippedDomain(cid.getLocalHost()) || this.isSkippedDomain(cid.getRemoteHost()));
        CertCheckResult certCheckResult = (CertCheckResult)sessionData.get("cert-check-result");
        boolean tlsEstablished = SaslExternal.isTlsEstablished(certCheckResult);
        CertCheckResult localCertCheckResult = (CertCheckResult)sessionData.get("local-cert-check-result");
        boolean localCertTrusted = localCertCheckResult == CertCheckResult.trusted;
        boolean bl = canAddSaslToFeatures = tlsEstablished && localCertTrusted && !serv.isAuthenticated() && !serv.isHandshakingOnly() && !skipDomain;
        if (!canAddSaslToFeatures && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Not adding SASL-EXTERNAL feature, tlsEstablished: {1} (result: {2}), skipDomain: {3}, localCertTrusted: {4} (result: {5}) [{0}]", new Object[]{serv, tlsEstablished, certCheckResult, skipDomain, localCertTrusted, localCertCheckResult});
        }
        return canAddSaslToFeatures;
    }

    private void sendAuthRequest(S2SIOService serv, Queue<Packet> results) throws TigaseStringprepException {
        String cdata = "=";
        CID cid = (CID)serv.getSessionData().get("cid");
        if (cid != null && this.legacyCompat) {
            cdata = Base64.encode((byte[])cid.getLocalHost().getBytes(StandardCharsets.UTF_8));
        }
        Element auth = new Element("auth", cdata, new String[]{"xmlns", "mechanism"}, new String[]{XMLNS_SASL, "EXTERNAL"});
        results.add(Packet.packetInstance(auth));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Starting SASL EXTERNAL: {1} [{0}]", new Object[]{serv, auth});
        }
    }

    private void processSuccess(Packet p, S2SIOService serv, Queue<Packet> results) throws TigaseStringprepException, LocalhostException, NotLocalhostException {
        CID cid = (CID)serv.getSessionData().get("cid");
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending new stream [{0}]", new Object[]{serv});
        }
        String data = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' from='" + cid.getLocalHost() + "' to='" + cid.getRemoteHost() + "' version='1.0'>";
        serv.xmppStreamOpen(data);
        CIDConnections cid_conns = this.handler.getCIDConnections(cid, true);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Making connection authenticated. cid={1}  [{0}]", new Object[]{serv, cid});
        }
        authenticatorSelectorManager.authenticateConnection(serv, cid_conns, cid);
    }

    private void processAuth(Packet p, S2SIOService serv, Queue<Packet> results) throws TigaseStringprepException, LocalhostException, NotLocalhostException {
        boolean nameValid;
        X509Certificate peerCertificate = (X509Certificate)serv.getPeerCertificate();
        if (peerCertificate == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No peer certificate! [{0}]", new Object[]{serv});
            }
            results.add(this.failurePacket("No peer certificate"));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
            return;
        }
        CertCheckResult certCheckResult = (CertCheckResult)serv.getSessionData().get("cert-check-result");
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Trust: {1} for peer certificate: {2}, AltNames: {3} [{0}]", new Object[]{serv, certCheckResult, peerCertificate.getSubjectDN(), CertificateUtil.getCertAltCName((X509Certificate)peerCertificate)});
        }
        if (certCheckResult != CertCheckResult.trusted && certCheckResult != CertCheckResult.self_signed) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Certificate is not trusted [{0}]", new Object[]{serv});
            }
            results.add(this.failurePacket("Certificate is not trusted"));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
            return;
        }
        CID cid = (CID)serv.getSessionData().get("cid");
        if (cid == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CID is unknown, can''t proceed [{0}]", new Object[]{serv});
            }
            results.add(this.failurePacket("Unknown origin hostname (lack of `from` element)"));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
            return;
        }
        try {
            nameValid = CertificateUtil.verifyCertificateForDomain((X509Certificate)peerCertificate, (String)cid.getRemoteHost());
        }
        catch (CertificateParsingException e) {
            nameValid = false;
        }
        if (!nameValid) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Certificate name doesn't match to '{1}' [{0}]", new Object[]{serv, cid.getRemoteHost()});
            }
            results.add(this.failurePacket("Certificate name doesn't match to domain name"));
            authenticatorSelectorManager.authenticationFailed(p, serv, this, results);
            return;
        }
        CIDConnections cid_conns = this.handler.getCIDConnections(cid, true);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Making connection authenticated. cid={1} [{0}]", new Object[]{serv, cid});
        }
        authenticatorSelectorManager.authenticateConnection(serv, cid_conns, cid);
        results.add(Packet.packetInstance(successElement));
    }

    private Packet failurePacket(String description) {
        Element result = new Element(SASL_FAILURE_ELEMENT_NAME, new Element[]{new Element("invalid-authzid")}, new String[]{"xmlns"}, new String[]{XMLNS_SASL});
        if (description != null) {
            result.addChild((XMLNodeIfc)new Element("text", description));
        }
        return Packet.packetInstance(result, null, null);
    }

    @Override
    public boolean shouldSkipUndelivered(Packet packet) {
        return packet.getElemName() == SASL_SUCCESS_ELEMENT_NAME || packet.getXMLNS() == XMLNS_SASL;
    }
}

