/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.UserRepository;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigAlias;
import tigase.kernel.beans.config.ConfigAliases;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.amp.ActionIfc;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@ConfigAliases(value={@ConfigAlias(field="security", alias="amp-security-level")})
public abstract class ActionAbstract
implements ActionIfc {
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String AMP_SECURITY_LEVEL = "--amp-security-level";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String AMP_SECURITY_LEVEL_DEFAULT = "STRICT";
    public static final String SECURITY_PROP_KEY = "security-level";
    private static Logger log = Logger.getLogger(ActionAbstract.class.getName());
    protected ActionResultsHandlerIfc resultsHandler = null;
    RosterFlat rosterUtil = new RosterFlat();
    @ConfigField(alias="security", desc="Security level")
    private SECURITY security = SECURITY.STRICT;
    @Inject
    private UserRepository user_repository = null;

    @Override
    public void setActionResultsHandler(ActionResultsHandlerIfc resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    protected Packet prepareAmpPacket(Packet packet, Element rule) throws PacketErrorTypeException {
        boolean error_result = false;
        switch (this.security) {
            case NONE: {
                break;
            }
            case PERFORMANCE: {
                error_result = true;
                break;
            }
            case STRICT: {
                error_result = !this.checkUserRoster(packet.getStanzaTo(), packet.getStanzaFrom());
            }
        }
        Packet result = null;
        if (error_result) {
            result = Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Subscription between users not valid", false);
        } else {
            JID old_from = packet.getStanzaFrom();
            JID old_to = packet.getStanzaTo();
            String from_conn_id = packet.getAttributeStaticStr("from-conn-id");
            JID new_from = null;
            new_from = from_conn_id != null ? JID.jidInstanceNS((String)old_from.getDomain()) : JID.jidInstanceNS((String)old_to.getDomain());
            result = packet.copyElementOnly();
            result.setStableId(packet.getStableId());
            result.initVars(new_from, old_from);
            Element amp = result.getElement().getChild("amp", "http://jabber.org/protocol/amp");
            result.getElement().removeChild(amp);
            amp = new Element("amp", new Element[]{rule}, new String[]{"from", "to", "xmlns", "status"}, new String[]{old_from.toString(), old_to.toString(), "http://jabber.org/protocol/amp", this.getName()});
            result.getElement().addChild((XMLNodeIfc)amp);
            this.removeTigasePayload(result);
            if (from_conn_id != null) {
                result.setPacketTo(JID.jidInstanceNS((String)from_conn_id));
            }
        }
        return result;
    }

    protected void removeTigasePayload(Packet packet) {
        packet.getElement().removeAttribute("to-conn-id");
        packet.getElement().removeAttribute("to-res");
        packet.getElement().removeAttribute("offline");
        packet.getElement().removeAttribute("from-conn-id");
        packet.getElement().removeAttribute("from-session-jid");
        packet.getElement().removeAttribute("expired");
    }

    private boolean checkUserRoster(JID user, JID contact) {
        if (user.getBareJID().equals((Object)contact.getBareJID())) {
            return true;
        }
        try {
            String roster_str = this.user_repository.getData(user.getBareJID(), "roster");
            if (roster_str != null) {
                LinkedHashMap<BareJID, RosterElement> roster = new LinkedHashMap<BareJID, RosterElement>();
                RosterFlat.parseRosterUtil(roster_str, roster, null);
                RosterElement re = (RosterElement)roster.get(contact.getBareJID());
                if (re != null) {
                    return this.rosterUtil.isSubscribedFrom(re.getSubscription());
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "Problem retrieving user roster: " + user, ex);
        }
        return false;
    }

    private static enum SECURITY {
        NONE,
        PERFORMANCE,
        STRICT;

    }
}

