/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.kernel.BeanUtils;
import tigase.kernel.KernelException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.BeanFactory;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.config.BeanConfigurator;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.BeanConfigBuilder;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.RegistrarKernel;
import tigase.sys.TigaseRuntime;
import tigase.util.ExceptionUtilities;
import tigase.util.reflection.ReflectionHelper;

public class Kernel {
    protected static final Logger log = Logger.getLogger(Kernel.class.getName());
    private static final ThreadLocal<DelayedDependencyInjectionQueue> DELAYED_DEPENDENCY_INJECTION = new ThreadLocal();
    private final Map<String, Object> beanInstances = new HashMap<String, Object>();
    private final DependencyManager dependencyManager = new DependencyManager();
    BeanConfigBuilder currentlyUsedConfigBuilder;
    private boolean forceAllowNull;
    private String name;
    private Kernel parent;
    private Map<String, Link> registeredLinks = new HashMap<String, Link>();
    private boolean shutdown = false;

    protected void initBean(BeanConfig tmpBC, Set<BeanConfig> createdBeansConfig, int deep) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        BeanConfig beanConfig;
        BeanConfig beanConfig2 = beanConfig = tmpBC instanceof DelegatedBeanConfig ? ((DelegatedBeanConfig)tmpBC).original : tmpBC;
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "[{0}] Initialising bean, config: {1}, createdBeansConfigs={2}, deep={3}", new Object[]{tmpBC.getBeanName(), tmpBC, createdBeansConfig.size(), deep});
        }
        if (beanConfig.getState() == BeanConfig.State.initialized) {
            return;
        }
        DelayedDependencyInjectionQueue queue = beanConfig.getKernel().beginDependencyDelayedInjection();
        try {
            BeanConfigurator beanConfigurator;
            Object bean;
            if (beanConfig.getState() == BeanConfig.State.registered) {
                beanConfig.setState(BeanConfig.State.instanceCreated);
                if (beanConfig.getFactory() != null && beanConfig.getFactory().getState() != BeanConfig.State.initialized) {
                    this.initBean(beanConfig.getFactory(), new HashSet<BeanConfig>(), 0);
                }
                if (RegistrarBean.class.isAssignableFrom(beanConfig.getClazz())) {
                    RegistrarKernel k = new RegistrarKernel();
                    k.setName(beanConfig.getBeanName());
                    beanConfig.getKernel().registerBean(beanConfig.getBeanName() + "#KERNEL").asInstance(k).exec();
                    beanConfig.setKernel(k);
                    beanConfig.setBeanInstanceName("service");
                }
                bean = beanConfig.getKernel().createNewInstance(beanConfig);
                beanConfig.getKernel().putBeanInstance(beanConfig.getBeanInstanceName(), bean);
                createdBeansConfig.add(beanConfig);
                if (RegistrarBean.class.isAssignableFrom(beanConfig.getClazz())) {
                    Kernel parent = beanConfig.getKernel().getParent();
                    parent.ln(beanConfig.getBeanName(), beanConfig.getKernel(), "service");
                }
            } else {
                bean = beanConfig.getKernel().getInstance(beanConfig);
            }
            if (bean instanceof RegistrarBean) {
                ((RegistrarBean)bean).register(beanConfig.getKernel());
            }
            try {
                beanConfigurator = beanConfig.getKernel().isBeanClassRegistered("defaultBeanConfigurator") && !beanConfig.getBeanName().equals("defaultBeanConfigurator") ? (BeanConfigurator)beanConfig.getKernel().getInstance("defaultBeanConfigurator") : null;
            }
            catch (KernelException e) {
                beanConfigurator = null;
            }
            if (beanConfigurator != null) {
                beanConfigurator.configure(beanConfig, bean);
            } else {
                AbstractBeanConfigurator.registerBeansForBeanOfClass(beanConfig.getKernel(), bean.getClass());
            }
            beanConfig.getKernel().finishDependecyDelayedInjection(queue);
            for (Dependency dep : beanConfig.getFieldDependencies().values()) {
                beanConfig.getKernel().injectDependencies(bean, dep, createdBeansConfig, deep, false);
            }
            if (bean instanceof Initializable && beanConfig.getState() != BeanConfig.State.initialized) {
                ((Initializable)bean).initialize();
            }
        }
        catch (Throwable ex) {
            if (beanConfig.getState() == BeanConfig.State.instanceCreated) {
                Object i = beanConfig.getKernel().beanInstances.remove(beanConfig.getBeanInstanceName());
                if (i != null) {
                    this.fireUnregisterAware(i);
                    if (i instanceof RegistrarBean) {
                        beanConfig.getKernel().shutdown = true;
                        ((RegistrarBean)i).unregister(beanConfig.getKernel());
                        Kernel parent = beanConfig.getKernel().getParent();
                        parent.unregister(beanConfig.getBeanName() + "#KERNEL");
                        beanConfig.setKernel(parent);
                        beanConfig.setBeanInstanceName(null);
                    }
                }
                beanConfig.setState(BeanConfig.State.registered);
            }
            throw ex;
        }
        tmpBC.setState(BeanConfig.State.initialized);
    }

    public Kernel() {
        this("<unknown>");
    }

    public Kernel(String name) {
        this.name = name;
        BeanConfig bc = this.dependencyManager.createBeanConfig(this, "kernel", Kernel.class);
        bc.setPinned(true);
        this.dependencyManager.register(bc);
        this.putBeanInstance(bc, (Object)this);
        bc.setState(BeanConfig.State.initialized);
    }

    public void gc() {
        int count;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start GC for unused beans.");
        }
        this.dependencyManager.getBeanConfigs().stream().filter(beanConfig -> beanConfig.getState() == BeanConfig.State.instanceCreated).forEach(beanConfig -> {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Removing instance of unused bean " + beanConfig.getBeanName());
            }
            beanConfig.getKernel().beanInstances.remove(beanConfig.getBeanInstanceName());
            beanConfig.setState(BeanConfig.State.registered);
        });
        do {
            Collection<BeanConfig> injectedBeans = this.gc_getInjectedBeans();
            Collection<BeanConfig> bcs = this.dependencyManager.getBeanConfigs();
            count = 0;
            for (BeanConfig bc : bcs) {
                if (bc.getState() != BeanConfig.State.initialized || bc.isPinned() || injectedBeans.contains(bc)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Removing instance of unused bean " + bc.getBeanName());
                }
                bc.setState(BeanConfig.State.registered);
                Object i = bc.getKernel().beanInstances.remove(bc.getBeanInstanceName());
                this.fireUnregisterAware(i);
                if (i instanceof RegistrarBean) {
                    ((RegistrarBean)i).unregister(bc.getKernel());
                }
                ++count;
            }
        } while (count > 0);
        this.dependencyManager.getBeanConfigs().stream().filter(beanConfig -> Kernel.class.isAssignableFrom(beanConfig.getClazz()) && beanConfig.getState() == BeanConfig.State.initialized).forEach(new Consumer<BeanConfig>(){

            @Override
            public void accept(BeanConfig beanConfig) {
                Kernel k = (Kernel)Kernel.this.getInstance(beanConfig);
                if (k != Kernel.this) {
                    k.gc();
                }
            }
        });
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public <T> T getInstance(Class<T> beanClass) throws KernelException {
        return this.getInstance(beanClass, true);
    }

    public <T> T getInstance(String beanName) {
        BeanConfig bc = this.dependencyManager.getBeanConfig(beanName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[{0}] Creating instance of bean ''{1}'': config={2}, parent={3}, state={4}", new Object[]{this.getName(), beanName, bc, this.parent, bc != null ? bc.getState() : "n/a"});
        }
        if (bc == null && this.parent != null && this.parent.isBeanClassRegistered(beanName)) {
            return this.parent.getInstance(beanName);
        }
        if (bc == null) {
            throw new KernelException("Unknown bean '" + beanName + "'.");
        }
        if (bc.getState() != BeanConfig.State.initialized) {
            try {
                bc.getKernel().initBean(bc, new HashSet<BeanConfig>(), 0);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception getting instance", e);
                throw new KernelException(e);
            }
            this.injectIfRequired(bc);
        }
        T result = bc.getKernel().getInstance(bc);
        return result;
    }

    public <T> T getInstanceIfExistsOr(String beanName, Function<BeanConfig, T> function) {
        BeanConfig bc = this.dependencyManager.getBeanConfig(beanName);
        if (bc == null && this.parent != null && this.parent.isBeanClassRegistered(beanName)) {
            return this.parent.getInstanceIfExistsOr(beanName, function);
        }
        if (bc == null) {
            throw new KernelException("Unknown bean '" + beanName + "'.");
        }
        T result = bc.getKernel().getInstance(bc);
        if (result == null) {
            result = function.apply(bc);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void registerLinks(String beanName) {
        Link l = this.registeredLinks.get(beanName);
        if (l != null) {
            this.lnInternal(l.exportingBeanName, l.destinationKernel, l.destinationName);
        }
    }

    public Collection<String> getNamesOf(Class<?> beanType) {
        ArrayList<String> result = new ArrayList<String>();
        List<BeanConfig> bcs = this.dependencyManager.getBeanConfigs(beanType, null, null);
        for (BeanConfig beanConfig : bcs) {
            result.add(beanConfig.getBeanName());
        }
        return Collections.unmodifiableCollection(result);
    }

    public Kernel getParent() {
        return this.parent;
    }

    void setParent(Kernel parent) {
        this.dependencyManager.setParent(parent.getDependencyManager());
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Kernel{");
        sb.append("name=").append(this.name);
        sb.append(", parent=").append(this.parent);
        sb.append('}');
        return sb.toString();
    }

    public void initAll() {
        try {
            for (BeanConfig bc : this.dependencyManager.getBeanConfigs()) {
                if (bc.getState() == BeanConfig.State.initialized) continue;
                this.initBean(bc, new HashSet<BeanConfig>(), 0);
            }
        }
        catch (Exception e) {
            throw new KernelException("Can''t initialize all beans", e);
        }
    }

    public boolean isBeanClassRegistered(String beanName) {
        return this.isBeanClassRegistered(beanName, true);
    }

    public boolean isBeanClassRegistered(String beanName, boolean checkInParent) {
        boolean x = this.dependencyManager.isBeanClassRegistered(beanName);
        if (!x && this.parent != null) {
            x = this.parent.isBeanClassRegistered(beanName);
        }
        return x;
    }

    public void ln(String exportingBeanName, Kernel destinationKernel, String destinationName) {
        Link link = new Link();
        link.exportingBeanName = exportingBeanName;
        link.destinationKernel = destinationKernel;
        link.destinationName = destinationName;
        this.registeredLinks.put(exportingBeanName, link);
        BeanConfig dbc = this.lnInternal(exportingBeanName, destinationKernel, destinationName);
    }

    public BeanConfigBuilder registerBean(Class<?> beanClass) {
        BeanConfigBuilder builder;
        if (this.currentlyUsedConfigBuilder != null) {
            throw new KernelException("Registration of bean '" + this.currentlyUsedConfigBuilder.getBeanName() + "' is not finished yet!");
        }
        Bean annotation = beanClass.getAnnotation(Bean.class);
        if (annotation == null || annotation.name() == null || annotation.name().isEmpty()) {
            throw new KernelException("Name of bean class " + beanClass.getName() + " is not defined.");
        }
        this.currentlyUsedConfigBuilder = builder = new BeanConfigBuilder(this, this.dependencyManager, annotation.name());
        builder.asClass(beanClass);
        builder.setActive(annotation.active());
        if (annotation.exportable()) {
            builder.exportable();
        }
        return builder;
    }

    public BeanConfigBuilder registerBean(String beanName) {
        BeanConfigBuilder builder;
        if (this.currentlyUsedConfigBuilder != null) {
            throw new KernelException("Registration of bean '" + this.currentlyUsedConfigBuilder.getBeanName() + "' is not finished yet!");
        }
        this.currentlyUsedConfigBuilder = builder = new BeanConfigBuilder(this, this.dependencyManager, beanName);
        return builder;
    }

    public DelayedDependencyInjectionQueue beginDependencyDelayedInjection() {
        DelayedDependencyInjectionQueue queue = DELAYED_DEPENDENCY_INJECTION.get();
        if (queue == null) {
            queue = new DelayedDependencyInjectionQueue();
            DELAYED_DEPENDENCY_INJECTION.set(queue);
            return queue;
        }
        return null;
    }

    public void finishDependecyDelayedInjection(DelayedDependencyInjectionQueue queue) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "[{0}] Finishing injecting dependencies, queue: {1}", new Object[]{this.getName(), queue});
        }
        if (queue == null) {
            return;
        }
        DELAYED_DEPENDENCY_INJECTION.remove();
        for (DelayedDependenciesInjection item : queue.getQueue()) {
            item.inject();
        }
    }

    public void setBeanActive(String beanName, boolean value) {
        BeanConfig beanConfig = this.dependencyManager.getBeanConfig(beanName);
        if (beanConfig == null) {
            throw new KernelException("Unknown bean '" + beanName + "'.");
        }
        while (beanConfig instanceof DelegatedBeanConfig) {
            beanConfig = ((DelegatedBeanConfig)beanConfig).getOriginal();
        }
        if (beanConfig.getKernel() != this) {
            if (RegistrarBean.class.isAssignableFrom(beanConfig.getClazz()) && (beanConfig.getState() == BeanConfig.State.initialized || beanConfig.getState() == BeanConfig.State.instanceCreated)) {
                beanConfig.getKernel().setBeanActive("service", value);
            } else {
                beanConfig.getKernel().setBeanActive(beanConfig.getBeanName(), value);
            }
            return;
        }
        if (value && beanConfig.getState() == BeanConfig.State.inactive) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + this.getName() + "] Making bean " + beanName + " active");
            }
            beanConfig.setState(BeanConfig.State.registered);
            try {
                this.injectIfRequired(beanConfig);
            }
            catch (KernelException e) {
                log.fine("Cannot initialize " + beanConfig.getBeanName() + ". Leaving in state " + beanConfig.getState());
            }
        }
        if (!value && beanConfig.getState() != BeanConfig.State.inactive) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + this.getName() + "] Making bean " + beanName + " inactive");
            }
            try {
                if (beanConfig instanceof DelegatedBeanConfig) {
                    beanConfig = ((DelegatedBeanConfig)beanConfig).getOriginal();
                }
                Object i = beanConfig.getKernel().beanInstances.remove(beanConfig.getBeanInstanceName());
                this.fireUnregisterAware(i);
                if (i instanceof RegistrarBean) {
                    ((RegistrarBean)i).unregister(beanConfig.getKernel());
                    Kernel parent = beanConfig.getKernel().getParent();
                    parent.unregister(beanConfig.getBeanName() + "#KERNEL");
                    beanConfig.setKernel(parent);
                    beanConfig.setBeanInstanceName(null);
                }
                beanConfig.setState(BeanConfig.State.inactive);
                beanConfig.getKernel().unloadInjectedBean(beanConfig);
            }
            catch (Exception e) {
                throw new KernelException("Can''t unload bean " + beanName + " from depenent beans", e);
            }
        }
    }

    public void setForceAllowNull(boolean forceAllowNull) {
        this.forceAllowNull = forceAllowNull;
    }

    public void shutdown() {
        this.shutdown(null);
    }

    public void shutdown(Comparator<BeanConfig> shutdownOrder) {
        this.initiateShutdown();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Shutting down kernel and beans...");
        }
        Stream<BeanConfig> beanConfigStream = this.getDependencyManager().getBeanConfigs().stream().filter(bc -> !bc.getBeanName().endsWith("#KERNEL"));
        if (shutdownOrder != null) {
            beanConfigStream = beanConfigStream.sorted(shutdownOrder);
        }
        List beanNames = beanConfigStream.map(bc -> bc.getBeanName()).collect(Collectors.toList());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "found " + beanNames.size() + " to stop: " + beanNames);
        }
        for (String beanName : beanNames) {
            try {
                BeanConfig bc2;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "disabling bean " + beanName + "...");
                }
                if ((bc2 = this.getDependencyManager().getBeanConfig(beanName)) != null && bc2.getState() != BeanConfig.State.inactive) {
                    this.setBeanActive(beanName, false);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "bean " + beanName + " stopped.");
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "bean " + beanName + " was already stopped!");
            }
            catch (Throwable ex) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "failed to disable bean " + beanName, ex);
            }
        }
    }

    private void initiateShutdown() {
        this.shutdown = true;
        this.beanInstances.values().stream().filter(o -> o instanceof Kernel).map(o -> (Kernel)o).filter(o -> o != this).forEach(Kernel::initiateShutdown);
    }

    public void unregister(String beanName) {
        BeanConfig[] links;
        BeanConfig unregisteredBeanConfig;
        if (log.isLoggable(Level.FINER)) {
            log.finer("[" + this.getName() + "] Unregistering bean " + beanName);
        }
        if ((unregisteredBeanConfig = this.dependencyManager.getBeanConfig(beanName)) == null) {
            return;
        }
        if (!(unregisteredBeanConfig instanceof DelegatedBeanConfig) && unregisteredBeanConfig.getKernel() != this && !RegistrarBean.class.isAssignableFrom(unregisteredBeanConfig.getClazz())) {
            unregisteredBeanConfig.getKernel().unregister(beanName);
            return;
        }
        HashMap lklklk = new HashMap();
        this.getDependencyManager().getBeanConfigs(Kernel.class, null, null).stream().filter(beanConfig -> beanConfig.getState() == BeanConfig.State.initialized).map(new Function<BeanConfig, Kernel>(){

            @Override
            public Kernel apply(BeanConfig beanConfig) {
                return (Kernel)Kernel.this.getInstance(beanConfig);
            }
        }).forEach(kernel -> {
            Collection<Dependency> links = kernel.getDependencyManager().getDependenciesTo(unregisteredBeanConfig);
            ArrayList<BeanConfig> toRemove = new ArrayList<BeanConfig>();
            for (Dependency link : links) {
                BeanConfig[] bc = kernel.getDependencyManager().getBeanConfig(link);
                toRemove.addAll(Arrays.asList(bc));
            }
            lklklk.put(kernel, toRemove);
        });
        this.unregisterInt(beanName);
        try {
            this.unloadInjectedBean(unregisteredBeanConfig);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception during unregistering", e);
            throw new KernelException("Can''t unload bean " + beanName + " from depenent beans", e);
        }
        finally {
            this.dependencyManager.unregister(beanName);
        }
        this.getDependencyManager().getBeanConfigs(Kernel.class, null, null).stream().filter(beanConfig -> beanConfig.getState() == BeanConfig.State.initialized).map(new Function<BeanConfig, Kernel>(){

            @Override
            public Kernel apply(BeanConfig beanConfig) {
                return (Kernel)Kernel.this.getInstance(beanConfig);
            }
        }).forEach(kernel -> {
            BeanConfig[] links;
            for (BeanConfig link : links = kernel.getDependencyManager().findDelegationTo(unregisteredBeanConfig)) {
                kernel.unregister(link.getBeanName());
            }
        });
        if (this.parent != null && (links = this.parent.getDependencyManager().findDelegationTo(unregisteredBeanConfig)) != null) {
            for (BeanConfig link : links) {
                this.parent.unregister(link.getBeanName());
            }
        }
        for (Map.Entry en : lklklk.entrySet()) {
            Kernel kernel2 = (Kernel)en.getKey();
            for (BeanConfig beanConfig2 : (ArrayList)en.getValue()) {
                try {
                    kernel2.unloadInjectedBean(beanConfig2);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception during un-registering", e);
                    throw new KernelException("Can''t unload bean " + beanConfig2.getBeanName() + " from depenent beans in kernel " + kernel2.getName(), e);
                }
            }
        }
    }

    public String toPrintable() {
        StringBuilder sb = new StringBuilder();
        this.toPrintable(sb, 0);
        return sb.toString();
    }

    private void toPrintable(StringBuilder sb, int level) {
        this.dependencyManager.getBeanConfigs().stream().filter(bc -> !bc.getBeanName().endsWith("#KERNEL")).sorted((bc1, bc2) -> bc1.getBeanName().compareTo(bc2.getBeanName())).forEach(bc -> {
            for (int i = 0; i < level; ++i) {
                sb.append(" ");
            }
            sb.append(bc.getBeanName());
            sb.append("(state: ").append((Object)bc.getState()).append(", class: ").append((String)Optional.ofNullable(bc.getClazz()).map(Class::getCanonicalName).orElse(null)).append(")");
            if (RegistrarBean.class.isAssignableFrom(bc.getClazz())) {
                sb.append(" {\n");
                Kernel k = (Kernel)this.beanInstances.get(bc.getBeanName() + "#KERNEL");
                if (k != null) {
                    k.toPrintable(sb, level + 1);
                }
                for (int i = 0; i < level; ++i) {
                    sb.append(" ");
                }
                sb.append("}\n");
            } else {
                sb.append("\n");
            }
        });
    }

    <T> T getInstance(BeanConfig beanConfig) {
        while (beanConfig instanceof DelegatedBeanConfig) {
            beanConfig = ((DelegatedBeanConfig)beanConfig).original;
        }
        String beanInstanceName = beanConfig.getBeanInstanceName();
        return (T)beanConfig.getKernel().beanInstances.get(beanInstanceName);
    }

    void injectDependency(Dependency dep) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BeanConfig depbc;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[{0}] Injecting dependency, dep: {1}", new Object[]{this.getName(), dep});
        }
        if ((depbc = dep.getBeanConfig()).getState() == BeanConfig.State.initialized || depbc.getState() == BeanConfig.State.instanceCreated) {
            Object bean = depbc.getKernel().getInstance(depbc);
            if (bean == null) {
                log.log(Level.FINEST, "skipping injection of dependencies to " + dep + " as there is no bean instance");
                return;
            }
            this.injectDependencies(bean, dep, new HashSet<BeanConfig>(), 0, false);
        }
    }

    void injectDependencies(Collection<Dependency> dps) {
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "[{0}] Injecting dependencies, dps: {1}", new Object[]{this.getName(), dps});
        }
        for (Dependency dep : dps) {
            BeanConfig depbc = dep.getBeanConfig();
            try {
                this.injectDependency(dep);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can''t inject dependency to bean " + depbc.getBeanName() + " (class: " + depbc.getClazz() + ") unloading bean " + depbc.getBeanName() + ExceptionUtilities.getExceptionRootCause((Exception)e, (boolean)true));
                log.log(Level.CONFIG, "Can''t inject dependency to bean " + depbc.getBeanName() + " (class: " + depbc.getClazz() + ") unloading bean " + depbc.getBeanName(), e);
                try {
                    Object i = depbc.getKernel().beanInstances.remove(depbc);
                    BeanConfig.State oldState = depbc.getState();
                    depbc.setState(BeanConfig.State.inactive);
                    if (oldState == BeanConfig.State.initialized) {
                        this.fireUnregisterAware(i);
                    }
                    this.unloadInjectedBean(depbc);
                }
                catch (Exception ex) {
                    throw new KernelException("Can''t unload bean " + depbc.getBeanName(), ex);
                }
                finally {
                    depbc.setState(BeanConfig.State.registered);
                }
            }
        }
    }

    BeanConfig lnInternal(String exportingBeanName, Kernel destinationKernel, String destinationName) {
        BeanConfig sbc = this.dependencyManager.getBeanConfig(exportingBeanName);
        if (sbc == null) {
            throw new KernelException("Can''t export bean " + exportingBeanName + " as there is no such bean");
        }
        DelegatedBeanConfig dbc = new DelegatedBeanConfig(destinationName, sbc);
        destinationKernel.dependencyManager.register(dbc);
        return dbc;
    }

    void putBeanInstance(String beanName, Object beanInstance) {
        Object oldBeanInstance = this.beanInstances.put(beanName, beanInstance);
        if (oldBeanInstance instanceof UnregisterAware && oldBeanInstance != beanInstance) {
            ((UnregisterAware)oldBeanInstance).beforeUnregister();
        }
        if (beanInstance instanceof Kernel && beanInstance != this) {
            ((Kernel)beanInstance).setParent(this);
        }
    }

    void putBeanInstance(BeanConfig beanConfig, Object beanInstance) {
        this.putBeanInstance(beanConfig.getBeanName(), beanInstance);
    }

    void unregisterInt(String beanName) {
        if (this.dependencyManager.isBeanClassRegistered(beanName)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + this.getName() + "] Found registred bean " + beanName + ". Unregistering...");
            }
            BeanConfig oldBeanConfig = this.dependencyManager.unregister(beanName);
            Object i = oldBeanConfig.getKernel().beanInstances.remove(oldBeanConfig.getBeanInstanceName());
            oldBeanConfig.setBeanInstanceName(null);
            if (oldBeanConfig.getState() == BeanConfig.State.initialized) {
                this.fireUnregisterAware(i);
            }
            for (BeanConfig bc : oldBeanConfig.getRegisteredBeans()) {
                if (!bc.removeRegisteredBy(oldBeanConfig)) continue;
                bc.getKernel().unregisterInt(bc.getBeanName());
            }
            if (RegistrarBean.class.isAssignableFrom(oldBeanConfig.getClazz()) && oldBeanConfig.getKernel().getParent() != null) {
                oldBeanConfig.getKernel().getParent().unregister(oldBeanConfig.getBeanName());
                oldBeanConfig.getKernel().getParent().unregister(oldBeanConfig.getBeanName() + "#KERNEL");
            }
        }
    }

    protected <T> T getInstance(Class<T> beanClass, boolean allowNonExportable) {
        List<BeanConfig> bcs = this.dependencyManager.getBeanConfigs(beanClass, null, null, allowNonExportable);
        if (bcs.size() > 1) {
            throw new KernelException("Too many beans implemented class " + beanClass);
        }
        if (bcs.isEmpty() && this.parent != null && this.parent != this) {
            return this.parent.getInstance(beanClass, false);
        }
        if (bcs.isEmpty()) {
            throw new KernelException("Can''t find bean implementing " + beanClass);
        }
        BeanConfig bc = bcs.get(0);
        if (bc.getState() != BeanConfig.State.initialized) {
            try {
                this.initBean(bc, new HashSet<BeanConfig>(), 0);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception getting instance", e);
                throw new KernelException(e);
            }
        }
        T result = bc.getKernel().getInstance(bc);
        return result;
    }

    protected void injectIfRequired(BeanConfig beanConfig) {
        try {
            if (!this.isThereSomethingWaitingFor(beanConfig)) {
                return;
            }
            Collection<Dependency> dps = this.dependencyManager.getDependenciesTo(beanConfig);
            for (Dependency dep : dps) {
                BeanConfig depbc = dep.getBeanConfig();
                if (depbc.getState() != BeanConfig.State.initialized && depbc.getState() != BeanConfig.State.inactive) {
                    try {
                        if (depbc.getState() != BeanConfig.State.instanceCreated) {
                            this.initBean(depbc, new HashSet<BeanConfig>(), 0);
                        }
                        this.injectIfRequired(depbc);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Exception injecting bean if required", e);
                    }
                }
                if (depbc.getState() != BeanConfig.State.initialized) continue;
                if (beanConfig.getState() != BeanConfig.State.initialized) {
                    try {
                        this.initBean(beanConfig, new HashSet<BeanConfig>(), 0);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Exception injecting bean if required", e);
                        return;
                    }
                }
                Object bean = depbc.getKernel().getInstance(depbc);
                this.injectDependencies(bean, dep, new HashSet<BeanConfig>(), 0, false);
            }
            if (beanConfig.isExportable()) {
                this.getDependencyManager().getBeanConfigs().stream().filter(bc -> Kernel.class.isAssignableFrom(bc.getClazz()) && bc.getState() == BeanConfig.State.initialized).map(p -> (Kernel)this.getInstance((BeanConfig)p)).filter(k -> !k.equals(this)).forEach(k -> k.injectIfRequired(beanConfig));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception", e);
            throw new KernelException("Can''t inject bean " + beanConfig + " to dependend beans.", e);
        }
    }

    protected BeanConfig registerBean(BeanConfig beanConfig, BeanConfig factoryBeanConfig, Object beanInstance) {
        BeanConfig oldBeanConfig;
        BeanConfig parent = null;
        if (beanConfig.getSource() == BeanConfig.Source.annotation && !beanConfig.getRegisteredBy().isEmpty()) {
            BeanConfig bc = this.dependencyManager.getBeanConfig(beanConfig.getBeanName());
            parent = beanConfig.getRegisteredBy().iterator().next();
            if (bc != null && bc.getClazz().equals(beanConfig.getClazz())) {
                bc.addRegisteredBy(parent);
                parent.addRegisteredBean(bc);
                this.currentlyUsedConfigBuilder = null;
                return bc;
            }
        }
        if (factoryBeanConfig != null) {
            factoryBeanConfig.setPinned(beanConfig.isPinned());
            factoryBeanConfig.setState(beanConfig.getState());
            this.unregisterInt(factoryBeanConfig.getBeanName());
            this.dependencyManager.register(factoryBeanConfig);
        }
        Collection<Dependency> oldDeps = (oldBeanConfig = this.dependencyManager.getBeanConfig(beanConfig.getBeanName())) == null ? null : this.dependencyManager.getDependenciesTo(oldBeanConfig);
        this.unregisterInt(beanConfig.getBeanName());
        this.dependencyManager.register(beanConfig);
        if (parent != null) {
            parent.addRegisteredBean(beanConfig);
        }
        if (beanInstance != null) {
            this.putBeanInstance(beanConfig, beanInstance);
            beanConfig.setState(BeanConfig.State.initialized);
        }
        Collection<Dependency> deps = this.dependencyManager.getDependenciesTo(beanConfig);
        if (oldDeps != null) {
            deps.addAll(oldDeps.stream().filter(od -> {
                Field f = od.getField();
                return !deps.stream().anyMatch(nd -> nd.getField().equals(f));
            }).collect(Collectors.toSet()));
        }
        this.currentlyUsedConfigBuilder = null;
        if (!this.queueForDelayedDependencyInjection(deps)) {
            this.injectDependencies(deps);
        }
        return beanConfig;
    }

    private Object createNewInstance(BeanConfig beanConfig) {
        try {
            if (beanConfig.getFactory() != null) {
                BeanFactory factory = (BeanFactory)beanConfig.getKernel().getInstance(beanConfig.getFactory());
                return factory.createInstance();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + this.getName() + "] Creating instance of bean " + beanConfig.getBeanName());
            }
            Class<?> clz = beanConfig.getClazz();
            return clz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage() != null && e.getMessage().contains("licence")) {
                String[] msg = new String[]{"ERROR! ACS strategy was enabled with following class configuration", "--sm-cluster-strategy-class=tigase.server.cluster.strategy.OnlineUsersCachingStrategy", "but required libraries are missing!", "", "Please make sure that all tigase-acs*.jar and licence-lib.jar", "files are available in the classpath or disable ACS strategy!", "(by commenting out above line)", "", "For more information please peruse ACS documentation."};
                TigaseRuntime.getTigaseRuntime().shutdownTigase(msg);
            }
            throw new KernelException("Can''t create instance of bean '" + beanConfig.getBeanName() + "' (class: " + beanConfig.getClazz() + ")", e);
        }
        catch (Exception e) {
            throw new KernelException("Can''t create instance of bean '" + beanConfig.getBeanName() + "' (class: " + beanConfig.getClazz() + ")", e);
        }
    }

    private void fireUnregisterAware(Object i) {
        if (i != null && i instanceof UnregisterAware) {
            try {
                ((UnregisterAware)i).beforeUnregister();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem during unregistering bean", e);
            }
        }
    }

    private Collection<BeanConfig> gc_getInjectedBeans() {
        HashSet<BeanConfig> injectedBeans = new HashSet<BeanConfig>();
        Collection<BeanConfig> bcs = this.dependencyManager.getBeanConfigs();
        for (BeanConfig bc : bcs) {
            if (bc.getState() != BeanConfig.State.initialized) continue;
            for (Dependency dp : bc.getFieldDependencies().values()) {
                BeanConfig[] xxx;
                for (BeanConfig beanConfig : xxx = this.dependencyManager.getBeanConfig(dp)) {
                    if (beanConfig == null || beanConfig.getState() != BeanConfig.State.initialized) continue;
                    injectedBeans.add(beanConfig);
                }
            }
        }
        return injectedBeans;
    }

    private boolean inject(Object[] data, Dependency dependency, Object toBean, boolean forceNullInjection) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object valueToSet;
        if (!(forceNullInjection || this.forceAllowNull || dependency.isNullAllowed() || data != null && data.length != 0)) {
            throw new KernelException("Can't inject <null> to field " + dependency.getField().getDeclaringClass().getName() + "." + dependency.getField().getName());
        }
        if (data == null) {
            valueToSet = null;
        } else if (Collection.class.isAssignableFrom(dependency.getField().getType())) {
            AbstractCollection o = !dependency.getField().getType().isInterface() ? (HashSet<Object>)dependency.getField().getType().newInstance() : (dependency.getField().getType().isAssignableFrom(Set.class) ? new HashSet<Object>() : new ArrayList());
            o.addAll(Arrays.asList(data));
            valueToSet = o;
        } else {
            Object o;
            if (data != null && dependency.getField().getType().equals(data.getClass())) {
                o = data;
            } else {
                int l = Array.getLength(data);
                if (l > 1) {
                    throw new KernelException("Can''t put many objects to single field " + dependency.getField());
                }
                o = l == 0 ? null : Array.get(data, 0);
            }
            valueToSet = o;
        }
        BeanUtils.setValue(toBean, dependency.getField(), valueToSet);
        return !forceNullInjection || this.forceAllowNull || dependency.isNullAllowed() || data != null && data.length != 0;
    }

    private boolean injectDependencies(Object bean, Dependency dep, Set<BeanConfig> createdBeansConfig, int deep, boolean forceNullInjection) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object[] d;
        if (this.shutdown) {
            return false;
        }
        BeanConfig[] dependentBeansConfigs = this.dependencyManager.getBeanConfig(dep);
        ArrayList dataToInject = new ArrayList();
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "[{0}] Injecting dependencies, bean: {1}, dep: {2}, createdBeansConfig: {3}, deep: {4}", new Object[]{this.getName(), bean, dep, createdBeansConfig.size(), deep});
        }
        for (BeanConfig b : dependentBeansConfigs) {
            if (b == null) continue;
            Object beanToInject = b.getKernel().getInstance(b);
            if (beanToInject == null) {
                try {
                    this.initBean(b, createdBeansConfig, deep + 1);
                }
                catch (InstantiationException | RuntimeException | InvocationTargetException ex) {
                    log.log(Level.WARNING, "\n\n\n=====================\nCould not initialize bean " + b.getBeanName() + " (class: " + b.getClazz() + "), skipping injection of this bean" + ExceptionUtilities.getExceptionRootCause((Exception)ex, (boolean)true) + "\n=====================\n\n\n");
                    log.log(Level.CONFIG, "Could not initialize bean " + b.getBeanName() + " (class: " + b.getClazz() + "), skipping injection of this bean", ex);
                    Object i = b.getKernel().beanInstances.remove(b);
                    if (i instanceof RegistrarBean) {
                        ((RegistrarBean)i).unregister(b.getKernel());
                        Kernel parent = b.getKernel().getParent();
                        parent.unregister(b.getBeanName() + "#KERNEL");
                        b.setKernel(parent);
                    }
                    b.setState(BeanConfig.State.registered);
                    continue;
                }
                beanToInject = b.getKernel().getInstance(b);
            }
            if (beanToInject == null || dataToInject.contains(beanToInject)) continue;
            dataToInject.add(beanToInject);
        }
        if (dataToInject.isEmpty()) {
            d = new Object[]{};
        } else if (dep.getType() != null) {
            Class type = dep.getType();
            if (Collection.class.isAssignableFrom(type)) {
                Type t = ReflectionHelper.getCollectionParamter(dep.getGenericType(), dep.getBeanConfig().getClazz());
                type = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (t instanceof TypeVariable ? (Class)((TypeVariable)t).getBounds()[0] : (Class)t);
            }
            Object[] z = (Object[])Array.newInstance(type, 1);
            d = dataToInject.toArray(z);
        } else {
            d = dataToInject.toArray();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("[" + this.getName() + "] Injecting " + Arrays.toString(d) + " to " + dep.getBeanConfig() + "#" + dep);
        }
        return this.inject(d, dep, bean, forceNullInjection);
    }

    private boolean isThereSomethingWaitingFor(BeanConfig beanConfig) {
        Set related = this.dependencyManager.getDependenciesTo(beanConfig).stream().map(d -> d.getBeanConfig()).collect(Collectors.toSet());
        while (true) {
            HashSet toAdd = new HashSet();
            for (BeanConfig config : related) {
                for (Dependency dependency : this.dependencyManager.getDependenciesTo(config)) {
                    if (related.contains(dependency.getBeanConfig())) continue;
                    toAdd.add(dependency.getBeanConfig());
                }
            }
            if (toAdd.size() == 0) break;
            related.addAll(toAdd);
        }
        for (BeanConfig config : related) {
            if (config.getState() != BeanConfig.State.initialized) continue;
            return true;
        }
        if (beanConfig.isExportable()) {
            long r = this.getDependencyManager().getBeanConfigs().stream().filter(bc -> Kernel.class.isAssignableFrom(bc.getClazz()) && bc.getState() == BeanConfig.State.initialized).map(p -> (Kernel)this.getInstance((BeanConfig)p)).filter(k -> !k.equals(this)).map(kernel -> kernel.isThereSomethingWaitingFor(beanConfig)).filter(Boolean::booleanValue).count();
            return r > 0L;
        }
        return false;
    }

    private boolean queueForDelayedDependencyInjection(Collection<Dependency> deps) {
        DelayedDependencyInjectionQueue queue = DELAYED_DEPENDENCY_INJECTION.get();
        if (queue == null) {
            return false;
        }
        if (deps.isEmpty()) {
            return true;
        }
        queue.offer(new DelayedDependenciesInjection(deps));
        return true;
    }

    private void unloadInjectedBean(BeanConfig beanConfig) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        HashSet<BeanConfig> beansToRemove = new HashSet<BeanConfig>();
        for (BeanConfig bc : this.dependencyManager.getBeanConfigs()) {
            Object ob;
            if (bc.getState() != BeanConfig.State.initialized || (ob = bc.getKernel().getInstance(bc)) == null) continue;
            for (Dependency d : bc.getFieldDependencies().values()) {
                if (!DependencyManager.match(d, beanConfig)) continue;
                try {
                    boolean r;
                    BeanConfig[] cbcs = this.dependencyManager.getBeanConfig(d);
                    if (cbcs.length == 0) {
                        r = this.inject(null, d, ob, false);
                        if (r) continue;
                        beansToRemove.add(bc);
                        continue;
                    }
                    r = this.injectDependencies(ob, d, new HashSet<BeanConfig>(), 0, false);
                    if (r) continue;
                    beansToRemove.add(bc);
                }
                catch (KernelException ex) {
                    log.log(Level.FINEST, "Can''t set null to " + d + " unloading bean " + d.getBeanName(), ex);
                    beansToRemove.add(bc);
                }
            }
        }
        for (BeanConfig config : beansToRemove) {
            log.log(Level.INFO, "Removing " + config.getBeanName() + " because of dependency violation");
            if (this.dependencyManager.getBeanConfig(config.getBeanName()) == null) continue;
            this.setBeanActive(config.getBeanName(), false);
        }
        if (!this.shutdown) {
            for (BeanConfig config : beansToRemove) {
                if (config.getState() != BeanConfig.State.inactive) continue;
                config.setState(BeanConfig.State.registered);
            }
        }
    }

    public static class DelegatedBeanConfig
    extends BeanConfig {
        private final BeanConfig original;

        DelegatedBeanConfig(String localName, BeanConfig src) {
            super(localName, src.getClazz());
            this.original = src;
        }

        @Override
        public Class<?> getClazz() {
            return this.original.getClazz();
        }

        @Override
        public BeanConfig getFactory() {
            return this.original.getFactory();
        }

        @Override
        public Map<Field, Dependency> getFieldDependencies() {
            return this.original.getFieldDependencies();
        }

        @Override
        public Kernel getKernel() {
            return this.original.getKernel();
        }

        public BeanConfig getOriginal() {
            return this.original;
        }

        @Override
        public BeanConfig.State getState() {
            return this.original.getState();
        }

        @Override
        public boolean isExportable() {
            return this.original.isExportable();
        }

        @Override
        public String toString() {
            return this.original.toString();
        }
    }

    public class DelayedDependencyInjectionQueue {
        private final ArrayDeque<DelayedDependenciesInjection> queue = new ArrayDeque();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(DelayedDependenciesInjection item) {
            ArrayDeque<DelayedDependenciesInjection> arrayDeque = this.queue;
            synchronized (arrayDeque) {
                DelayedDependenciesInjection last = this.queue.peekLast();
                if (last != null && last.equals(item)) {
                    return true;
                }
                return this.queue.offer(item);
            }
        }

        public Queue<DelayedDependenciesInjection> getQueue() {
            return this.queue;
        }

        public boolean checkStartingKernel(Kernel kernel) {
            return Kernel.this == kernel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DelayedDependencyInjectionQueue{");
            sb.append(this.queue.stream().flatMap(queue -> queue.dependencies.stream()).collect(Collectors.toList()));
            sb.append('}');
            return sb.toString();
        }
    }

    private class Link {
        Kernel destinationKernel;
        String destinationName;
        String exportingBeanName;

        private Link() {
        }
    }

    private class DelayedDependenciesInjection {
        private final Collection<Dependency> dependencies;

        public DelayedDependenciesInjection(Collection<Dependency> deps) {
            this.dependencies = deps;
        }

        public void inject() throws IllegalAccessException, InvocationTargetException, InstantiationException {
            for (Dependency dep : this.dependencies) {
                Kernel.this.injectDependency(dep);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof DelayedDependenciesInjection) {
                DelayedDependenciesInjection o = (DelayedDependenciesInjection)obj;
                if (o.dependencies.size() != this.dependencies.size()) {
                    return false;
                }
                return o.dependencies.containsAll(this.dependencies) && this.dependencies.containsAll(o.dependencies);
            }
            return super.equals(obj);
        }

        public String toString() {
            return "dependencies=" + this.dependencies;
        }
    }
}

