/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.util.JDBCPasswordObfuscator;
import tigase.db.util.RepositoryVersionAware;
import tigase.util.cache.SimpleCache;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class JDBCRepository
implements AuthRepository,
UserRepository,
DataSourceAware<DataRepository>,
RepositoryVersionAware {
    public static final String CURRENT_DB_SCHEMA_VER = "8.0.0";
    public static final String DEF_MAXIDS_TBL = "tig_max_ids";
    public static final String DEF_NODES_TBL = "tig_nodes";
    public static final String DEF_PAIRS_TBL = "tig_pairs";
    public static final String DEF_ROOT_NODE = "root";
    public static final String DEF_USERS_TBL = "tig_users";
    public static final String DERBY_GETSCHEMAVER_QUERY = "values TigGetDBProperty('schema-version')";
    public static final String SQLSERVER_GETSCHEMAVER_QUERY = "select dbo.TigGetDBProperty('schema-version')";
    public static final String JDBC_GETSCHEMAVER_QUERY = "select TigGetDBProperty('schema-version')";
    public static final String SCHEMA_UPGRADE_LINK = "Administration Guide > Tigase Server Schema v8.0 Updates (available locally in docs directory and online http://docs.tigase.org)";
    private static final String ADD_NODE_QUERY = "{ call TigAddNode(?, ?, ?) }";
    private static final String ADD_USER_PLAIN_PW_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    private static final String COUNT_USERS_FOR_DOMAIN_QUERY = "select count(*) from tig_users where user_id like ?";
    private static final String COUNT_ACTIVE_USERS_QUERY = "select count(*) from tig_users where last_used > ?";
    private static final String DEF_GET_USERS_QUERY = "{ call TigAllUsers() }";
    private static final String GET_USER_DB_UID_QUERY = "{ call TigGetUserDBUid(?) }";
    private static final String GET_USERS_COUNT_QUERY = "{ call TigAllUsersCount() }";
    private static final Logger log = Logger.getLogger(JDBCRepository.class.getName());
    private static final String PGSQL_GET_USERS_QUERY = "select TigAllUsers()";
    private static final String REMOVE_USER_QUERY = "{ call TigRemoveUser(?) }";
    private static final String UPDATE_PAIRS_QUERY = "{ call TigUpdatePairs(?, ?, ?, ?) }";
    private static final String USER_STR = "User: ";
    private static final String REMOVE_KEY_DATA_QUERY = "delete from tig_pairs where (nid = ?) AND (pkey = ?)";
    private static final String NODES_FOR_NODE_QUERY = "select nid, node from tig_nodes where parent_nid = ?";
    private static final String KEYS_FOR_NODE_QUERY = "select pkey from tig_pairs where (nid = ?)";
    private static final String INSERT_KEY_VAL_QUERY = "insert into tig_pairs (nid, uid, pkey, pval)  values (?, ?, ?, ?)";
    private static final String DATA_FOR_NODE_QUERY = "select pval from tig_pairs where (nid = ?) AND (pkey = ?)";
    private static final String KEYS_DATA_FOR_NODE_QUERY = "select pkey, pval from tig_pairs where (nid = ?)";
    private static final String UPDATE_LAST_LOGIN_QUERY = "update tig_users set last_login=? where user_id=?";
    private AuthRepository auth = null;
    private boolean autoCreateUser = false;
    private IRepoCache<String, Object> cache = null;
    private DataRepository data_repo = null;
    private String get_users_query = null;

    @Override
    public void addDataList(BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            this.addDataList(null, user_id, subnode, key, list);
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Problem adding data list to repository", ex);
        }
    }

    @Override
    public void addUser(BareJID user_id) throws UserExistsException, TigaseDBException {
        try {
            this.addUserRepo(null, user_id);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error adding user to repository: ", e);
        }
    }

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getData(BareJID user_id, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        PreparedStatement data_for_node_st;
        long nid = this.getNodeNID(null, user_id, subnode);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loading data for key: {0}, user: {1}, node: {2}, def: {3}, found nid: {4}", new Object[]{key, user_id, subnode, def, nid});
        }
        if (nid <= 0L) return def;
        ResultSet rs = null;
        PreparedStatement preparedStatement = data_for_node_st = this.data_repo.getPreparedStatement(user_id, DATA_FOR_NODE_QUERY);
        synchronized (preparedStatement) {
            String string;
            try {
                String result = def;
                data_for_node_st.setLong(1, nid);
                data_for_node_st.setString(2, key);
                rs = data_for_node_st.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Found data: {0}", result);
                    }
                }
                string = result;
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TigaseDBException("Error getting user data for: " + user_id + "/" + subnode + "/" + key, e);
                }
            }
            return string;
        }
    }

    @Override
    public String getData(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, subnode, key, null);
    }

    @Override
    public String getData(BareJID user_id, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, null, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> getDataMap(BareJID user_id, String subnode) throws TigaseDBException {
        PreparedStatement data_for_node_st;
        long nid = this.getNodeNID(null, user_id, subnode);
        if (nid <= 0L) return Collections.emptyMap();
        ResultSet rs = null;
        PreparedStatement preparedStatement = data_for_node_st = this.data_repo.getPreparedStatement(user_id, KEYS_DATA_FOR_NODE_QUERY);
        synchronized (preparedStatement) {
            HashMap<String, String> hashMap;
            try {
                HashMap<String, String> results = new HashMap<String, String>();
                data_for_node_st.setLong(1, nid);
                rs = data_for_node_st.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1);
                    String value = rs.getString(2);
                    results.put(key, value);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Found data: {0}, {1}", new String[]{key, value});
                }
                hashMap = results;
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TigaseDBException("Error getting data map for: " + user_id + "/" + subnode, e);
                }
            }
            return hashMap;
        }
    }

    @Override
    public <T> Map<String, T> getDataMap(BareJID user, String subnode, Function<String, T> converter) throws TigaseDBException {
        Map<String, String> data = this.getDataMap(user, subnode);
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, T> results = new HashMap<String, T>();
        for (Map.Entry<String, String> e : data.entrySet()) {
            String value = e.getValue();
            if (value != null) {
                results.put(e.getKey(), converter.apply(value));
                continue;
            }
            results.put(e.getKey(), null);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getDataList(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        PreparedStatement data_for_node_st;
        long nid = this.getNodeNID(null, user_id, subnode);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loading data for key: {0}, user: {1}, node: {2}, found nid: {3}", new Object[]{key, user_id, subnode, nid});
        }
        if (nid <= 0L) return null;
        ResultSet rs = null;
        PreparedStatement preparedStatement = data_for_node_st = this.data_repo.getPreparedStatement(user_id, DATA_FOR_NODE_QUERY);
        synchronized (preparedStatement) {
            String[] stringArray;
            try {
                String[] result;
                ArrayList<String> results = new ArrayList<String>();
                data_for_node_st.setLong(1, nid);
                data_for_node_st.setString(2, key);
                rs = data_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Found data: {0}", rs.getString(1));
                }
                stringArray = result = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TigaseDBException("Error getting data list for: " + user_id + "/" + subnode + "/" + key, e);
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getKeys(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        PreparedStatement keys_for_node_st;
        long nid = this.getNodeNID(null, user_id, subnode);
        if (nid <= 0L) return null;
        ResultSet rs = null;
        ArrayList<String> results = new ArrayList<String>();
        PreparedStatement preparedStatement = keys_for_node_st = this.data_repo.getPreparedStatement(user_id, KEYS_FOR_NODE_QUERY);
        synchronized (preparedStatement) {
            String[] stringArray;
            try {
                keys_for_node_st.setLong(1, nid);
                rs = keys_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                stringArray = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TigaseDBException("Error getting subnodes list.", e);
                }
            }
            return stringArray;
        }
    }

    @Override
    public String[] getKeys(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user_id, null);
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="Support for multi-level nodes will be removed")
    public String[] getSubnodes(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        PreparedStatement nodes_for_node_st;
        long nid = this.getNodeNID(null, user_id, subnode);
        if (nid <= 0L) return null;
        ResultSet rs = null;
        PreparedStatement preparedStatement = nodes_for_node_st = this.data_repo.getPreparedStatement(user_id, NODES_FOR_NODE_QUERY);
        synchronized (preparedStatement) {
            String[] stringArray;
            try {
                ArrayList<String> results = new ArrayList<String>();
                nodes_for_node_st.setLong(1, nid);
                rs = nodes_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(2));
                }
                stringArray = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TigaseDBException("Error getting subnodes list.", e);
                }
            }
            return stringArray;
        }
    }

    @Override
    public String[] getSubnodes(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user_id, null);
    }

    @Override
    public long getUserUID(BareJID user_id) throws TigaseDBException {
        try {
            return this.getUserUID(null, user_id);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error retrieving user UID from repository: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BareJID> getUsers() throws TigaseDBException {
        ResultSet rs = null;
        ArrayList<BareJID> users = null;
        try {
            PreparedStatement all_users_sp;
            PreparedStatement preparedStatement = all_users_sp = this.data_repo.getPreparedStatement(null, this.get_users_query);
            synchronized (preparedStatement) {
                try {
                    rs = all_users_sp.executeQuery();
                    users = new ArrayList<BareJID>(1000);
                    while (rs.next()) {
                        users.add(BareJID.bareJIDInstanceNS((String)rs.getString(1)));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                    rs = null;
                }
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem loading user list from repository", e);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveUsersCountIn(Duration duration) {
        try {
            PreparedStatement active_users_count;
            long users = -1L;
            ResultSet rs = null;
            PreparedStatement preparedStatement = active_users_count = this.data_repo.getPreparedStatement(null, COUNT_ACTIVE_USERS_QUERY);
            synchronized (preparedStatement) {
                try {
                    Instant instant = Instant.now().minus(duration);
                    active_users_count.setTimestamp(1, Timestamp.from(instant));
                    rs = active_users_count.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        try {
            PreparedStatement users_count_sp;
            ResultSet rs = null;
            long users = -1L;
            PreparedStatement preparedStatement = users_count_sp = this.data_repo.getPreparedStatement(null, GET_USERS_COUNT_QUERY);
            synchronized (preparedStatement) {
                try {
                    rs = users_count_sp.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                return users;
            }
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        try {
            PreparedStatement users_domain_count_st;
            ResultSet rs = null;
            long users = -1L;
            PreparedStatement preparedStatement = users_domain_count_st = this.data_repo.getPreparedStatement(null, COUNT_USERS_FOR_DOMAIN_QUERY);
            synchronized (preparedStatement) {
                try {
                    users_domain_count_st.setString(1, "%@" + domain);
                    rs = users_domain_count_st.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    @Override
    public void setDataSource(DataRepository dataSource) throws DBInitException {
        this.data_repo = dataSource;
        String connection_str = this.data_repo.getResourceUri();
        try {
            if (connection_str.contains("autoCreateUser=true")) {
                this.autoCreateUser = true;
            }
            if (connection_str.contains("cacheRepo=off")) {
                log.fine("Disabling cache.");
                this.cache = new RepoNoCache();
            } else {
                this.cache = new RepoCache(10000, 60000L);
            }
            this.data_repo.initPreparedStatement(GET_USER_DB_UID_QUERY, GET_USER_DB_UID_QUERY);
            this.data_repo.initPreparedStatement(GET_USERS_COUNT_QUERY, GET_USERS_COUNT_QUERY);
            this.get_users_query = connection_str.startsWith("jdbc:postgresql") ? PGSQL_GET_USERS_QUERY : DEF_GET_USERS_QUERY;
            this.data_repo.initPreparedStatement(this.get_users_query, this.get_users_query);
            this.data_repo.initPreparedStatement(ADD_USER_PLAIN_PW_QUERY, ADD_USER_PLAIN_PW_QUERY);
            this.data_repo.initPreparedStatement(REMOVE_USER_QUERY, REMOVE_USER_QUERY);
            this.data_repo.initPreparedStatement(ADD_NODE_QUERY, ADD_NODE_QUERY);
            this.data_repo.initPreparedStatement(COUNT_USERS_FOR_DOMAIN_QUERY, COUNT_USERS_FOR_DOMAIN_QUERY);
            this.data_repo.initPreparedStatement(COUNT_ACTIVE_USERS_QUERY, COUNT_ACTIVE_USERS_QUERY);
            this.data_repo.initPreparedStatement(DATA_FOR_NODE_QUERY, DATA_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(KEYS_FOR_NODE_QUERY, KEYS_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(KEYS_DATA_FOR_NODE_QUERY, KEYS_DATA_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(NODES_FOR_NODE_QUERY, NODES_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(INSERT_KEY_VAL_QUERY, INSERT_KEY_VAL_QUERY);
            this.data_repo.initPreparedStatement(REMOVE_KEY_DATA_QUERY, REMOVE_KEY_DATA_QUERY);
            this.data_repo.initPreparedStatement(UPDATE_PAIRS_QUERY, UPDATE_PAIRS_QUERY);
            this.data_repo.initPreparedStatement(UPDATE_LAST_LOGIN_QUERY, UPDATE_LAST_LOGIN_QUERY);
            this.auth = new AuthRepositoryImpl(this);
            log.log(Level.CONFIG, "Initialized database connection: {0}", JDBCPasswordObfuscator.obfuscatePassword(connection_str));
        }
        catch (SQLException ex) {
            this.data_repo = null;
            throw new DBInitException("Could not initialize repository", ex);
        }
    }

    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        return this.auth.isMechanismSupported(domain, mechanism);
    }

    @Override
    @Deprecated
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            if (this.data_repo == null) {
                DataRepository dataRepository = RepositoryFactory.getDataRepository(null, connection_str, params);
                dataRepository.checkSchemaVersion(this, true);
                this.setDataSource(dataRepository);
            }
        }
        catch (Exception e) {
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        this.auth.loggedIn(user);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    @Override
    public void removeData(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(null, user_id, subnode, key);
    }

    @Override
    public void removeData(BareJID user_id, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, null, key);
    }

    @Override
    public void removeSubnode(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        if (subnode == null) {
            return;
        }
        try {
            long nid;
            String[] subnodes = this.getSubnodes(user_id, subnode);
            if (subnodes != null && subnodes.length > 0) {
                for (String innerSubNode : subnodes) {
                    this.removeSubnode(user_id, subnode + "/" + innerSubNode);
                }
            }
            if ((nid = this.getNodeNID(null, user_id, subnode)) > 0L) {
                this.deleteSubnode(null, nid);
                this.cache.remove(user_id + "/" + subnode);
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        Statement stmt = null;
        String query = null;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing user: {0}", user_id);
        }
        try {
            PreparedStatement user_del_sp;
            stmt = this.data_repo.createStatement(user_id);
            long uid = this.getUserUID(null, user_id, this.autoCreateUser);
            query = "delete from tig_pairs where uid = " + uid;
            stmt.executeUpdate(query);
            query = "delete from tig_nodes where uid = " + uid;
            stmt.executeUpdate(query);
            PreparedStatement preparedStatement = user_del_sp = this.data_repo.getPreparedStatement(user_id, REMOVE_USER_QUERY);
            synchronized (preparedStatement) {
                user_del_sp.setString(1, user_id.toString());
                user_del_sp.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error removing user from repository: " + query, e);
        }
        finally {
            this.data_repo.release(stmt, null);
            stmt = null;
            this.cache.remove(user_id.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(BareJID user_id, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        DataRepository repo;
        long uid = -2L;
        long nid = -2L;
        DataRepository dataRepository = repo = this.data_repo.takeRepoHandle(user_id);
        synchronized (dataRepository) {
            try {
                uid = this.getUserUID(repo, user_id, this.autoCreateUser);
                nid = this.getNodeNID(repo, uid, subnode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Saving data setting data, user_id: {0}, subnode: {1}, key: {2}, uid: {3}, nid: {4}, value: {5}", new Object[]{user_id, subnode, key, uid, nid, value});
                }
                if (nid < 0L) {
                    try {
                        nid = this.createNodePath(repo, user_id, subnode);
                    }
                    catch (SQLException e) {
                        nid = this.getNodeNID(repo, uid, subnode);
                    }
                }
                PreparedStatement update_pairs_sp = repo.getPreparedStatement(user_id, UPDATE_PAIRS_QUERY);
                update_pairs_sp.setLong(1, nid);
                update_pairs_sp.setLong(2, uid);
                update_pairs_sp.setString(3, key);
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        update_pairs_sp.setCharacterStream(4, new StringReader(value));
                        break;
                    }
                    default: {
                        update_pairs_sp.setString(4, value);
                    }
                }
                update_pairs_sp.executeUpdate();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Error setting data , user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", uid: " + uid + ", nid: " + nid + ", value: " + value, e);
            }
        }
    }

    @Override
    public void setData(BareJID user_id, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user_id, null, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataList(BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        DataRepository repo;
        DataRepository dataRepository = repo = this.data_repo.takeRepoHandle(user_id);
        synchronized (dataRepository) {
            try {
                this.removeData(repo, user_id, subnode, key);
                try {
                    this.addDataList(repo, user_id, subnode, key, list);
                }
                catch (SQLException ex) {
                    throw new TigaseDBException("Problem adding data to DB, user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", list: " + Arrays.toString(list), ex);
                }
            }
            finally {
                this.data_repo.releaseRepoHandle(repo);
            }
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public boolean userExists(BareJID user) {
        try {
            this.getUserUID(null, user, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        return null;
    }

    @Override
    public boolean isUserDisabled(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.auth.isUserDisabled(user);
    }

    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        this.auth.setAccountStatus(user, status);
    }

    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        return this.auth.getAccountStatus(user);
    }

    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws UserNotFoundException, TigaseDBException {
        this.auth.setUserDisabled(user, value);
    }

    protected DataRepository getRepository() {
        return this.data_repo;
    }

    protected boolean isExceptionKeyViolation(SQLException ex) {
        String sqlState = ex.getSQLState();
        boolean keyViolation = false;
        switch (this.data_repo.getDatabaseType()) {
            case derby: {
                keyViolation = "X0Y78".equals(sqlState);
                break;
            }
            case postgresql: {
                keyViolation = "23505".equals(sqlState) || "23000".equals(sqlState);
                break;
            }
            default: {
                keyViolation = "23000".equals(sqlState);
            }
        }
        return keyViolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataList(DataRepository repo, BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, SQLException, UserNotFoundException {
        long uid = -2L;
        long nid = -2L;
        try {
            uid = this.getUserUID(repo, user_id, this.autoCreateUser);
            nid = this.getNodeNID(repo, uid, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Saving data adding data list, user_id: {0}, subnode: {1}, key: {2}, uid: {3}, nid: {4}, list: {5}", new Object[]{user_id, subnode, key, uid, nid, Arrays.toString(list)});
            }
            if (nid < 0L) {
                try {
                    nid = this.createNodePath(repo, user_id, subnode);
                }
                catch (SQLException e) {
                    nid = this.getNodeNID(repo, uid, subnode);
                }
            }
            PreparedStatement insert_key_val_st = null;
            insert_key_val_st = repo == null ? this.data_repo.getPreparedStatement(user_id, INSERT_KEY_VAL_QUERY) : repo.getPreparedStatement(user_id, INSERT_KEY_VAL_QUERY);
            PreparedStatement preparedStatement = insert_key_val_st;
            synchronized (preparedStatement) {
                insert_key_val_st.setLong(1, nid);
                insert_key_val_st.setLong(2, uid);
                insert_key_val_st.setString(3, key);
                for (String val : list) {
                    insert_key_val_st.setString(4, val);
                    insert_key_val_st.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Error adding data list, user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", uid: " + uid + ", nid: " + nid + ", list: " + Arrays.toString(list), e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeData(DataRepository repo, BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        block6: {
            try {
                long nid = this.getNodeNID(repo, user_id, subnode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Removing data, user_id: {0}, subnode: {1}, key: {2}, nid: {3}", new Object[]{user_id, subnode, key, nid});
                }
                PreparedStatement remove_key_data_st = null;
                remove_key_data_st = repo == null ? this.data_repo.getPreparedStatement(user_id, REMOVE_KEY_DATA_QUERY) : repo.getPreparedStatement(user_id, REMOVE_KEY_DATA_QUERY);
                if (nid <= 0L) break block6;
                PreparedStatement preparedStatement = remove_key_data_st;
                synchronized (preparedStatement) {
                    remove_key_data_st.setLong(1, nid);
                    remove_key_data_st.setString(2, key);
                    remove_key_data_st.executeUpdate();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Error getting subnodes list.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private long addNode(DataRepository repo, long uid, long parent_nid, String node_name) throws SQLException {
        ResultSet rs = null;
        PreparedStatement node_add_sp = null;
        node_add_sp = repo == null ? this.data_repo.getPreparedStatement(null, ADD_NODE_QUERY) : repo.getPreparedStatement(null, ADD_NODE_QUERY);
        PreparedStatement preparedStatement = node_add_sp;
        synchronized (preparedStatement) {
            block10: {
                long l;
                try {
                    if (parent_nid < 0L) {
                        node_add_sp.setNull(1, -5);
                    } else {
                        node_add_sp.setLong(1, parent_nid);
                    }
                    node_add_sp.setLong(2, uid);
                    node_add_sp.setString(3, node_name);
                    switch (this.data_repo.getDatabaseType()) {
                        default: 
                    }
                    rs = node_add_sp.executeQuery();
                    if (!rs.next()) break block10;
                    l = rs.getLong(1);
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                return l;
            }
            log.warning("Missing NID after adding new node...");
            long l = -1L;
            this.data_repo.release(null, rs);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserRepo(DataRepository repo, BareJID user_id) throws SQLException, UserExistsException {
        ResultSet rs = null;
        long uid = -1L;
        PreparedStatement user_add_sp = null;
        user_add_sp = repo == null ? this.data_repo.getPreparedStatement(user_id, ADD_USER_PLAIN_PW_QUERY) : repo.getPreparedStatement(user_id, ADD_USER_PLAIN_PW_QUERY);
        PreparedStatement preparedStatement = user_add_sp;
        synchronized (preparedStatement) {
            try {
                user_add_sp.setString(1, user_id.toString());
                user_add_sp.setNull(2, 12);
                log.log(Level.FINEST, "Adding non existing user to user-repository: " + user_id.toString());
                switch (this.data_repo.getDatabaseType()) {
                    default: 
                }
                rs = user_add_sp.executeQuery();
                if (rs != null && rs.next()) {
                    uid = rs.getLong(1);
                } else {
                    log.warning("Missing UID after adding new user...");
                }
                this.data_repo.release(null, rs);
            }
            catch (SQLException ex) {
                try {
                    if (this.isExceptionKeyViolation(ex)) {
                        throw new UserExistsException(user_id, "User already exist in the database", ex);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
        }
        this.cache.put(user_id.toString(), uid);
        return uid;
    }

    private String buildNodeQuery(long uid, String node_path) {
        String query = "select nid as nid1 from tig_nodes where (uid = " + uid + ") AND (parent_nid is null) AND (node = 'root')";
        if (node_path == null) {
            return query;
        }
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        int cnt = 1;
        String subquery = query;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            subquery = "select nid as nid" + ++cnt + ", node as node" + cnt + " from tig_nodes, (" + subquery + ") nodes" + (cnt - 1) + " where (parent_nid = nid" + (cnt - 1) + ") AND (node = '" + token + "')";
        }
        return subquery;
    }

    private long createNodePath(DataRepository repo, BareJID user_id, String node_path) throws SQLException, UserNotFoundException {
        if (node_path == null) {
            return this.getNodeNID(repo, user_id, null);
        }
        long uid = this.getUserUID(repo, user_id, this.autoCreateUser);
        long nid = this.getNodeNID(repo, uid, null);
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        StringBuilder built_path = new StringBuilder();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            built_path.append("/").append(token);
            long cur_nid = this.getNodeNID(repo, uid, built_path.toString());
            if (cur_nid > 0L) {
                nid = cur_nid;
                continue;
            }
            nid = this.addNode(repo, uid, nid, token);
        }
        return nid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubnode(DataRepository repo, long nid) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = repo == null ? this.data_repo.createStatement(null) : repo.createStatement(null);
            query = "delete from tig_pairs where nid = " + nid;
            stmt.executeUpdate(query);
            query = "delete from tig_nodes where nid = " + nid;
            stmt.executeUpdate(query);
        }
        finally {
            this.data_repo.release(stmt, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNodeNID(DataRepository repo, long uid, String node_path) throws SQLException, UserNotFoundException {
        String query = this.buildNodeQuery(uid, node_path);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        long nid = -1L;
        try {
            stmt = repo == null ? this.data_repo.createStatement(null) : repo.createStatement(null);
            rs = stmt.executeQuery(query);
            nid = rs.next() ? rs.getLong(1) : -1L;
            if (nid <= 0L) {
                if (node_path == null) {
                    log.log(Level.CONFIG, "Missing root node, database upgrade or bug in the code? Adding missing root node now.");
                    nid = this.addNode(repo, uid, -1L, DEF_ROOT_NODE);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Missing nid for node path: {0} and uid: {1}", new Object[]{node_path, uid});
                }
            }
            long l = nid;
            this.data_repo.release(stmt, rs);
            stmt = null;
            rs = null;
            return l;
        }
        catch (Throwable throwable) {
            this.data_repo.release(stmt, rs);
            stmt = null;
            rs = null;
            throw throwable;
        }
    }

    private long getNodeNID(DataRepository repo, BareJID user_id, String node_path) throws SQLException, UserNotFoundException {
        Long cache_res = (Long)this.cache.get(user_id + "/" + node_path);
        if (cache_res != null) {
            return cache_res;
        }
        long uid = this.getUserUID(repo, user_id, this.autoCreateUser);
        long result = this.getNodeNID(repo, uid, node_path);
        if (result > 0L) {
            this.cache.put(user_id + "/" + node_path, result);
        }
        return result;
    }

    private long getUserUID(DataRepository repo, BareJID user_id) throws SQLException {
        Long cache_res = (Long)this.cache.get(user_id.toString());
        if (cache_res != null) {
            return cache_res;
        }
        long result = this.getUserUIDDirect(repo, user_id);
        this.cache.put(user_id.toString(), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserUIDDirect(DataRepository repo, BareJID user_id) throws SQLException {
        long result = -1L;
        ResultSet rs = null;
        PreparedStatement uid_sp = null;
        uid_sp = repo == null ? this.data_repo.getPreparedStatement(user_id, GET_USER_DB_UID_QUERY) : repo.getPreparedStatement(user_id, GET_USER_DB_UID_QUERY);
        PreparedStatement preparedStatement = uid_sp;
        synchronized (preparedStatement) {
            try {
                uid_sp.setString(1, user_id.toString());
                rs = uid_sp.executeQuery();
                result = rs.next() ? rs.getLong(1) : -1L;
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        return result;
    }

    private long getUserUID(DataRepository repo, BareJID user_id, boolean autoCreate) throws SQLException, UserNotFoundException {
        long result = this.getUserUID(repo, user_id);
        if (result <= 0L) {
            if (autoCreate) {
                try {
                    result = this.addUserRepo(repo, user_id);
                }
                catch (UserExistsException ex) {
                    result = this.getUserUID(repo, user_id);
                }
            } else {
                throw new UserNotFoundException("User does not exist: " + user_id);
            }
        }
        return result;
    }

    public static interface IRepoCache<K, V> {
        public V get(Object var1);

        public V put(K var1, V var2);

        public V remove(Object var1);
    }

    private class RepoNoCache
    implements IRepoCache<String, Object> {
        private RepoNoCache() {
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            return null;
        }
    }

    private class RepoCache
    extends SimpleCache<String, Object>
    implements IRepoCache<String, Object> {
        public RepoCache(int maxsize, long cache_time) {
            super(maxsize, cache_time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(Object key) {
            if (this.cache_off) {
                return null;
            }
            RepoCache repoCache = this;
            synchronized (repoCache) {
                return super.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object put(String key, Object value) {
            if (this.cache_off) {
                return null;
            }
            RepoCache repoCache = this;
            synchronized (repoCache) {
                return super.put((Object)key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object remove(Object key) {
            if (this.cache_off) {
                return null;
            }
            RepoCache repoCache = this;
            synchronized (repoCache) {
                Object val = super.remove(key);
                String strk = key.toString();
                Iterator ks = this.keySet().iterator();
                while (ks.hasNext()) {
                    String k = ((String)ks.next()).toString();
                    if (!k.startsWith(strk)) continue;
                    ks.remove();
                }
                return val;
            }
        }
    }
}

