/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tigase.conf.ConfigReader;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ConfigWriter {
    private static final char[] RESTRICTED_CHARS = "=:,[]#+-*/@.".toCharArray();
    private int indent = 0;
    private boolean resolveVariables = false;

    public static Map<String, Object> buildTree(Map<String, Object> props) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        props.forEach((k, v) -> {
            String key2;
            String[] parts = k.split("/");
            Map map = result;
            Map parent = null;
            for (int i = 0; i < parts.length - 1; ++i) {
                parent = map;
                map = (Map)map.computeIfAbsent(parts[i], key -> new HashMap());
            }
            switch (key2 = parts[parts.length - 1]) {
                case "active": {
                    AbstractBeanConfigurator.BeanDefinition beanDefinition;
                    if (map instanceof AbstractBeanConfigurator.BeanDefinition) {
                        beanDefinition = (AbstractBeanConfigurator.BeanDefinition)map;
                    } else {
                        beanDefinition = new AbstractBeanConfigurator.BeanDefinition();
                        beanDefinition.setBeanName(parts[parts.length - 2]);
                        beanDefinition.putAll(map);
                        parent.put(beanDefinition.getBeanName(), beanDefinition);
                    }
                    beanDefinition.setActive(v instanceof Boolean ? ((Boolean)v).booleanValue() : "true".equals(v.toString()));
                    break;
                }
                case "class": {
                    AbstractBeanConfigurator.BeanDefinition beanDefinition;
                    if (map instanceof AbstractBeanConfigurator.BeanDefinition) {
                        beanDefinition = (AbstractBeanConfigurator.BeanDefinition)map;
                    } else {
                        beanDefinition = new AbstractBeanConfigurator.BeanDefinition();
                        beanDefinition.setBeanName(parts[parts.length - 2]);
                        beanDefinition.putAll(map);
                        parent.put(beanDefinition.getBeanName(), beanDefinition);
                    }
                    beanDefinition.setClazzName((String)v);
                    break;
                }
                default: {
                    Object old = map.get(key2);
                    if (old != null && old instanceof Map && v instanceof Map) {
                        ((Map)old).putAll((Map)v);
                        break;
                    }
                    map.put(key2, v);
                }
            }
        });
        return result;
    }

    public static boolean hasRestrictedChars(String str) {
        for (char ch : RESTRICTED_CHARS) {
            if (str.indexOf(ch) <= -1) continue;
            return true;
        }
        return false;
    }

    public ConfigWriter resolveVariables() {
        this.resolveVariables = true;
        return this;
    }

    public void write(File f, Map<String, Object> props) throws IOException {
        try (FileWriter writer = new FileWriter(f, false);){
            this.write(writer, props);
        }
    }

    public void write(Writer writer, Map<String, Object> props) throws IOException {
        this.writeMap(writer, props);
    }

    private void writeObject(Writer writer, Object obj) throws IOException {
        this.writeObject(writer, obj, "\n");
    }

    private void writeObject(Writer writer, Object obj, String newLine) throws IOException {
        if (obj == null) {
            writer.write("null");
            if (newLine != null) {
                writer.write(newLine);
            }
            return;
        }
        if (obj instanceof AbstractBeanConfigurator.BeanDefinition) {
            AbstractBeanConfigurator.BeanDefinition def = (AbstractBeanConfigurator.BeanDefinition)obj;
            writer.write("(");
            ++this.indent;
            boolean first = true;
            if (def.getClazzName() != null) {
                writer.write("class: ");
                writer.write(def.getClazzName());
                first = false;
            }
            if (!def.isActive()) {
                if (!first) {
                    writer.write(",");
                    writer.write("\n");
                    this.writeIndent(writer);
                }
                writer.write("active: false");
            }
            if (def.isExportable()) {
                if (!first) {
                    writer.write(",");
                    writer.write("\n");
                    this.writeIndent(writer);
                }
                writer.write("exportable: true");
            }
            --this.indent;
            if (def.isEmpty()) {
                writer.write(") {}");
            } else {
                writer.write(") {\n");
                ++this.indent;
                this.writeMap(writer, (Map)obj);
                --this.indent;
                this.writeIndent(writer);
                writer.write("}");
            }
            if (newLine != null) {
                writer.write(newLine);
            }
        } else if (obj instanceof ConfigReader.Variable) {
            if (this.resolveVariables) {
                this.writeObject(writer, ((ConfigReader.Variable)obj).calculateValue(), newLine);
            } else if (obj instanceof ConfigReader.EnvironmentVariable) {
                ConfigReader.EnvironmentVariable variable = (ConfigReader.EnvironmentVariable)obj;
                writer.write("env('");
                writer.write(variable.getName());
                if (variable.getDefValue() != null) {
                    writer.write("', '");
                    writer.write(variable.getDefValue());
                }
                writer.write("')");
                if (newLine != null) {
                    writer.write(newLine);
                }
            } else if (obj instanceof ConfigReader.PropertyVariable) {
                ConfigReader.PropertyVariable variable = (ConfigReader.PropertyVariable)obj;
                writer.write("prop('");
                writer.write(variable.getName());
                if (variable.getDefValue() != null) {
                    writer.write("', '");
                    writer.write(variable.getDefValue());
                }
                writer.write("')");
                if (newLine != null) {
                    writer.write(newLine);
                }
            } else if (obj instanceof ConfigReader.CompositeVariable) {
                ConfigReader.CompositeVariable variable = (ConfigReader.CompositeVariable)obj;
                List<Object> arguments = variable.getArguments();
                List<ConfigReader.CompositeVariable.Operation> operations = variable.getOperations();
                this.writeObject(writer, arguments.get(0), null);
                for (int i = 0; i < operations.size(); ++i) {
                    ConfigReader.CompositeVariable.Operation o = operations.get(i);
                    switch (o) {
                        case multiply: {
                            writer.write(" * ");
                            break;
                        }
                        case divide: {
                            writer.write(" / ");
                            break;
                        }
                        case add: {
                            writer.write(" + ");
                            break;
                        }
                        case substract: {
                            writer.write(" - ");
                        }
                    }
                    this.writeObject(writer, arguments.get(i + 1), null);
                }
                if (newLine != null) {
                    writer.write(newLine);
                }
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.isEmpty()) {
                writer.write("{}");
            } else {
                writer.write("{\n");
                ++this.indent;
                this.writeMap(writer, map);
                --this.indent;
                this.writeIndent(writer);
                writer.write("}");
            }
            if (newLine != null) {
                writer.write(newLine);
            }
        } else if (obj instanceof Collection) {
            List list = obj instanceof List ? (List)obj : new ArrayList((Collection)obj);
            boolean simple = true;
            for (Object o : list) {
                simple &= o instanceof Number || o instanceof String;
            }
            if (simple && list.size() < 6) {
                writer.write("[ ");
                this.writeListSimple(writer, list);
                writer.write(" ]");
                if (newLine != null) {
                    writer.write(newLine);
                }
            } else {
                writer.write("[\n");
                ++this.indent;
                this.writeList(writer, list);
                --this.indent;
                this.writeIndent(writer);
                writer.write("]");
                if (newLine != null) {
                    writer.write(newLine);
                }
            }
        } else if (obj.getClass().isArray()) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(obj); ++i) {
                tmp.add(Array.get(obj, i));
            }
            this.writeObject(writer, tmp);
        } else if (obj instanceof String) {
            writer.write(39);
            writer.write((String)obj);
            writer.write("'");
            if (newLine != null) {
                writer.write(newLine);
            }
        } else {
            if (obj instanceof JID || obj instanceof BareJID || obj instanceof Enum) {
                this.writeString(writer, obj.toString());
            } else {
                writer.write(obj.toString());
            }
            if (obj instanceof Long) {
                writer.write("L");
            }
            if (obj instanceof Float) {
                writer.write("f");
            }
            if (newLine != null) {
                writer.write(newLine);
            }
        }
    }

    private void writeMap(Writer writer, Map<String, Object> map) throws IOException {
        ArrayList<Map.Entry<String, Object>> items = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        items.sort((a, b) -> {
            boolean a_ = ((String)a.getKey()).startsWith("--");
            boolean b_ = ((String)b.getKey()).startsWith("--");
            if (a_ && !b_) {
                return -1;
            }
            if (!b_ && a_) {
                return 1;
            }
            if (a.getValue() instanceof Map && !(b.getValue() instanceof Map)) {
                return 1;
            }
            if (!(a.getValue() instanceof Map) && b.getValue() instanceof Map) {
                return -1;
            }
            if (a.getValue() instanceof Map && b.getValue() instanceof Map) {
                if ("dataSource".equals(a.getKey())) {
                    return -1;
                }
                if ("dataSource".equals(b.getKey())) {
                    return 1;
                }
                if ("userRepository".equals(a.getKey())) {
                    return -1;
                }
                if ("userRepository".equals(b.getKey())) {
                    return 1;
                }
                if ("authRepository".equals(a.getKey())) {
                    return -1;
                }
                if ("authRepository".equals(b.getKey())) {
                    return 1;
                }
            }
            return ((String)a.getKey()).compareTo((String)b.getKey());
        });
        for (Map.Entry entry : items) {
            this.writeIndent(writer);
            if (this.indent == 0 && ((String)entry.getKey()).startsWith("--")) {
                writer.write((String)entry.getKey());
            } else {
                this.writeString(writer, (String)entry.getKey());
            }
            if (entry.getValue() instanceof Map) {
                writer.write(" ");
            } else {
                writer.write(" = ");
            }
            if (this.indent == 0 && ((String)entry.getKey()).startsWith("--") && entry.getValue() instanceof String) {
                this.writeString(writer, (String)entry.getValue());
                writer.write("\n");
                continue;
            }
            this.writeObject(writer, entry.getValue());
        }
    }

    private void writeIndent(Writer writer) throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            writer.write("    ");
        }
    }

    private void writeList(Writer writer, List list) throws IOException {
        boolean first = true;
        for (Object obj : list) {
            if (!first) {
                writer.write(",\n");
            } else {
                first = false;
            }
            this.writeIndent(writer);
            this.writeObject(writer, obj, null);
        }
        if (!list.isEmpty()) {
            writer.write("\n");
        }
    }

    private void writeListSimple(Writer writer, List list) throws IOException {
        boolean first = true;
        for (Object obj : list) {
            if (!first) {
                writer.write(", ");
            } else {
                first = false;
            }
            this.writeObject(writer, obj, null);
        }
    }

    private void writeString(Writer writer, String str) throws IOException {
        if (str == null) {
            return;
        }
        if (ConfigWriter.hasRestrictedChars(str)) {
            writer.append('\'');
            writer.write(str);
            writer.append('\'');
        } else {
            writer.write(str);
        }
    }
}

