/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.passwordreset;

import java.util.HashMap;
import java.util.logging.Logger;
import tigase.auth.PasswordResetterIfc;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.extras.AbstractEmailSender;
import tigase.extras.mailer.Mailer;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.util.Token;
import tigase.xmpp.jid.BareJID;

@Bean(name="account-email-password-resetter", parent=Kernel.class, active=false, exportable=true)
public class EmailPasswordResetter
extends AbstractEmailSender
implements PasswordResetterIfc {
    public static final String EMAIL_PASSWORD_RESET_TOKEN = "email-password-reset-token";
    private static final Logger log = Logger.getLogger(EmailPasswordResetter.class.getCanonicalName());
    @Inject
    private AuthRepository authRepository;
    @Inject
    private Mailer mailer;
    @ConfigField(desc="URL of token verifier")
    private String tokenVerifierURL;
    @Inject
    private UserRepository userRepository;

    public EmailPasswordResetter() {
        super("Password reset", "mails/email-password-reset.template");
    }

    public void validateToken(String encodedToken) throws RepositoryException {
        Token token = Token.parse((String)encodedToken);
        String tokenHash = this.userRepository.getData(token.getJid(), EMAIL_PASSWORD_RESET_TOKEN);
        if (tokenHash == null) {
            throw new RuntimeException("Invalid token");
        }
        if (!token.getHash().equals(tokenHash)) {
            throw new RuntimeException("Invalid token");
        }
    }

    public void changePassword(String encodedToken, String password) throws RepositoryException {
        Token token = Token.parse((String)encodedToken);
        this.authRepository.updateCredential(token.getJid(), "default", password);
        this.userRepository.removeData(token.getJid(), EMAIL_PASSWORD_RESET_TOKEN);
    }

    public void sendToken(BareJID bareJID, String url) throws RepositoryException, Exception {
        Token token = Token.create((BareJID)bareJID);
        String email = this.userRepository.getData(bareJID, "email");
        this.userRepository.setData(bareJID, EMAIL_PASSWORD_RESET_TOKEN, token.getHash());
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("jid", bareJID);
        bindings.put("token", token);
        bindings.put("tokenEncoded", token.getEncoded());
        bindings.put("tokenVerifierURL", this.tokenVerifierURL == null ? url : this.tokenVerifierURL);
        this.sendMail(email, bindings);
    }
}

