/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.cluster;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.StanzaProcessor;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.meet.MeetComponent;
import tigase.meet.cluster.StrategyIfc;
import tigase.pubsub.cluster.ClusterNodesAware;
import tigase.pubsub.cluster.PubSubComponentClustered;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.Priority;
import tigase.sys.TigaseRuntime;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

@Bean(name="meet", parent=Kernel.class, active=false)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
@ClusterModeRequired(active=true)
public class MeetComponentClustered
extends MeetComponent {
    private static final Logger a = Logger.getLogger(MeetComponentClustered.class.getCanonicalName());
    private static final String b = "packet-forward-meet-cmd";
    private static final String c = "perm";
    private ClusterControllerIfc d;
    @Inject(nullAllowed=true)
    private List<ClusterNodesAware> clusterNodesAware = Collections.emptyList();
    private ComponentInfo e = null;
    @Inject
    private List<CommandListener> commandListeners;
    @Inject
    private StrategyIfc strategy;

    public void processPacket(Packet packet) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Received packet: {0}", packet);
        }
        try {
            JID jID = this.strategy.getNodeForPacket(packet);
            if (this.strategy.getLocalNodeJid().equals((Object)jID)) {
                a.log(Level.FINEST, () -> "packet, will be processed locally");
                super.processPacket(packet);
            } else {
                a.log(Level.FINEST, () -> "packet, will be processed by node: " + jID);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (packet.getPermissions() != null) {
                    hashMap.put(c, packet.getPermissions().name());
                }
                this.d.sendToNodes(b, hashMap, packet.getElement(), packet.getPacketFrom(), null, new JID[]{jID});
            }
        }
        catch (ComponentException componentException) {
            ((StanzaProcessor)this.kernel.getInstance(StanzaProcessor.class)).sendException(packet, componentException);
        }
    }

    public void register(Kernel kernel) {
        if (!ServerBeanSelector.getClusterMode((Kernel)kernel)) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"You've tried using Clustered version of the component but cluster-mode is disabled", "Shutting down system!"});
        }
        kernel.registerBean(PubSubComponentClustered.PacketForwardCommand.class).setActive(true).exec();
        super.register(kernel);
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.d != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                a.log(Level.CONFIG, "removing command listener " + commandListener.getName());
                this.d.removeCommandListener(commandListener);
            }
        }
        this.d = cl_controller;
        if (this.d != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                a.log(Level.CONFIG, "setting command listener " + commandListener.getName());
                this.d.setCommandListener(commandListener);
            }
        }
        this.kernel.registerBean("clusterController").asInstance((Object)cl_controller).exec();
    }

    public ComponentInfo getComponentInfo() {
        this.e = super.getComponentInfo();
        this.e.getComponentData().put(this.getComponentInfoClusteringStrategyKey(), this.strategy != null ? this.strategy.getClass() : null);
        return this.e;
    }

    protected String getComponentInfoClusteringStrategyKey() {
        return "PubSubClusteringStrategy";
    }

    public String getDiscoDescription() {
        return super.getDiscoDescription() + " acs-clustered";
    }

    public void setCommandListeners(List<CommandListener> commandListeners) {
        if (this.d != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                a.log(Level.CONFIG, "removing command listener " + commandListener.getName());
                this.d.removeCommandListener(commandListener);
            }
        }
        this.commandListeners = commandListeners;
        if (this.d != null && commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                a.log(Level.CONFIG, "setting command listener " + commandListener.getName());
                this.d.setCommandListener(commandListener);
            }
        }
    }

    public void setClusterNodesAware(List<ClusterNodesAware> clusterNodesAware) {
        if (clusterNodesAware == null) {
            clusterNodesAware = Collections.emptyList();
        }
        this.clusterNodesAware = clusterNodesAware;
    }

    @Bean(name="packetForwardCmd", parent=MeetComponentClustered.class, active=true)
    public static class PacketForwardCommand
    extends CommandListenerAbstract {
        @Inject(bean="service")
        private MeetComponentClustered component;

        public PacketForwardCommand() {
            super(MeetComponentClustered.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element element : packets) {
                try {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "processing forwarded packet = {0}", element.toString());
                    }
                    Packet packet = Packet.packetInstance((Element)element);
                    packet.setPacketFrom(fromNode);
                    if (data != null && data.get(MeetComponentClustered.c) != null) {
                        Permissions permissions = Permissions.valueOf((String)data.get(MeetComponentClustered.c));
                        packet.setPermissions(permissions);
                    }
                    if (this.component.addPacketNB(packet)) {
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", element.toString());
                        continue;
                    }
                    a.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", element.toString());
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    a.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                }
                catch (Throwable throwable) {
                    a.log(Level.SEVERE, "Exception processing forwarded packet = " + element.toString(), throwable);
                }
            }
        }
    }
}

