/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.commands;

import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.workgroupqueues.Config;
import tigase.workgroupqueues.WorkgroupQueuesComponent;
import tigase.workgroupqueues.commands.AbstractAdHocCommand;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="DeleteWorkgroupQueue", active=true)
public class DeleteWorkgroupQueue
extends AbstractAdHocCommand {
    @Inject
    private WorkgroupQueuesComponent component;
    @Inject
    private Config config;
    @Inject
    private Store store;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element element = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (element == null) {
                Form form = new Form("result", "Delete new Workgroup Queue", null);
                form.addField(Field.fieldTextSingle((String)"name", (String)"", (String)"Queue name"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(element);
                if ("submit".equals(form.getType())) {
                    Form form2;
                    String string = form.getAsString("name");
                    BareJID bareJID = BareJID.bareJIDInstance((String)string, (String)request.getIq().getTo().getDomain());
                    WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
                    if (workgroupQueueEntity != null) {
                        this.store.deleteWorkgroupQueue(workgroupQueueEntity.getJid());
                        form2 = new Form("result", "Workgroup Queue deleted", null);
                        form2.addField(Field.fieldTextSingle((String)"note", (String)"Operation successful", (String)"Note"));
                    } else {
                        form2 = new Form("result", "Workgroup Queue does not exist", null);
                        form2.addField(Field.fieldTextSingle((String)"note", (String)"Operation failed", (String)"Note"));
                    }
                    response.getElements().add(form2.getElement());
                }
                response.completeSession();
            }
        }
        catch (Exception exception) {
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    public String getName() {
        return "Delete Workgroup Queue";
    }

    public String getNode() {
        return "delete-workgroup-queue";
    }

    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

