/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.commands;

import java.util.Arrays;
import java.util.Date;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.workgroupqueues.Config;
import tigase.workgroupqueues.WorkgroupQueuesComponent;
import tigase.workgroupqueues.commands.AbstractAdHocCommand;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="CreateWorkgroupQueueCommand", active=true)
public class CreateWorkgroupQueue
extends AbstractAdHocCommand {
    @Inject
    private WorkgroupQueuesComponent component;
    @Inject
    private Config config;
    @Inject
    private Store store;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element element = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (element == null) {
                Form form = new Form("result", "Create new Workgroup Queue", null);
                form.addField(Field.fieldTextSingle((String)"name", (String)"", (String)"Queue name"));
                form.addField(Field.fieldTextSingle((String)"description", (String)"", (String)"Description"));
                form.addField(Field.fieldJidMulti((String)"agents", (String[])new String[0], (String)"Agents"));
                form.addField(Field.fieldTextSingle((String)"mucDomain", (String)(this.config.getDefaultMucDomain() == null ? "" : this.config.getDefaultMucDomain()), (String)"MUC Component domain"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(element);
                if ("submit".equals(form.getType())) {
                    String string2 = form.getAsString("name");
                    String string3 = form.getAsString("mucDomain");
                    String string4 = form.getAsString("description");
                    String[] stringArray = form.getAsStrings("agents");
                    BareJID[] bareJIDArray = (BareJID[])Arrays.asList(stringArray).stream().map(string -> BareJID.bareJIDInstanceNS((String)string)).toArray(BareJID[]::new);
                    WorkgroupQueueEntity workgroupQueueEntity = new WorkgroupQueueEntity(BareJID.bareJIDInstance((String)string2, (String)request.getIq().getTo().getDomain()));
                    workgroupQueueEntity.setDescription(string4);
                    workgroupQueueEntity.setAgents(bareJIDArray);
                    workgroupQueueEntity.setMucDomain(string3);
                    workgroupQueueEntity.setCreationDate(new Date());
                    workgroupQueueEntity.setCreatorJid(request.getSender().getBareJID());
                    this.store.addWorkgroupQueue(workgroupQueueEntity);
                    Form form2 = new Form("result", "Workgroup Queue created", null);
                    form2.addField(Field.fieldJidSingle((String)"jid", (String)workgroupQueueEntity.getJid().toString(), (String)"Queue JID"));
                    response.getElements().add(form2.getElement());
                }
                response.completeSession();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    public String getName() {
        return "Create Workgroup Queue";
    }

    public String getNode() {
        return "create-workgroup-queue";
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

