/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;

class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    KeyManager keyManager;

    ProvKeyManagerFactorySpi() {
    }

    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (keyStore == null) {
                Object object;
                String string;
                cArray = null;
                String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreType");
                if (string2 == null) {
                    string2 = KeyStore.getDefaultType();
                }
                keyStore = (string = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreProvider")) == null || string.length() < 1 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string);
                String string3 = null;
                String string4 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStore");
                if (string4 != null && new File(string4).exists()) {
                    string3 = string4;
                    object = PropertyUtils.getSystemProperty("javax.net.ssl.keyStorePassword");
                    if (object != null) {
                        cArray = ((String)object).toCharArray();
                    }
                }
                if (string3 == null) {
                    keyStore.load(null, null);
                } else {
                    object = new BufferedInputStream(new FileInputStream(string3));
                    keyStore.load((InputStream)object, cArray);
                    ((InputStream)object).close();
                }
            }
            this.keyManager = new ProvX509KeyManagerSimple(keyStore, cArray);
        }
        catch (Exception exception) {
            throw new KeyStoreException("initialization failed", exception);
        }
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof KeyStoreBuilderParameters) {
            List<KeyStore.Builder> list = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
            this.keyManager = new ProvX509KeyManager(list);
            return;
        }
        throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyManager != null) {
            return new KeyManager[]{this.keyManager};
        }
        throw new IllegalStateException("KeyManagerFactory not initialized");
    }
}

